/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.mobsp.plugin.form.scp.tender;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.scm.mobsp.business.helper.SourcingComponentConfigHelper;
import kd.scm.mobsp.common.entity.componentvo.SupFileEntryResult;
import kd.scm.mobsp.plugin.form.scp.tender.vo.TenderDetailVo;
import kd.scmc.msmob.business.helper.AttachmentHelper;
import kd.scmc.msmob.mvccore.IMobileApiEntryPage;
import kd.scmc.msmob.mvccore.MobileApiRendererUtils;
import kd.scmc.msmob.mvccore.MobileViewModelUtils;

public class SupFileEntryPlugin
extends AbstractMobBillPlugIn
implements IMobileApiEntryPage<TenderDetailVo, SupFileEntryResult, SupFileEntryResult>,
IDataModelChangeListener {
    private static final String PREVIOUS_BTN = "previous";
    private static final String NEXT_BTN = "next";
    private static final String NOTE = "packnote";
    private static final String ATTACHMENT = "attachmentfield";
    private static final String FILE_NAME = "filename";
    private static final String COMPLETE_BTN = "finish";
    private static final String RETURN_BTN = "returnbtn";
    private static final String PACKAGE = "package";

    public void initialize() {
        super.initialize();
        MobileApiRendererUtils.addDataModelChangeListener((AbstractFormPlugin)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MobileViewModelUtils.addPreviousAndNextListener((AbstractFormPlugin)this, (String)PREVIOUS_BTN, (String)NEXT_BTN);
        this.addClickListeners(new String[]{COMPLETE_BTN, PREVIOUS_BTN, NEXT_BTN});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        TenderDetailVo tenderDetailVo = (TenderDetailVo)((Object)MobileApiRendererUtils.renderEntryPage((AbstractFormPlugin)this));
        this.getPageCache().put("pkId", tenderDetailVo.getId() + "");
        Map<String, Boolean> viewConfig = SourcingComponentConfigHelper.setViewByConfig(this.getView(), tenderDetailVo.getId(), "tnd_tenderbill", "src_biddoc_tnd");
        this.setEditableAndVisible();
        this.setPackage(tenderDetailVo, viewConfig);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String changedPropertyName = e.getProperty().getName();
        if (ATTACHMENT.equals(changedPropertyName)) {
            this.setFileName();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        StringBuilder expireFileName = new StringBuilder();
        boolean checkResult = this.setAttachment(expireFileName);
        if (checkResult) {
            return;
        }
        String errorMsg = ResManager.loadKDString((String)"\u9644\u4ef6%s\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"SupFileEntryPlugin_0", (String)"scm-mobsp-form", (Object[])new Object[]{expireFileName});
        this.getView().showErrorNotification(errorMsg);
        e.setCancel(true);
        this.getView().updateView();
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (AttachmentHelper.checkAttachmentSaveOrNot((IFormView)this.getView())) {
            evt.setCancel(true);
        }
    }

    private void setEditableAndVisible() {
        IFormView view = this.getView();
        String entryDisplayMode = (String)view.getFormShowParameter().getCustomParam("entry_display_mode");
        if (entryDisplayMode.equals("view")) {
            view.setEnable(Boolean.valueOf(false), new String[]{NOTE, ATTACHMENT});
            view.setVisible(Boolean.valueOf(true), new String[]{RETURN_BTN});
            view.setVisible(Boolean.valueOf(false), new String[]{COMPLETE_BTN});
        } else {
            view.setEnable(Boolean.valueOf(true), new String[]{NOTE, ATTACHMENT});
            view.setVisible(Boolean.valueOf(false), new String[]{RETURN_BTN});
            view.setVisible(Boolean.valueOf(true), new String[]{COMPLETE_BTN});
        }
    }

    private void setFileName() {
        DynamicObjectCollection files = (DynamicObjectCollection)this.getModel().getValue(ATTACHMENT);
        if (files == null || files.isEmpty()) {
            this.getModel().setValue(FILE_NAME, null);
            return;
        }
        StringBuilder fileName = new StringBuilder();
        for (DynamicObject file : files) {
            String name = file.getDynamicObject("fbasedataid").getString("name");
            int lastDotIndex = name.lastIndexOf(".");
            String nameWithoutExt = name.substring(0, lastDotIndex);
            fileName.append(nameWithoutExt).append(",");
        }
        int lastCommaIndex = fileName.lastIndexOf(",");
        String combinedFileName = fileName.substring(0, lastCommaIndex);
        this.getModel().setValue(FILE_NAME, (Object)combinedFileName);
    }

    private boolean setAttachment(StringBuilder expireAttachName) {
        DynamicObjectCollection files = (DynamicObjectCollection)this.getModel().getValue(ATTACHMENT);
        boolean hasExpireFile = false;
        Iterator iterator = files.iterator();
        TempFileCache downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
        while (iterator.hasNext()) {
            String urlRemoveParam;
            DynamicObject file = (DynamicObject)iterator.next();
            DynamicObject fileData = file.getDynamicObject("fbasedataid");
            String url = fileData.getString("url");
            if (!StringUtils.isNotBlank((CharSequence)url) || !url.contains("configKey") || !url.contains("&kdedcba") || downLoad.exists(urlRemoveParam = url.substring(0, url.indexOf("&kdedcba")))) continue;
            expireAttachName.append(fileData.get("name")).append("\r\n");
            hasExpireFile = true;
            iterator.remove();
        }
        List<Map<String, Object>> filesWaitingToSave = SupFileEntryPlugin.buildAttachmentDataFromEdit(files, this.getView());
        List savedFiles = AttachmentFieldServiceHelper.saveAttachments((String)"tnd_tenderbill", (String)this.getView().getPageId(), filesWaitingToSave);
        ArrayList fileIdList = new ArrayList();
        savedFiles.forEach(attach -> fileIdList.add(attach.getLong("id")));
        HashMap<String, String> attachmentFieldMap = new HashMap<String, String>(2);
        attachmentFieldMap.put("PageId", this.getView().getPageId());
        attachmentFieldMap.put("PkId", this.getPageCache().get("pkId"));
        AttachmentFieldServiceHelper.saveTempAttachments((String)SerializationUtils.toJsonString(attachmentFieldMap));
        this.getModel().setValue(ATTACHMENT, (Object)fileIdList.toArray(new Long[0]));
        return !hasExpireFile;
    }

    public static List<Map<String, Object>> buildAttachmentDataFromEdit(DynamicObjectCollection sourceAttachCol, IFormView view) {
        ArrayList<Map<String, Object>> attachDataList = new ArrayList<Map<String, Object>>();
        sourceAttachCol.forEach(attach -> {
            DynamicObject attachObj = attach.getDynamicObject("fbasedataid");
            HashMap<String, Object> attachMap = new HashMap<String, Object>();
            attachMap.put("description", attachObj.getString("description"));
            attachMap.put("type", attachObj.getString("type"));
            attachMap.put("url", attachObj.getString("url"));
            String uid = attachObj.getString("uid");
            String newUid = "rc-upload-" + System.currentTimeMillis() + "-" + new SecureRandom().nextInt(100);
            attachMap.put("uid", uid == null || "".equals(uid) ? newUid : uid);
            attachMap.put("name", attachObj.getString("name"));
            attachMap.put("size", attachObj.get("size"));
            attachMap.put("fattachmentpanel", "attachmentpanel");
            attachMap.put("entityNum", view.getEntityId());
            attachMap.put("lastModified", System.currentTimeMillis());
            attachMap.put("status", "success");
            attachMap.put("client", null);
            attachDataList.add(attachMap);
        });
        return attachDataList;
    }

    private void setPackage(TenderDetailVo detailVo, Map<String, Boolean> viewConfig) {
        Boolean isShowPackageName = viewConfig.get(PACKAGE);
        String manageType = detailVo.getManageType();
        if ("2".equals(manageType) && isShowPackageName != null && isShowPackageName.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{PACKAGE});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{PACKAGE});
    }
}

