/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import kd.scm.pbd.domain.service.EsConfigService;
import kd.scm.pbd.domain.service.PbdDomainServiceFactory;

public class PbdEsSettingEdit
extends AbstractBasePlugIn {
    private static final String TREEENTRYENTITY = "treeentryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        String setting = (String)this.getView().getFormShowParameter().getCustomParam("setting");
        if (StringUtils.isEmpty((String)setting)) {
            return;
        }
        Map<String, Object> res = PbdEsSettingEdit.parseJson2Map(setting);
        this.getModel().beginInit();
        this.getModel().deleteEntryData(TREEENTRYENTITY);
        this.autoCreateEntry(res, 0, false);
        this.getModel().endInit();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(TREEENTRYENTITY);
        treeEntryGrid.setCollapse(false);
        this.getView().updateView();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("update_setting".equals(afterDoOperationEventArgs.getOperateKey())) {
            String fieldUpdate = (String)this.getModel().getValue("field_update");
            HashSet<String> canUpdateFields = new HashSet<String>(16);
            if (!StringUtils.isEmpty((String)fieldUpdate)) {
                canUpdateFields.addAll(Arrays.asList(fieldUpdate.split(",")));
            }
            canUpdateFields.removeIf(StringUtils::isEmpty);
            HashMap<String, String> settingsMap = new HashMap<String, String>();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(TREEENTRYENTITY);
            HashSet<String> subFieldKeySet = new HashSet<String>();
            HashMap<Long, String> idFieldKeyMap = new HashMap<Long, String>();
            for (DynamicObject entry : entryEntity) {
                Map parentValue;
                String fieldKey = entry.getString("fieldkey");
                if (!canUpdateFields.contains(fieldKey)) continue;
                String fieldType = entry.getString("fieldtype");
                Object value = entry.getString("fieldvalue");
                long id = entry.getLong("id");
                long pid = entry.getLong("pid");
                idFieldKeyMap.put(id, fieldKey);
                if ("STRUCT".equals(fieldType)) {
                    value = new HashMap();
                }
                settingsMap.put(fieldKey, (String)value);
                if (pid == 0L || (parentValue = (Map)settingsMap.get(idFieldKeyMap.get(pid))) == null) continue;
                parentValue.put(fieldKey, value);
                subFieldKeySet.add(fieldKey);
            }
            subFieldKeySet.forEach(settingsMap::remove);
            EsConfig esConfig = new EsConfig((Long)this.getView().getFormShowParameter().getCustomParam("esconfigid"));
            if (!settingsMap.isEmpty()) {
                ((EsConfigService)PbdDomainServiceFactory.serviceOf(EsConfigService.class, (String)esConfig.getRegion())).updateIndexSetting(esConfig, settingsMap);
            }
        }
    }

    private void autoCreateEntry(Object res, int rowIndex, boolean isInsert) {
        List list;
        if (Objects.isNull(res)) {
            return;
        }
        if (res instanceof Map) {
            TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
            String fieldUpdate = (String)this.getModel().getValue("field_update");
            HashSet<String> canUpdateFields = new HashSet<String>(16);
            if (!StringUtils.isEmpty((String)fieldUpdate)) {
                canUpdateFields.addAll(Arrays.asList(fieldUpdate.split(",")));
            }
            Map map = (Map)res;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                int index = isInsert ? this.getModel().insertEntryRow(TREEENTRYENTITY, rowIndex) : this.getModel().createNewEntryRow(TREEENTRYENTITY);
                this.getModel().setValue("fieldkey", (Object)key, index);
                if (!canUpdateFields.contains(key)) {
                    treeEntryGrid.setRowLock(true, new int[]{index});
                }
                this.resolveValue(value, index);
            }
        } else if (res instanceof List && !CollectionUtils.isEmpty((Collection)(list = (List)res))) {
            this.autoCreateEntry(list.get(0), rowIndex, Boolean.TRUE);
        }
    }

    private void resolveValue(Object value, int index) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl(TREEENTRYENTITY);
        if (value instanceof List) {
            this.getModel().setValue("fieldtype", (Object)"STRUCT", index);
            treeEntryGrid.setRowLock(true, new int[]{index});
            this.autoCreateEntry(value, index, Boolean.FALSE);
        } else if (value instanceof Map) {
            this.getModel().setValue("fieldtype", (Object)"STRUCT", index);
            treeEntryGrid.setRowLock(true, new int[]{index});
            this.autoCreateEntry(value, index, Boolean.TRUE);
        } else if (value instanceof Boolean) {
            this.getModel().setValue("fieldtype", (Object)"boolean", index);
            this.getModel().setValue("fieldvalue", value, index);
        } else if (value instanceof Double) {
            this.getModel().setValue("fieldtype", (Object)"decimal", index);
            this.getModel().setValue("fieldvalue", value, index);
        } else {
            this.getModel().setValue("fieldtype", (Object)"string", index);
            this.getModel().setValue("fieldvalue", value, index);
        }
    }

    private static Map<String, Object> parseJson2Map(String result) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (result.startsWith("{") && result.endsWith("}")) {
            return JSONObject.parseObject((String)result, (Feature[])new Feature[]{Feature.OrderedField});
        }
        return map;
    }
}

