/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.entity.OrderTrackDTO;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.helper.apiconnector.api.util.EcGroupApiUtil;
import kd.scm.common.util.ValidateMatchUtil;
import kd.scm.common.util.mal.MalNewOrderUtils;
import kd.scm.pbd.formplugin.PbdLogisticsPlugin;

public class PbdMalOrderLogisticsPlugin
extends PbdLogisticsPlugin
implements RowClickEventListener {
    private static Log log = LogFactory.getLog(PbdMalOrderLogisticsPlugin.class);

    @Override
    public void afterCreateNewData(EventObject e) {
        String source = (String)this.getView().getFormShowParameter().getCustomParam("platform");
        if (StringUtils.isNotBlank((CharSequence)source) && !source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_XY.getVal())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"packageid", "skuentryentity"});
        }
        this.getLogisticsData();
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", 0);
        if (null != dynamicObject) {
            this.showLogisticsDetailData(dynamicObject);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    protected void getLogisticsData() {
        String orderId;
        QFilter[] qFilters;
        AbstractCollection pkIds;
        HashMap<String, String> orderTrack;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billno = (String)formShowParameter.getCustomParam("billno");
        String source = (String)formShowParameter.getCustomParam("platform");
        HashMap<String, String> sendNoMap = new HashMap<String, String>(4);
        HashMap<String, String> sendNoPackageMap = new HashMap<String, String>(4);
        DynamicObjectCollection malOrderCol = this.getMalOrderEntity(billno, source);
        Map result = new HashMap(2);
        String pOrderId = "";
        DynamicObject malOrderColDyn = null;
        if (malOrderCol != null && !malOrderCol.isEmpty()) {
            malOrderColDyn = (DynamicObject)malOrderCol.get(0);
        }
        if (EcPlatformEnum.ECPLATFORM_JD.getVal().equalsIgnoreCase(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equalsIgnoreCase(source) || EcPlatformEnum.ECPLATFORM_XFS.getVal().equalsIgnoreCase(source)) {
            if (malOrderColDyn != null) {
                if (malOrderColDyn.getLong("oldOrder") != 0L) {
                    pOrderId = malOrderColDyn.getString("oldParentOrder");
                    for (DynamicObject malOrder : malOrderCol) {
                        String orderId2 = malOrder.getString("oldOrder");
                        HashMap orderTrack2 = new HashMap(malOrderCol.size());
                        Object data = null;
                        data = null != orderId2 ? (Map)EcGroupApiUtil.getEcOrderTrack(orderTrack2, (String)orderId2, (String)source).get(source) : (Map)EcGroupApiUtil.getEcOrderTrack(orderTrack2, (String)pOrderId, (String)source).get(source);
                        if (null == data) continue;
                        result.putAll(data);
                    }
                } else {
                    pOrderId = MalNewOrderUtils.getOrderId((String)source, (String)malOrderColDyn.getString("pOrder"));
                    orderTrack = new HashMap<String, String>(malOrderCol.size());
                    pkIds = new HashSet(malOrderCol.size());
                    for (DynamicObject malOrder : malOrderCol) {
                        if (null == malOrder.get("order") || 0L == malOrder.getLong("order")) {
                            pkIds.add(malOrderColDyn.getLong("pOrder"));
                            continue;
                        }
                        pkIds.add(malOrder.getLong("order"));
                    }
                    qFilters = new QFilter[]{new QFilter("id", "in", pkIds)};
                    DynamicObjectCollection orderCol = EcPlatformEnum.ECPLATFORM_JD.getVal().equals(source) || EcPlatformEnum.ECPLATFORM_JDPRO.getVal().equalsIgnoreCase(source) ? QueryServiceHelper.query((String)MalNewOrderUtils.getPlatformId((String)source), (String)"entryentity.goods.number sku,number orderid", (QFilter[])qFilters) : QueryServiceHelper.query((String)MalNewOrderUtils.getPlatformId((String)source), (String)"entryentity.goods.number sku,orderid", (QFilter[])qFilters);
                    for (Object order : orderCol) {
                        orderId = order.getString("orderid");
                        Map data = null;
                        data = null != orderId && !"0".equalsIgnoreCase(orderId) ? (Map)EcGroupApiUtil.getEcOrderTrack(orderTrack, (String)orderId, (String)source).get(source) : (Map)EcGroupApiUtil.getEcOrderTrack(orderTrack, (String)pOrderId, (String)source).get(source);
                        if (null == data) continue;
                        result.putAll(data);
                    }
                }
            }
        } else if (malOrderColDyn != null) {
            pOrderId = MalNewOrderUtils.getOrderId((String)source, (String)malOrderColDyn.getString("pOrder"));
            orderTrack = new HashMap(malOrderCol.size());
            pkIds = new ArrayList(malOrderCol.size());
            for (DynamicObject malOrder : malOrderCol) {
                pkIds.add(malOrder.getLong("order"));
            }
            qFilters = new QFilter[]{new QFilter("id", "in", (Object)pkIds)};
            String selectFields = "entryentity.goods.number sku,orderid";
            if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_XY.getVal())) {
                selectFields = "entryentity.goods.number sku,orderid,entryentity.packageid,entryentity.sendno";
            }
            DynamicObjectCollection orderCol = QueryServiceHelper.query((String)MalNewOrderUtils.getPlatformId((String)source), (String)selectFields, (QFilter[])qFilters);
            if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_XY.getVal())) {
                for (DynamicObject xyOrder : orderCol) {
                    String sendNo = xyOrder.getString("entryentity.sendno");
                    Map data = (Map)EcGroupApiUtil.getEcOrderTrack(orderTrack, (String)sendNo, (String)source).get(source);
                    if (null == data) continue;
                    sendNoMap.put(sendNo, pOrderId);
                    sendNoPackageMap.put(sendNo, xyOrder.getString("entryentity.packageid"));
                    result.putAll(data);
                }
            } else {
                for (DynamicObject order : orderCol) {
                    orderTrack.put(order.getString("sku"), order.getString("orderid"));
                }
                result = (Map)EcGroupApiUtil.getEcOrderTrack(orderTrack, (String)pOrderId, (String)source).get(source);
            }
        }
        String resultStr = SerializationUtils.toJsonString(result);
        this.getPageCache().put("orderTrackMap", resultStr);
        if (null != result && result.size() > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            int index = 0;
            for (Map.Entry orderTrack3 : result.entrySet()) {
                vs.set("source", (Object)source, index);
                orderId = (String)orderTrack3.getKey();
                if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_XY.getVal())) {
                    vs.set("packageid", sendNoPackageMap.get(orderId), index);
                    orderId = (String)sendNoMap.get(orderId);
                }
                OrderTrackDTO orderTrackDTO = (OrderTrackDTO)orderTrack3.getValue();
                vs.set("orderid", (Object)orderId, index);
                vs.set("logisticnumber", (Object)orderTrackDTO.getLogisticNumber(), index);
                vs.set("expresscompany", (Object)orderTrackDTO.getExpressCompany(), index);
                vs.set("billno", (Object)billno, index);
                String parentOrderId = orderTrackDTO.getpOrderId();
                if (null == parentOrderId || "0".equalsIgnoreCase(parentOrderId) || source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_XY.getVal())) {
                    parentOrderId = orderId;
                }
                vs.set("porderid", (Object)parentOrderId, index);
                ++index;
            }
            model.batchCreateNewEntryRow("entryentity", vs);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u7269\u6d41\u4fe1\u606f\u3002", (String)"PbdMalOrderLogisticsPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
    }

    public DynamicObjectCollection getMalOrderEntity(String billno, String source) {
        DynamicObjectCollection result = new DynamicObjectCollection();
        String selectProperties = "billno,cfmstatus, ecorderid pOrder, entryentity.order order, jdorderid oldParentOrder, entryentity.jdorder.number oldOrder";
        QFilter[] qFilters = new QFilter[]{new QFilter("billno", "=", (Object)billno), new QFilter("platform", "=", (Object)source)};
        result = QueryServiceHelper.query((String)"mal_order", (String)selectProperties, (QFilter[])qFilters);
        return result;
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        DynamicObject dynamicObject = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        if (null != dynamicObject) {
            this.showLogisticsDetailData(dynamicObject);
        }
    }

    protected void showLogisticsDetailData(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u7269\u6d41\u4fe1\u606f\u3002", (String)"PbdMalOrderLogisticsPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        String orderId = dynamicObject.getString("orderid");
        String sendNo = dynamicObject.getString("logisticnumber");
        String source = dynamicObject.getString("source");
        Map orderTrackMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("orderTrackMap"), Map.class);
        Map orderTrackDTO = (Map)orderTrackMap.get(orderId);
        if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_XY.getVal())) {
            orderTrackDTO = (Map)orderTrackMap.get(sendNo);
        }
        List orderLogistics = (List)orderTrackDTO.get("orderLogistics");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        model.deleteEntryData("childentryentity");
        int index = 0;
        for (int i = orderLogistics.size() - 1; i >= 0; --i) {
            String time = (String)((Map)orderLogistics.get(i)).get("msgTime");
            if (null != time && dynamicObject.getString("source").equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_SUNING.getVal()) && ValidateMatchUtil.isPositiveNumber((String)time)) {
                time = time.substring(0, 4) + "-" + time.substring(4, 6) + "-" + time.substring(6, 8) + " " + time.substring(8, 10) + ":" + time.substring(10, 12) + ":" + time.substring(12, 14);
            }
            vs.set("msgtime", (Object)time, index);
            vs.set("content", ((Map)orderLogistics.get(i)).get("content"), index++);
        }
        model.batchCreateNewEntryRow("childentryentity", vs);
        if (source.equalsIgnoreCase(EcPlatformEnum.ECPLATFORM_XY.getVal())) {
            String packageId = dynamicObject.getString("packageid");
            QFilter[] qFilters = new QFilter[]{new QFilter("orderid", "=", (Object)orderId).and(new QFilter("entryentity.sendno", "=", (Object)sendNo))};
            String selectFields = "entryentity.goods.number sku,entryentity.goods.name skuName,entryentity.goods.mainpic skuMainpic,orderid";
            DynamicObjectCollection orderCol = QueryServiceHelper.query((String)MalNewOrderUtils.getPlatformId((String)source), (String)selectFields, (QFilter[])qFilters);
            Map result = EcApiUtil.getXyOrderPackage((String)packageId);
            if (null == result.get("result") || null == result.get("success") || Boolean.valueOf(result.get("success").toString()).equals(Boolean.FALSE)) {
                return;
            }
            Map detail = (Map)result.get("result");
            TableValueSetter skuSetter = new TableValueSetter(new String[0]);
            model.deleteEntryData("skuentryentity");
            int tableIndex = 0;
            for (DynamicObject xyOrder : orderCol) {
                skuSetter.set("picture", xyOrder.get("skuMainpic"), tableIndex);
                skuSetter.set("skuname", xyOrder.get("skuName"), tableIndex);
                skuSetter.set("sku", xyOrder.get("sku"), tableIndex);
                List deliveryItems = (List)detail.get("deliveryItems");
                for (Map item : deliveryItems) {
                    if (null == item.get("skuId") || null == xyOrder.get("sku") || !item.get("skuId").toString().equalsIgnoreCase(xyOrder.get("sku").toString())) continue;
                    skuSetter.set("qty", item.get("num"), tableIndex);
                }
                ++tableIndex;
            }
            model.batchCreateNewEntryRow("skuentryentity", skuSetter);
        }
    }
}

