/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.user.UserServiceHelper;

public class PbdSwitchOrgPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        BillList billList = (BillList)this.getControl("billlistap");
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult hasPermOrgResult = UserServiceHelper.getUserChangeAbleOrg((long)userId, (boolean)true);
        QFilter orgFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs()).and("id", "!=", (Object)RequestContext.get().getOrgId());
        billList.setFilter(orgFilter);
        QFilter viewFilter = new QFilter("structure.view", "in", Arrays.asList(1L, 15L));
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(orgFilter.and(viewFilter));
        billList.setFilterParameter(filterParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if ("switch".equals(afterDoOperationEventArgs.getOperateKey()) && !selectedRows.isEmpty()) {
            this.switchOrg((Long)selectedRows.get(0).getPrimaryKeyValue(), false);
            this.returnDataToParent(selectedRows);
            this.getView().close();
        }
        if ("switch_default".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.switchOrg((Long)selectedRows.get(0).getPrimaryKeyValue(), true);
            this.returnDataToParent(selectedRows);
            this.getView().close();
        }
    }

    private void returnDataToParent(ListSelectedRowCollection selectedRows) {
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        returnData.put("orgId", selectedRows.get(0).getPrimaryKeyValue());
        returnData.put("setDefault", false);
        this.getView().returnDataToParent(returnData);
    }

    private void switchOrg(long orgId, boolean setDefault) {
        if (setDefault) {
            UserServiceHelper.setUserDefaultOrg((long)Long.parseLong(RequestContext.get().getUserId()), (long)orgId);
        }
        UserServiceHelper.switchUserDefaultOrg((long)orgId);
    }
}

