/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Hyperlink;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;

public class PbdUrlPanelPlugin
extends AbstractFormPlugin {
    private final String[] urlNumberSettings = new String[]{"pur_homepage", "scp_homepage", "srm_portal", "srmmainpage"};

    public void afterCreateNewData(EventObject e) {
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        requestContext.getLang().getLangTag();
        String domainContextUrl = UrlService.getDomainContextUrl();
        ArrayList deletePks = new ArrayList(this.urlNumberSettings.length);
        ArrayList availablePks = new ArrayList(this.urlNumberSettings.length);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_settingurl", (String)"id,number,url", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)this.urlNumberSettings)}, (String)"id");){
            dataSet.forEach(row -> {
                String url = row.getString("url");
                Long id = row.getLong("id");
                String number = row.getString("number");
                if (!(url.isEmpty() || url.contains(accountId) && url.contains(domainContextUrl) && !url.contains("isv"))) {
                    deletePks.add(id);
                }
                if (!url.isEmpty() && url.contains(accountId) && url.contains(domainContextUrl)) {
                    availablePks.add(id);
                }
                if (url.contains("#/dform") && "srm_portal".equals(number)) {
                    this.modifySrmPortalUrl();
                }
            });
        }
        if (!deletePks.isEmpty() || this.urlNumberSettings.length > availablePks.size()) {
            DeleteServiceHelper.delete((String)"pbd_settingurl", (QFilter[])new QFilter[]{new QFilter("id", "in", deletePks).or(new QFilter("id", "in", availablePks))});
            this.save();
        } else if (availablePks.isEmpty()) {
            this.save();
        }
        dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_settingurl", (String)"id,number,url", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)this.urlNumberSettings)}, (String)"id");
        var8_8 = null;
        try {
            while (dataSet.hasNext()) {
                Row row2 = dataSet.next();
                String url = row2.getString("url");
                String number = row2.getString("number");
                Hyperlink hyperlink = (Hyperlink)this.getControl(number + "h");
                hyperlink.setUrl(url);
                Label label = (Label)this.getControl(number + "l");
                label.setText(url);
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var8_8 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
    }

    protected void save() {
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        String domainContextUrl = UrlService.getDomainContextUrl();
        String spiltUser = "userId=guest";
        StringBuilder pur = new StringBuilder();
        StringBuilder srm = new StringBuilder();
        StringBuilder srmnew = new StringBuilder();
        StringBuilder scp = new StringBuilder();
        srm.append(domainContextUrl);
        pur.append(domainContextUrl);
        scp.append(domainContextUrl);
        srmnew.append(domainContextUrl);
        if (domainContextUrl.endsWith("/")) {
            srm.append("index.html");
            srmnew.append("kingdee/pur/srmmainpage/srmmainpage.html");
            pur.append("mobile.html");
            scp.append("mobile.html");
        } else {
            srm.append("/index.html");
            srmnew.append("/kingdee/pur/srmmainpage/srmmainpage.html");
            pur.append("/mobile.html");
            scp.append("/mobile.html");
        }
        DynamicObject srmUrl = BusinessDataServiceHelper.newDynamicObject((String)"pbd_settingurl");
        srmUrl.set("number", (Object)"srm_portal");
        srmUrl.set("name", (Object)"srm_portal");
        srm.append('?').append(spiltUser).append("&accountId=").append(accountId).append("&appNumber=srm&formId=srm_portal");
        srmUrl.set("url", (Object)srm);
        DynamicObject srmNewUrl = BusinessDataServiceHelper.newDynamicObject((String)"pbd_settingurl");
        srmNewUrl.set("number", (Object)"srmmainpage");
        srmNewUrl.set("name", (Object)"srmmainpage");
        srmnew.append('?').append(spiltUser).append("&accountId=").append(accountId).append("#/");
        srmNewUrl.set("url", (Object)srmnew);
        DynamicObject purUrl = BusinessDataServiceHelper.newDynamicObject((String)"pbd_settingurl");
        purUrl.set("number", (Object)"pur_homepage");
        purUrl.set("name", (Object)"pur_homepage");
        pur.append("?accountId=").append(accountId).append("#/form/pur_homepage?accountId=").append(accountId);
        purUrl.set("url", (Object)pur);
        DynamicObject scpUrl = BusinessDataServiceHelper.newDynamicObject((String)"pbd_settingurl");
        scpUrl.set("number", (Object)"scp_homepage");
        scpUrl.set("name", (Object)"scp_homepage");
        scp.append("?accountId=").append(accountId).append("#/form/scp_homepage?accountId=").append(accountId);
        scpUrl.set("url", (Object)scp);
        OperationResult saveOperate = SaveServiceHelper.saveOperate((String)"pbd_settingurl", (DynamicObject[])new DynamicObject[]{scpUrl, srmUrl, purUrl, srmNewUrl}, (OperateOption)OperateOption.create());
        if (saveOperate.isSuccess()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u91c7\u8d2d\u4e91\uff1a\u4f9b\u5e94\u5546\u95e8\u6237\u3001\u91c7\u8d2d\u534f\u540c\u79fb\u52a8\u5e94\u7528\u3001\u4f9b\u5e94\u534f\u540c\u79fb\u52a8\u5e94\u7528\u914d\u7f6e\u6210\u529f\u3002", (String)"PbdUrlPanelPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.None);
        }
    }

    private void modifySrmPortalUrl() {
        DynamicObject[] srm_portal = BusinessDataServiceHelper.load((String)"pbd_settingurl", (String)"id,number,url", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"srm_portal")});
        StringBuilder srm = new StringBuilder();
        RequestContext requestContext = RequestContext.get();
        String accountId = requestContext.getAccountId();
        String domainContextUrl = UrlService.getDomainContextUrl();
        String spiltUser = "userId=guest";
        if (Objects.nonNull(srm_portal) && srm_portal.length > 0) {
            for (DynamicObject dynamicObject : srm_portal) {
                srm.append(domainContextUrl);
                if (domainContextUrl.endsWith("/")) {
                    srm.append("index.html");
                } else {
                    srm.append("/index.html");
                }
                srm.append('?').append(spiltUser).append("&accountId=").append(accountId).append("&appNumber=srm&formId=srm_portal");
                dynamicObject.set("url", (Object)srm);
            }
            SaveServiceHelper.save((DynamicObject[])srm_portal);
        }
    }
}

