/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;

public class PurEasBotpListPlugin
extends AbstractFormPlugin {
    public static final String TOBILLTYPE = "tobilltype";
    public static final String RULE = "rule";
    public static final String PKSTR = "pkstr";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillRulesData();
    }

    private void fillRulesData() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        IDataModel model = this.getModel();
        String toBillType = String.valueOf(param.get(TOBILLTYPE));
        model.setValue(TOBILLTYPE, (Object)toBillType);
        model.setValue(PKSTR, param.get(PKSTR));
        List ruleList = (List)param.get("rules");
        if (ruleList != null) {
            ArrayList<ComboItem> ruleItems = new ArrayList<ComboItem>(ruleList.size());
            for (Object rule : ruleList) {
                Map ruleMap = (Map)rule;
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(String.valueOf(ruleMap.get("number")));
                ruleItem.setCaption(new LocaleString(String.valueOf(ruleMap.get("alias"))));
                ruleItems.add(ruleItem);
            }
            ComboEdit ruleCombo = (ComboEdit)this.getView().getControl(RULE);
            ruleCombo.setComboItems(ruleItems);
            if (ruleItems.size() == 0) {
                model.setValue(RULE, (Object)"");
            } else {
                model.setValue(RULE, (Object)((ComboItem)ruleItems.get(0)).getValue());
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control srcCtrl = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(srcCtrl.getKey())) {
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            Object rule = model.getValue(RULE);
            returnData.put(RULE, rule);
            returnData.put(TOBILLTYPE, model.getValue(TOBILLTYPE));
            returnData.put(PKSTR, model.getValue(PKSTR));
            view.returnDataToParent(returnData);
            view.close();
        }
    }
}

