/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.helper.scdatahandle.ScDataHandleServiceHelper;
import kd.scm.common.helper.scdatahandle.entity.ScDataHandleInfo;

public final class ScDataHandleFireTestPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String CONFIG_ENTITY = "serviceentity";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initDataList();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"scdatahandle")) {
            this.initDataList();
        }
    }

    private void initDataList() {
        ComboEdit schandleexcutedata = (ComboEdit)this.getView().getControl("schandleexcutedata");
        if (schandleexcutedata != null) {
            this.getModel().setValue("schandleexcutedata", null);
            DynamicObject scdatahandle = this.getModel().getDataEntity().getDynamicObject("scdatahandle");
            if (scdatahandle != null) {
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
                ComboItem operate = null;
                String entity = scdatahandle.getDynamicObject("entity").getString("id");
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
                if (mainEntityType instanceof BillEntityType) {
                    BillEntityType billEntityType = (BillEntityType)mainEntityType;
                    String billNo = billEntityType.getBillNo();
                    String pkName = billEntityType.getPrimaryKey().getName();
                    StringBuilder selectFiled = new StringBuilder();
                    selectFiled.append(billNo).append(",").append(pkName);
                    QFilter qFilter = new QFilter("id", "!=", (Object)0);
                    String handleconfig = scdatahandle.getString("handleconfig");
                    if (handleconfig != null && !handleconfig.isEmpty()) {
                        try {
                            ScDataHandleInfo scDataHandleInfo = (ScDataHandleInfo)SerializationUtils.fromJsonString((String)handleconfig, ScDataHandleInfo.class);
                            String filterValue = scDataHandleInfo.getFilterValue();
                            String handleProperty = scDataHandleInfo.getHandleProperty();
                            if (StringUtils.isNotBlank((CharSequence)filterValue) && StringUtils.isNotBlank((CharSequence)handleProperty)) {
                                qFilter.and(new QFilter(handleProperty, "=", (Object)filterValue));
                            }
                        }
                        catch (Exception scDataHandleInfo) {
                            // empty catch block
                        }
                    }
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)entity, (String)"id,billno", (QFilter[])new QFilter[]{qFilter}, (String)"billno desc", (int)366);){
                        while (dataSet.hasNext()) {
                            Row row = dataSet.next();
                            operate = new ComboItem(new LocaleString(row.getString("billno")), row.getString("id"));
                            comboItems.add(operate);
                        }
                    }
                    schandleexcutedata.setComboItems(comboItems);
                }
                DynamicObjectCollection refentity = scdatahandle.getDynamicObjectCollection("refentity");
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.deleteEntryData(CONFIG_ENTITY);
                if (refentity != null) {
                    TableValueSetter ts = new TableValueSetter(new String[0]);
                    int i = 0;
                    for (DynamicObject row : refentity) {
                        ts.set("scdataservice", (Object)row.getDynamicObject("scdataservice").getString("id"), i);
                        ts.set("scserviceconfig", (Object)row.getString("scserviceconfig"), i);
                        ++i;
                    }
                    model.beginInit();
                    model.batchCreateNewEntryRow(CONFIG_ENTITY, ts);
                    model.endInit();
                    this.getView().updateView(CONFIG_ENTITY);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "barexcute": {
                boolean isSuperAdminType = PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId());
                if (!isSuperAdminType) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u4e0d\u8db3", (String)"ScDataHandleFireTestPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject scdatahandle = this.getModel().getDataEntity().getDynamicObject("scdatahandle");
                if (scdatahandle == null) return;
                String schandleexcutedata = this.getModel().getDataEntity().getString("schandleexcutedata");
                if (schandleexcutedata == null) return;
                String[] verifyKeys = schandleexcutedata.split(",");
                HashSet<Long> valuesKeys = new HashSet<Long>(verifyKeys.length);
                for (String v : verifyKeys) {
                    if (v == null || v.isEmpty()) continue;
                    valuesKeys.add(Long.valueOf(v));
                }
                String number = scdatahandle.getString("number");
                String entity = scdatahandle.getDynamicObject("entity").getString("id");
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])valuesKeys.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entity));
                if (dynamicObjects == null) return;
                if (dynamicObjects.length <= 0) return;
                ScDataHandleResult scDataHandleResult = ScDataHandleServiceHelper.executeHandle((String)number, (DynamicObject[])dynamicObjects);
                if (scDataHandleResult == null) return;
                BaseShowParameter formShowParameter = null;
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"pbd_scdatahandlefail", (String)"pbd_scdatahandlefail", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)scDataHandleResult.getScDataFailId())}, (String)"id", (int)1);){
                    while (dataSet.hasNext()) {
                        formShowParameter = new BaseShowParameter();
                        formShowParameter.setPkId((Object)dataSet.next().getString("id"));
                        formShowParameter.setBillStatus(BillOperationStatus.VIEW);
                        formShowParameter.setFormId("pbd_scdatahandlefail");
                    }
                }
                if (formShowParameter == null) {
                    String handleData = dynamicObjects[0].getString("id");
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"pbd_scdatahandlelog", (String)"pbd_scdatahandlelog", (String)"id,config_tag", (QFilter[])new QFilter[]{new QFilter("scdatahandle", "=", (Object)scdatahandle.getString("id"))}, (String)"opdate desc", (int)20);){
                        while (dataSet.hasNext()) {
                            Row row = dataSet.next();
                            String configTag = row.getString("config_tag");
                            if (configTag == null || !configTag.contains(handleData)) continue;
                            formShowParameter = new BaseShowParameter();
                            formShowParameter.setPkId((Object)row.getString("id"));
                            formShowParameter.setBillStatus(BillOperationStatus.VIEW);
                            formShowParameter.setFormId("pbd_scdatahandlelog");
                        }
                    }
                }
                if (formShowParameter == null) return;
                formShowParameter.getOpenStyle().setTargetKey("fs_resultinfo");
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                this.getView().showForm((FormShowParameter)formShowParameter);
                return;
            }
        }
    }
}

