/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.apiconfig;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.pbd.common.entity.FieldProp;
import kd.scm.pbd.common.utils.FieldPropUtils;
import kd.scm.pbd.formplugin.util.MetadataUtils;
import kd.scm.pbd.formplugin.util.PbdCreditPluginUtils;

public class PbdStructEditPlugin
extends AbstractBillPlugIn {
    private static final int INITIAL_SIZE = 8;
    private static Log log = LogFactory.getLog(PbdStructEditPlugin.class);
    private static final String INPUTSFIELDID_CALLBACK = "INPUTSFIELDID_CALLBACK";
    private static final String OUTPUTSFIELDID_CALLBACK = "OUTPUTSFIELDID_CALLBACK";
    private static final String BILL = "bill";
    private static final String ENTITYCODE = "entitycode";
    private static final String SOURCE = "source";
    private static final String TYPE = "type";
    protected static String struct_data = "pbd_struct_data_%S_%S";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"inputsfieldid", "outputsfieldid"});
        this.addItemClickListeners(new String[]{"advcon_inputs", "inputsimportstruts"});
        this.addItemClickListeners(new String[]{"advcon_outputs", "outputsimportstruts"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        this.typeChange();
        this.setEntitycode(view, model, false);
        this.setCollapse();
    }

    private void setCollapse() {
        TreeEntryGrid outputsTreeGrid = (TreeEntryGrid)this.getControl("outputsentity");
        outputsTreeGrid.setCollapse(false);
        TreeEntryGrid intputsTreeGrid = (TreeEntryGrid)this.getControl("inputsentity");
        intputsTreeGrid.setCollapse(false);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        model.beginInit();
        IFormView view = this.getView();
        ChangeData[] changeSet = e.getChangeSet();
        switch (propertyName) {
            case "type": {
                this.typeChange();
                this.doClearEntity(model, changeSet, TYPE);
                break;
            }
            case "source": {
                this.doClearEntity(model, changeSet, SOURCE);
                this.setEntitycode(view, model, true);
                break;
            }
            case "entitycode": {
                List<String> asList = PbdStructEditPlugin.getCheckedEntityCode(model);
                if (asList == null) {
                    return;
                }
                DynamicObject source = model.getDataEntity().getDynamicObject(SOURCE);
                if (source == null) {
                    return;
                }
                String entityKey = source.getString("number");
                FormMetadata formmeta = MetadataUtils.getFormMetaData(entityKey);
                Map<String, List<ControlAp<?>>> proEntitykey = MetadataUtils.getProEntitykey(formmeta, asList);
                List<FieldProp> fieldProps = MetadataUtils.getProItemMap(proEntitykey);
                List<FieldProp> entityAps = MetadataUtils.getEntityAp(formmeta);
                this.putCache(model, formmeta, entityAps, entityKey);
                model.deleteEntryData("outputsentity");
                String isv = formmeta.getIsv();
                Map<String, Integer> entityIndexMap = this.createOutputsEntityProp(model, isv, entityAps, fieldProps);
                if (CollectionUtils.isEmpty(entityIndexMap)) break;
                int[] rows = new int[entityIndexMap.size()];
                int i = 0;
                for (Map.Entry<String, Integer> entry : entityIndexMap.entrySet()) {
                    rows[i] = entry.getValue();
                    ++i;
                }
                TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("outputsentity");
                treeEntryGrid.expand(rows);
                break;
            }
            case "inputsfieldid": {
                PbdCreditPluginUtils.doClearFieldValue(model, "inputsfieldname", changeSet);
                PbdCreditPluginUtils.doClearFieldValue(model, "inputsfieldtype", changeSet);
                break;
            }
            case "outputsfieldid": {
                PbdCreditPluginUtils.doClearFieldValue(model, "outputsfieldname", changeSet);
                PbdCreditPluginUtils.doClearFieldValue(model, "outputsfieldtype", changeSet);
                break;
            }
        }
        model.endInit();
        view.updateView();
    }

    private void typeChange() {
        String type = this.getModel().getDataEntity().getString(TYPE);
        if (type != null) {
            BasedataEdit source = (BasedataEdit)this.getView().getControl(SOURCE);
            MulComboEdit entitycode = (MulComboEdit)this.getView().getControl(ENTITYCODE);
            switch (type) {
                case "1": {
                    source.setMustInput(true);
                    entitycode.setMustInput(true);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{SOURCE});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{ENTITYCODE});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"inputsimportstruts"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"inputsimportstruts"});
                    break;
                }
                case "2": {
                    source.setMustInput(false);
                    entitycode.setMustInput(false);
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{SOURCE});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTITYCODE});
                    this.getModel().setValue(SOURCE, null);
                    this.getModel().setValue(ENTITYCODE, null);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"inputsimportstruts"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"outputsimportstruts"});
                    break;
                }
            }
        }
    }

    private static List<String> getCheckedEntityCode(IDataModel model) {
        String entityCodes = model.getDataEntity().getString(ENTITYCODE);
        if (entityCodes == null) {
            return new ArrayList<String>(8);
        }
        String[] splitArray = entityCodes.split(",");
        List<String> asList = Arrays.asList(splitArray);
        return asList;
    }

    private Integer createOutputsEntity(IDataModel model1, String isv, String key, Integer rowIndex, List<FieldProp> entityAps, Map<String, Integer> entityIndexMap, boolean ischild) {
        if (StringUtils.isBlank((String)key)) {
            return rowIndex;
        }
        if (!BILL.equals(key)) {
            FieldProp fieldProp = entityAps.stream().filter(e -> e.getKey().equals(key)).findFirst().get();
            String parentKey = fieldProp.getParentKey();
            if (StringUtils.isNotBlank((String)parentKey)) {
                Integer parentRowIndex;
                rowIndex = parentRowIndex = this.createOutputsEntity(model1, isv, parentKey, rowIndex, entityAps, entityIndexMap, Boolean.TRUE);
                entityIndexMap.put(parentKey, rowIndex);
            } else {
                ischild = true;
            }
            rowIndex = !entityIndexMap.containsKey(key) ? (ischild ? Integer.valueOf(this.getModel().createNewEntryRow("outputsentity")) : Integer.valueOf(this.getModel().insertEntryRow("outputsentity", rowIndex.intValue()))) : entityIndexMap.get(key);
            String parentName = fieldProp.getName();
            model1.setValue("outputsfieldid", (Object)key, rowIndex.intValue());
            model1.setValue("outputsfieldname", (Object)parentName, rowIndex.intValue());
            model1.setValue("outputsfieldtype", (Object)"STRUCT", rowIndex.intValue());
            if ("kingdee".equals(isv)) {
                model1.setValue("outputskeystatus", (Object)"PU", rowIndex.intValue());
            } else {
                model1.setValue("outputskeystatus", (Object)"NEW", rowIndex.intValue());
            }
            model1.setValue("outputsisarray", (Object)true, rowIndex.intValue());
            model1.setValue("outputskeyisv", (Object)isv, rowIndex.intValue());
        }
        return rowIndex;
    }

    private Map<String, Integer> createOutputsEntityProp(IDataModel model1, String isv, List<FieldProp> entityAps, List<FieldProp> fieldProps) {
        HashMap<String, Integer> entityIndexMap = new HashMap<String, Integer>(8);
        int rowIndex = 0;
        for (FieldProp fieldProp : fieldProps) {
            String parentKey = fieldProp.getParentKey();
            if (BILL.equals(parentKey)) {
                rowIndex = this.getModel().createNewEntryRow("outputsentity");
            } else {
                if (!entityIndexMap.containsKey(parentKey)) {
                    rowIndex = this.createOutputsEntity(model1, isv, parentKey, rowIndex, entityAps, entityIndexMap, Boolean.FALSE);
                    entityIndexMap.put(parentKey, rowIndex);
                } else {
                    rowIndex = (Integer)entityIndexMap.get(parentKey);
                }
                rowIndex = model1.insertEntryRow("outputsentity", rowIndex);
            }
            model1.setValue("outputsfieldid", (Object)fieldProp.getKey(), rowIndex);
            model1.setValue("outputsfieldname", (Object)fieldProp.getName(), rowIndex);
            model1.setValue("outputsfieldtype", (Object)fieldProp.getDataType(), rowIndex);
            model1.setValue("outputsisarray", (Object)false, rowIndex);
            if ("kingdee".equals(isv)) {
                model1.setValue("outputskeystatus", (Object)"PU", rowIndex);
            } else {
                model1.setValue("outputskeystatus", (Object)"NEW", rowIndex);
            }
            model1.setValue("outputskeyisv", (Object)isv, rowIndex);
        }
        return entityIndexMap;
    }

    private void doClearEntity(IDataModel model, ChangeData[] changeDatas, String propertyName) {
        boolean flag = false;
        if (TYPE.equals(propertyName)) {
            for (ChangeData changeData : changeDatas) {
                Object newValue = changeData.getNewValue();
                if (!"2".equals(newValue.toString())) continue;
                flag = true;
                break;
            }
        } else if (SOURCE.equals(propertyName)) {
            for (ChangeData changeData : changeDatas) {
                Object newValue = changeData.getNewValue();
                if (newValue != null && !StringUtils.isEmpty((String)changeData.getNewValue().toString())) continue;
                flag = true;
                break;
            }
        }
        if (flag) {
            model.deleteEntryData("inputsentity");
            model.deleteEntryData("outputsentity");
        }
    }

    private void setEntitycode(IFormView view, IDataModel model, boolean update) {
        DynamicObject source = model.getDataEntity().getDynamicObject(SOURCE);
        if (source == null) {
            return;
        }
        String entityKey = source.getString("number");
        FormMetadata formmeta = MetadataUtils.getFormMetaData(entityKey);
        if (formmeta == null) {
            return;
        }
        String isv = formmeta.getIsv();
        String isvCacheKey = String.format(struct_data, "isv", this.getView().getPageId());
        this.getPageCache().put(isvCacheKey, isv);
        List<FieldProp> entityAps = MetadataUtils.getEntityAp(formmeta);
        MulComboEdit mulComboEdit = (MulComboEdit)view.getControl(ENTITYCODE);
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(8);
        String loadResFormat = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5355\u636e", (String)"PbdStructEditPlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdStructEditPlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
        list.add(new ComboItem(new LocaleString(loadResFormat), BILL));
        for (FieldProp entry : entityAps) {
            String key = entry.getKey();
            String value = entry.getName();
            ComboItem comboItem = new ComboItem(new LocaleString(value), key);
            list.add(comboItem);
        }
        mulComboEdit.setComboItems(list);
        String entitycode = view.getModel().getDataEntity().getString(ENTITYCODE);
        if (StringUtils.isNotEmpty((String)entitycode)) {
            List<String> entityKeyList = PbdStructEditPlugin.getEntityKeyList(entitycode);
            if (CollectionUtils.isEmpty(entityKeyList)) {
                view.getModel().setValue(ENTITYCODE, (Object)BILL);
            } else {
                view.getModel().setValue(ENTITYCODE, (Object)entitycode);
            }
        } else {
            view.getModel().setValue(ENTITYCODE, (Object)BILL);
        }
        this.putCache(model, formmeta, entityAps, entityKey);
        if (update) {
            ArrayList<String> billEntry = new ArrayList<String>(8);
            billEntry.add(BILL);
            Map<String, List<ControlAp<?>>> proEntitykey = MetadataUtils.getProEntitykey(formmeta, billEntry);
            List<FieldProp> fieldProps = MetadataUtils.getProItemMap(proEntitykey);
            model.deleteEntryData("outputsentity");
            this.createOutputsEntityProp(model, isv, entityAps, fieldProps);
        }
    }

    private static List<String> getEntityKeyList(String standardEntityKeys) {
        ArrayList<String> entityKeyList = new ArrayList<String>(8);
        if (StringUtils.isNotBlank((String)standardEntityKeys)) {
            String[] entityKeys;
            for (String entityKey : entityKeys = standardEntityKeys.split(",")) {
                if ("".equals(entityKey)) continue;
                entityKeyList.add(entityKey);
            }
        }
        return entityKeyList;
    }

    private void putCache(IDataModel model, FormMetadata formmeta, List<FieldProp> entityAps, String entityKey) {
        String entityCacheKey = String.format(struct_data, "entity", this.getView().getPageId());
        this.getPageCache().put(entityCacheKey, JSON.toJSONString(entityAps));
        List<String> asList = PbdStructEditPlugin.getCheckedEntityCode(model);
        Map<String, List<ControlAp<?>>> proAllEntitykey = MetadataUtils.getProEntitykey(formmeta, asList);
        List<FieldProp> allFieldProps = MetadataUtils.getProItemMap(proAllEntitykey);
        List selectEntityAps = entityAps.stream().filter(e -> asList.contains(e.getKey())).collect(Collectors.toList());
        allFieldProps.addAll(selectEntityAps);
        String fieldCacheKey = String.format(struct_data, "allfield", this.getView().getPageId());
        this.getPageCache().put(fieldCacheKey, JSON.toJSONString(allFieldProps));
        String inputFieldCacheKey = String.format(struct_data, "allinputfield", this.getView().getPageId());
        if ("pbd_business_info".equals(entityKey) || "pbd_supplier_monitor".equals(entityKey)) {
            Map<String, List<ControlAp<?>>> inputInputinfo = MetadataUtils.getFieldSetPanelAp(formmeta, "fs_inputinfos");
            List<FieldProp> inputFieldProps = MetadataUtils.getProItemMap(inputInputinfo);
            this.getPageCache().put(inputFieldCacheKey, JSON.toJSONString(inputFieldProps));
        } else {
            this.getPageCache().put(inputFieldCacheKey, JSON.toJSONString(allFieldProps));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        IDataModel model = this.getModel();
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "deleteentryinputs": 
            case "deleteentryoutputs": {
                this.setCollapse();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        String fieldKey = ctlSource.getKey();
        IDataModel model = this.getModel();
        String type = this.getModel().getDataEntity().getString(TYPE);
        if (StringUtils.isBlank((String)type) || "2".equals(type)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7c7b\u578b\u4e3a\u201c\u5b9e\u4f53\u201d\u540e\u518d\u70b9\u51fb\uff0c\u7c7b\u578b\u4e3a\u201c\u7ed3\u6784\u201d\u8bf7\u4f7f\u7528\u5bfc\u5165\u7ed3\u6784\u529f\u80fd\u3002", (String)"PbdStructEditPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (fieldKey) {
            case "inputsfieldid": {
                int inputsrow = model.getEntryCurrentRowIndex("inputsentity");
                this.showSelectFieldForm(model, INPUTSFIELDID_CALLBACK, inputsrow, "inputsentity", "inputsfieldid");
                break;
            }
            case "outputsfieldid": {
                int outputsrow = model.getEntryCurrentRowIndex("outputsentity");
                this.showSelectFieldForm(model, OUTPUTSFIELDID_CALLBACK, outputsrow, "outputsentity", "outputsfieldid");
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        super.itemClick(evt);
        switch (operationKey = evt.getOperationKey()) {
            case "inputsimportstruts": 
            case "outputsimportstruts": {
                this.showImportStructForm(this.getModel(), operationKey);
                break;
            }
        }
    }

    public static Map<Object, Integer> getPkIds(IDataModel model, List<FieldProp> fieldProps, String entityKey, String key) {
        HashMap<Object, Integer> pkids = new HashMap<Object, Integer>(8);
        DynamicObjectCollection entryEntity2 = model.getEntryEntity(entityKey);
        int startRowIndex = entryEntity2.getStartRowIndex();
        if (!CollectionUtils.isEmpty((Collection)entryEntity2)) {
            for (DynamicObject dy : entryEntity2) {
                String fieldKey = dy.getString(key);
                FieldProp fieldProp = FieldPropUtils.findCheckedField(null, (Object)fieldKey, fieldProps);
                if (fieldProp != null) {
                    pkids.put(fieldProp.getKey(), startRowIndex);
                }
                ++startRowIndex;
            }
        }
        return pkids;
    }

    private void setStructData(IDataModel model, String entryentity, List<FieldProp> fieldProps, Map<Object, Integer> pkIds, FieldProp prop) {
        String id = prop.getKey();
        String pid = prop.getParentKey();
        if (pid != null && !pid.equals("") && !pid.equals(BILL)) {
            Optional<FieldProp> findAny = fieldProps.stream().filter(f -> f.getId().equals(prop.getParentId())).findAny();
            if (findAny.isPresent()) {
                int rowIndex;
                FieldProp parent = findAny.get();
                if (pkIds.containsKey(pid)) {
                    rowIndex = pkIds.get(pid);
                } else {
                    rowIndex = model.createNewEntryRow(entryentity);
                    this.setStructData(model, entryentity, rowIndex, parent, pkIds);
                }
                rowIndex = model.insertEntryRow(entryentity, rowIndex);
                this.setStructData(model, entryentity, rowIndex, prop, pkIds);
            }
        } else {
            if (pkIds.containsKey(id)) {
                return;
            }
            int rowIndex = model.createNewEntryRow(entryentity);
            this.setStructData(model, entryentity, rowIndex, prop, pkIds);
        }
    }

    private void setStructData(IDataModel model, String entryentity, int rowIndex, FieldProp prop, Map<Object, Integer> pkIds) {
        if (prop == null) {
            return;
        }
        String id = prop.getId();
        pkIds.put(id, rowIndex);
        String key = prop.getKey();
        String name = prop.getName();
        String dataType = prop.getDataType();
        String isvCacheKey = String.format(struct_data, "isv", this.getView().getPageId());
        String isv = this.getPageCache().get(isvCacheKey);
        if (entryentity.equals("inputsentity")) {
            model.setValue("inputsfieldid", (Object)key, rowIndex);
            model.setValue("inputsfieldname", (Object)name, rowIndex);
            model.setValue("inputsfieldtype", (Object)dataType, rowIndex);
            model.setValue("inputskeyisv", (Object)isv, rowIndex);
            this.setIsArray(model, "inputsisarray", dataType, rowIndex);
            if ("kingdee".equals(isv)) {
                model.setValue("inputskeystatus", (Object)"PU", rowIndex);
            } else {
                model.setValue("inputskeystatus", (Object)"NEW", rowIndex);
            }
        } else if (entryentity.equals("outputsentity")) {
            model.setValue("outputsfieldid", (Object)key, rowIndex);
            model.setValue("outputsfieldname", (Object)name, rowIndex);
            model.setValue("outputsfieldtype", (Object)dataType, rowIndex);
            model.setValue("outputskeyisv", (Object)isv, rowIndex);
            this.setIsArray(model, "outputsisarray", dataType, rowIndex);
            if ("kingdee".equals(isv)) {
                model.setValue("outputskeystatus", (Object)"PU");
            } else {
                model.setValue("outputskeystatus", (Object)"NEW");
            }
        }
    }

    private void setIsArray(IDataModel model, String fieldId, String dataType, int rowIndex) {
        if ("STRUCT".equals(dataType)) {
            model.setValue(fieldId, (Object)true, rowIndex);
        } else {
            model.setValue(fieldId, (Object)false, rowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        Object returnData = e.getReturnData();
        if (returnData != null) {
            String actionId;
            String returnDataStr = returnData.toString();
            switch (actionId = e.getActionId()) {
                case "INPUTSFIELDID_CALLBACK": 
                case "OUTPUTSFIELDID_CALLBACK": {
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    Map data = (Map)returnData;
                    Integer row0 = Optional.ofNullable(data.get("$row")).orElse(0);
                    Object key = data.get("key");
                    String isvCacheKey = String.format(struct_data, "isv", this.getView().getPageId());
                    String isv = this.getPageCache().get(isvCacheKey);
                    if (INPUTSFIELDID_CALLBACK.equals(actionId)) {
                        String fieldCacheKey = String.format(struct_data, "allinputfield", this.getView().getPageId());
                        String fieldCache = this.getPageCache().get(fieldCacheKey);
                        List fieldProps = JSONArray.parseArray((String)fieldCache, FieldProp.class);
                        Optional<FieldProp> fieldPropOptional = fieldProps.stream().filter(f -> key.equals(f.getKey())).findFirst();
                        if (!fieldPropOptional.isPresent()) break;
                        FieldProp fieldProp = fieldPropOptional.get();
                        List<String> curFieldIds = PbdCreditPluginUtils.getCurFieldIds(this.getModel(), "inputsentity", "inputsfieldid");
                        if (curFieldIds.contains(key)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PbdStructEditPlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                            break;
                        }
                        Map<Object, Integer> pkIds = PbdStructEditPlugin.getPkIds(model, fieldProps, "inputsentity", "inputsfieldid");
                        model.beginInit();
                        model.deleteEntryRow("inputsentity", row0.intValue());
                        this.setStructData(model, "inputsentity", fieldProps, pkIds, fieldProp);
                        this.setCollapse();
                        model.endInit();
                        this.getView().updateView("inputsentity");
                        break;
                    }
                    String fieldCacheKey = String.format(struct_data, "allfield", this.getView().getPageId());
                    String fieldCache = this.getPageCache().get(fieldCacheKey);
                    List fieldProps = JSONArray.parseArray((String)fieldCache, FieldProp.class);
                    Optional<FieldProp> fieldPropOptional = fieldProps.stream().filter(f -> key.equals(f.getKey())).findFirst();
                    if (!fieldPropOptional.isPresent()) break;
                    FieldProp fieldProp = fieldPropOptional.get();
                    List<String> curFieldIds = PbdCreditPluginUtils.getCurFieldIds(this.getModel(), "outputsentity", "outputsfieldid");
                    if (curFieldIds.contains(key)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5b57\u6bb5\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PbdStructEditPlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    Map<Object, Integer> pkIds = PbdStructEditPlugin.getPkIds(model, fieldProps, "outputsentity", "outputsfieldid");
                    model.beginInit();
                    model.deleteEntryRow("outputsentity", row0.intValue());
                    this.setStructData(model, "outputsentity", fieldProps, pkIds, fieldProp);
                    this.setCollapse();
                    model.endInit();
                    this.getView().updateView("outputsentity");
                    break;
                }
                case "inputsimportstruts": 
                case "outputsimportstruts": {
                    if (!StringUtils.isNotEmpty((String)returnDataStr)) break;
                    Object res = null;
                    res = (returnDataStr = returnDataStr.trim()).startsWith("[") && returnDataStr.endsWith("]") ? PbdStructEditPlugin.parseJson2List(returnDataStr) : PbdStructEditPlugin.parseJson2Map(returnDataStr);
                    this.getModel().beginInit();
                    if ("inputsimportstruts".equals(actionId)) {
                        this.getModel().deleteEntryData("inputsentity");
                        this.autoCreateEntry(this.getModel(), res, 0, "inputsentity", false);
                    } else {
                        this.getModel().deleteEntryData("outputsentity");
                        this.autoCreateEntry(this.getModel(), res, 0, "outputsentity", false);
                    }
                    this.getModel().endInit();
                    TreeEntryGrid inputsentityGrid = (TreeEntryGrid)this.getControl("inputsentity");
                    inputsentityGrid.setCollapse(false);
                    TreeEntryGrid outputsentityGrid = (TreeEntryGrid)this.getControl("outputsentity");
                    outputsentityGrid.setCollapse(false);
                    this.getView().updateView();
                    break;
                }
            }
        }
    }

    private void autoCreateEntry(IDataModel model, Object res, int rowIndex, String entryentity, boolean isInsert) {
        if (Objects.isNull(res)) {
            return;
        }
        if (res instanceof Map) {
            Map map = (Map)res;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                int index = 0;
                index = isInsert ? this.getModel().insertEntryRow(entryentity, rowIndex) : this.getModel().createNewEntryRow(entryentity);
                if ("inputsentity".equals(entryentity)) {
                    model.setValue("inputsfieldid", (Object)key, index);
                    model.setValue("inputskeystatus", (Object)"PU", index);
                    this.setDataType(model, entryentity, value, index, "inputsfieldtype", "inputsisarray");
                    continue;
                }
                if (!"outputsentity".equals(entryentity)) continue;
                model.setValue("outputsfieldid", (Object)key, index);
                model.setValue("outputskeystatus", (Object)"PU", index);
                this.setDataType(model, entryentity, value, index, "outputsfieldtype", "outputsisarray");
            }
        } else {
            Object object;
            List list = (List)res;
            if (!CollectionUtils.isEmpty((Collection)list) && (object = list.toArray()[0]) instanceof Map) {
                this.autoCreateEntry(model, list.toArray()[0], rowIndex, entryentity, Boolean.TRUE);
            }
        }
    }

    private void setDataType(IDataModel model, String entryentity, Object value, int index, String fieldtypeKey, String isarray) {
        if (value instanceof List) {
            model.setValue(isarray, (Object)true, index);
            model.setValue(fieldtypeKey, (Object)"STRUCT", index);
            this.autoCreateEntry(model, value, index, entryentity, Boolean.FALSE);
        } else if (value instanceof Map) {
            model.setValue(fieldtypeKey, (Object)"STRUCT", index);
            this.autoCreateEntry(model, value, index, entryentity, Boolean.FALSE);
        } else if (value instanceof Boolean) {
            model.setValue(fieldtypeKey, (Object)"boolean", index);
        } else if (value instanceof Double) {
            model.setValue(fieldtypeKey, (Object)"decimal", index);
        } else {
            model.setValue(fieldtypeKey, (Object)"string", index);
        }
    }

    public static List<Map<String, Object>> parseJson2List(String result) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        if (result.startsWith("[") && result.endsWith("]")) {
            JSONArray json = JSONArray.parseArray((String)result);
            for (JSONObject json2 : json) {
                list.add(PbdStructEditPlugin.parseJson2Map(json2.toString()));
            }
        }
        return list;
    }

    public static Map<String, Object> parseJson2Map(String result) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (result.startsWith("{") && result.endsWith("}")) {
            JSONObject json = JSONObject.parseObject((String)result, (Feature[])new Feature[]{Feature.OrderedField});
            for (Object key : json.keySet()) {
                Object value = json.get(key);
                if (value instanceof JSONArray) {
                    ArrayList list = new ArrayList();
                    for (Object json2 : (JSONArray)value) {
                        if (json2 instanceof String) {
                            list.add(json2);
                            continue;
                        }
                        list.add(PbdStructEditPlugin.parseJson2Map(json2.toString()));
                    }
                    map.put(key.toString(), list);
                    continue;
                }
                if (value instanceof JSONObject) {
                    map.put(key.toString(), PbdStructEditPlugin.parseJson2Map(value.toString()));
                    continue;
                }
                map.put(key.toString(), value);
            }
        }
        return map;
    }

    private void showImportStructForm(IDataModel model, String callback) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_import_struct");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callback));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showSelectFieldForm(IDataModel model, String callback, Integer row, String entityKey, String entityFieldId) {
        String fieldCache;
        String fieldCacheKey;
        DynamicObject entryentity = model.getDataEntity();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_select_prop");
        DynamicObject entity = entryentity.getDynamicObject(SOURCE);
        if (entity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5143\u6570\u636e\u3002", (String)"PbdStructEditPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
        ArrayList<FieldProp> fieldProps = new ArrayList<FieldProp>(8);
        if ("inputsentity".equals(entityKey)) {
            fieldCacheKey = String.format(struct_data, "allinputfield", this.getView().getPageId());
            fieldCache = this.getPageCache().get(fieldCacheKey);
            fieldProps.addAll(JSONArray.parseArray((String)fieldCache, FieldProp.class));
        } else if ("outputsentity".equals(entityKey)) {
            fieldCacheKey = String.format(struct_data, "allfield", this.getView().getPageId());
            fieldCache = this.getPageCache().get(fieldCacheKey);
            fieldProps.addAll(JSONArray.parseArray((String)fieldCache, FieldProp.class));
        }
        List<String> excludeKeys = PbdCreditPluginUtils.getCurFieldIds(this.getModel(), entityKey, entityFieldId);
        String loadResFormat = ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5355\u636e", (String)"PbdStructEditPlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdStructEditPlugin_7", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
        String nodesJson = PbdCreditPluginUtils.bulidNodesJson(fieldProps, loadResFormat, excludeKeys, "key");
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("$row", row);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callback));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public static MainEntityType getMainEntityType(DynamicObject dy, String billEntity) {
        DynamicObject entity = dy.getDynamicObject(billEntity);
        if (entity == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u5143\u6570\u636e\u3002", (String)"PbdStructEditPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
        String number = entity.getString("id");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)number);
        if (type == null) {
            throw new KDBizException(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u5143\u6570\u636e%1\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"PbdStructEditPlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdStructEditPlugin_4", (String)"scm-pbd-formplugin", (Object[])new Object[]{billEntity}));
        }
        return type;
    }
}

