/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.billrelation;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.scm.common.helper.businesstracking.domain.BillLinkRelationParam;

public final class PbdBillRelationModeParamPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        Object linkConfigString;
        Object targetentity;
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object sourceentity = customParams.get("sourceentity");
        if (sourceentity != null) {
            this.getModel().setValue("sourceentity", sourceentity);
        }
        if ((targetentity = customParams.get("targetentity")) != null) {
            this.getModel().setValue("targetentity", targetentity);
        }
        if ((linkConfigString = customParams.get("linkconfigstring")) != null) {
            BillLinkRelationParam billRelationParam = (BillLinkRelationParam)SerializationUtils.fromJsonString((String)linkConfigString.toString(), BillLinkRelationParam.class);
            this.getModel().setValue("targetentity", (Object)billRelationParam.getTargetEntity());
            this.getModel().setValue("sourceentity", (Object)billRelationParam.getSourceEntity());
            this.getModel().setValue("originlinkfiledkey", (Object)billRelationParam.getOriginLinkFiledKey());
            this.getModel().setValue("targetlinkfiledkey", (Object)billRelationParam.getTargetLinkFiledKey());
            this.getModel().setValue("sourceentry", (Object)billRelationParam.getSourceEntry());
            this.getModel().setValue("targetentry", (Object)billRelationParam.getTargetEntry());
        }
        this.initEntryEntityValue(this.getModel().getDataEntity().getString("sourceentity.id"), "sourceentry");
        this.initEntryEntityValue(this.getModel().getDataEntity().getString("targetentity.id"), "targetentry");
        this.initOriginLinkFiledKey();
        this.initTargetLinkFiledKey();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        if ("sourceentity".equals(proName)) {
            this.initOriginLinkFiledKey();
        }
        if ("targetentity".equals(proName)) {
            this.initTargetLinkFiledKey();
        }
        if ("definelink".equals(proName)) {
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex("targetentryentity");
            this.getModel().setValue("executelinkconfig", null, currentRowIndex);
        }
    }

    private void initEntryEntityValue(String entityNumber, String entryFiledKey) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(entryFiledKey);
        if (comboEdit != null) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(1024);
            MainEntityType targetEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Map entityTypeAllEntities = targetEntityType.getAllEntities();
            ComboItem property = null;
            for (Map.Entry entry : entityTypeAllEntities.entrySet()) {
                EntityType entityType = (EntityType)entry.getValue();
                String entryKey = (String)entry.getKey();
                Class<?> entityClass = entityType.getClass();
                if (!entityClass.equals(BillEntityType.class) && !entityClass.equals(BasedataEntityType.class) && !entityClass.equals(EntryType.class)) continue;
                String name = entityType.getDisplayName().getLocaleValue();
                property = new ComboItem(new LocaleString(name + "(" + entryKey + ")"), entryKey);
                comboItems.add(property);
            }
            comboEdit.setComboItems(comboItems);
        }
    }

    private void initOriginLinkFiledKey() {
        ComboEdit originlinkfiledkey = (ComboEdit)this.getView().getControl("originlinkfiledkey");
        if (originlinkfiledkey != null) {
            String entityNumber = this.getModel().getDataEntity().getString("sourceentity.number");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(1024);
            List pkList = mainEntityType.getPkList();
            comboItems.addAll(this.assemblePkProperty(pkList));
            comboItems.addAll(this.assembleProperty(mainEntityType.getAllFields(), ""));
            originlinkfiledkey.setComboItems(comboItems);
        }
    }

    private void initTargetLinkFiledKey() {
        ComboEdit targetlinkfiledkey = (ComboEdit)this.getView().getControl("targetlinkfiledkey");
        if (targetlinkfiledkey != null) {
            String entityNumber = this.getModel().getDataEntity().getString("targetentity.number");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            List pkList = mainEntityType.getPkList();
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(1024);
            comboItems.addAll(this.assemblePkProperty(pkList));
            comboItems.addAll(this.assembleProperty(mainEntityType.getAllFields(), ""));
            targetlinkfiledkey.setComboItems(comboItems);
        }
    }

    private List<ComboItem> assemblePkProperty(List<ISimpleProperty> pkList) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(1024);
        ComboItem property = null;
        for (ISimpleProperty simpleProperty : pkList) {
            String name = "";
            String filedkey = "";
            Class<?> entityClass = simpleProperty.getParent().getClass();
            if (!entityClass.equals(BillEntityType.class) && !entityClass.equals(BasedataEntityType.class)) continue;
            name = simpleProperty.getParent().getDisplayName().getLocaleValue();
            filedkey = simpleProperty.getName();
            property = new ComboItem(new LocaleString(name + "(" + filedkey + ")"), filedkey);
            comboItems.add(property);
        }
        return comboItems;
    }

    private List<ComboItem> assembleProperty(Map<String, IDataEntityProperty> typeAllFields, String suffix) {
        ComboItem property = null;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(typeAllFields.size());
        for (Map.Entry<String, IDataEntityProperty> entry : typeAllFields.entrySet()) {
            boolean ignoreType;
            String key = entry.getKey();
            IDataEntityProperty value = entry.getValue();
            Class<?> valueClass = value.getClass();
            boolean bl = ignoreType = valueClass.equals(TextProp.class) || valueClass.equals(BasedataProp.class) || valueClass.equals(MainOrgProp.class);
            if (!key.endsWith(suffix) || !ignoreType) continue;
            String name = "";
            name = value.getParent().getClass().equals(EntryType.class) ? value.getParent().getDisplayName().getLocaleValue() + ':' + value.getDisplayName().getLocaleValue() : value.getDisplayName().getLocaleValue();
            property = new ComboItem(new LocaleString(name + "(" + key + ")"), key);
            comboItems.add(property);
        }
        return comboItems;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void click(EventObject evt) {
        Button button;
        String buttonKey;
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Button && "btnok".equals(buttonKey = (button = (Button)source).getKey())) {
            String targetEntry;
            String sourceEntry;
            String targetlinkfiledkey;
            String originlinkfiledkey;
            String sourceNumber;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            BillLinkRelationParam billRelationParam = new BillLinkRelationParam();
            String targetNumber = dataEntity.getString("targetentity.number");
            if (targetNumber != null) {
                billRelationParam.setTargetEntity(targetNumber);
            }
            if ((sourceNumber = dataEntity.getString("sourceentity.number")) != null) {
                billRelationParam.setSourceEntity(sourceNumber);
            }
            if ((originlinkfiledkey = dataEntity.getString("originlinkfiledkey")) != null) {
                billRelationParam.setOriginLinkFiledKey(originlinkfiledkey);
            }
            if ((targetlinkfiledkey = dataEntity.getString("targetlinkfiledkey")) != null) {
                billRelationParam.setTargetLinkFiledKey(targetlinkfiledkey);
            }
            if ((sourceEntry = dataEntity.getString("sourceentry")) != null) {
                billRelationParam.setSourceEntry(sourceEntry);
            }
            if ((targetEntry = dataEntity.getString("targetentry")) != null) {
                billRelationParam.setTargetEntry(targetEntry);
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)billRelationParam));
            this.getView().close();
        }
    }
}

