/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.billrelation;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;
import kd.scm.pbd.business.PbdBusinessTrackerExecuteHelper;

public final class PbdBusinessTrackerPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String Key_TabBills = "tabbills";
    private final Map<String, String> childPageIds = new HashMap<String, String>(32);
    private static final String CacheKey_PageIds = "pageids";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"barshiftgraph", "barshiftlist", "toolbarap"});
        Tab tab = (Tab)this.getView().getControl(Key_TabBills);
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"barshiftgraph", "barshiftlist", "fp_tracklist", "fp_trackgraph"});
        Object defaultShowTab = this.getView().getFormShowParameter().getCustomParam("defaultshowtab");
        if (defaultShowTab == null) {
            defaultShowTab = "tracklist";
        }
        this.getView().addClientCallBack(String.valueOf(defaultShowTab));
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("barshiftlist".equals(itemKey)) {
            this.shiftListTab();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String name = e.getName();
        if ("tracklist".equals(name)) {
            this.shiftListTab();
        }
    }

    private void shiftListTab() {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u52a0\u8f7d\u4e1a\u52a1\u8ffd\u8e2a\u7ed3\u679c\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"PbdBusinessTrackerPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0])));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"barshiftgraph", "barshiftlist", "fp_tracklist", "fp_trackgraph"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"barshiftgraph", "fp_tracklist"});
        Object executebillrelationid = this.getView().getFormShowParameter().getCustomParam("executetrackingid");
        Object executebillid = this.getView().getFormShowParameter().getCustomParam("executebillid");
        Object entityNumber = this.getView().getFormShowParameter().getCustomParam("entitynumber");
        if (entityNumber != null && executebillrelationid != null && executebillid != null) {
            try {
                LinkedHashMap trackerList = PbdBusinessTrackerExecuteHelper.assembleTrackerList((String)String.valueOf(executebillrelationid), (String)String.valueOf(entityNumber), (Long)Long.parseLong(String.valueOf(executebillid)));
                boolean atLastAvailable = trackerList.values().stream().anyMatch(row -> !row.isEmpty());
                if (!trackerList.isEmpty() && atLastAvailable) {
                    this.showAllList(String.valueOf(entityNumber), trackerList);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6709\u6548\u5173\u8054\u6570\u636e\uff0c\u65e0\u6cd5\u5c55\u793a\u4e1a\u52a1\u8ffd\u8e2a\u5217\u8868\u3002", (String)"PbdBusinessTrackerPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]), Integer.valueOf(Integer.parseInt("12000")));
                }
            }
            catch (RuntimeException runtimeException) {
                SRMStoreExceptionTraceHelper.saveWarnData((RuntimeException)runtimeException);
                String errorMessage = ResManager.loadKDString((String)"\u5c55\u793a\u4e1a\u52a1\u8ffd\u8e2a\u5217\u8868\u9047\u5230\u4e86\u4e00\u4e9b\u610f\u6599\u4e4b\u5916\u7684\u60c5\u51b5\uff0c\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a{0}", (String)"PbdBusinessTrackerPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[]{String.valueOf(runtimeException.getMessage())});
                this.getView().showTipNotification(errorMessage, Integer.valueOf(Integer.parseInt("12000")));
            }
        }
        this.getView().hideLoading();
    }

    private void showAllList(String executeEntity, LinkedHashMap<String, Collection<Long>> trackerList) {
        this.childPageIds.clear();
        Tab tab = (Tab)this.getView().getControl(Key_TabBills);
        for (Map.Entry<String, Collection<Long>> entry : trackerList.entrySet()) {
            String entityNumber = entry.getKey();
            Collection<Long> trackBillIds = entry.getValue();
            if (trackBillIds == null || trackBillIds.isEmpty()) continue;
            ListShowParameter formShowParameter = this.createShowParameter(entityNumber, trackBillIds);
            this.getView().showForm((FormShowParameter)formShowParameter);
            this.childPageIds.put(entityNumber, formShowParameter.getPageId());
            this.putPageIds(this.childPageIds);
        }
        if (tab != null) {
            tab.activeTab(executeEntity);
        }
    }

    private ListShowParameter createShowParameter(String entityNumber, Collection<Long> billIds) {
        QFilter qFilter = new QFilter("id", "in", billIds);
        ListShowParameter showParameter = new ListShowParameter();
        PbdBusinessTrackerPlugin.setAppIdWhereExistSpecialLicense(entityNumber, showParameter);
        showParameter.setBillFormId(entityNumber);
        showParameter.setIsolationOrg(false);
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey(Key_TabBills);
        showParameter.setShowTitle(false);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        for (Long row : billIds) {
            showParameter.addLinkQueryPkId((Object)row);
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        showParameter.setCaption(mainType.getDisplayName().toString());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityNumber);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.getListFilterParameter().setFilter(qFilter);
        showParameter.setHasRight(true);
        return showParameter;
    }

    private static void setAppIdWhereExistSpecialLicense(String entityNumber, ListShowParameter showParameter) {
        DynamicObject appIdObject = QueryServiceHelper.queryOne((String)"pbd_trackerlicens", (String)"bizappid.number", (QFilter[])new QFilter[]{new QFilter("targetbill", "=", (Object)entityNumber)});
        if (appIdObject == null) {
            return;
        }
        String appid = appIdObject.getString("bizappid.number");
        if (StringUtils.isBlank((CharSequence)appid)) {
            return;
        }
        showParameter.setAppId(appid);
    }

    private void putPageIds(Map<String, String> childPageIds) {
        this.getPageCache().put(CacheKey_PageIds, SerializationUtils.toJsonString(childPageIds));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String entityNumber = closedCallBackEvent.getActionId();
        String pageId = this.getPageId(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)pageId)) {
            this.closePage(entityNumber);
        }
    }

    private String getPageId(String entityNumber) {
        Map<String, String> pageIds = this.getPageIds();
        return pageIds.get(entityNumber);
    }

    private Map<String, String> getPageIds() {
        String cacheValue = this.getPageCache().get(CacheKey_PageIds);
        return StringUtils.isBlank((CharSequence)cacheValue) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
    }

    private void closePage(String entityNumber) {
        Map<String, String> pageIds = this.getPageIds();
        pageIds.remove(entityNumber);
        if (pageIds.isEmpty()) {
            this.getView().close();
        } else {
            this.putPageIds(pageIds);
        }
    }
}

