/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.digitalcredit;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.util.BillFormUtil;

public class PbdSupplierMonitorListPlugin
extends AbstractListPlugin {
    private static final String BD_SUPPLIER = "bd_supplier";
    private static List<String> OPKEYS = Arrays.asList("submit", "unsubmit", "audit", "changemonitor", "exportlistbyselectfields");

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            String fieldName = commonFilterColumn.getFieldName();
            if (!"org.name".equals(fieldName) && !"org.number".equals(fieldName) && !"org.id".equals(fieldName)) continue;
            commonFilterColumn.setDefaultValue("");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        String operatename = operate.getOperateName().getLocaleValue();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        Long orgId = RequestContext.get().getOrgId();
        if (OPKEYS.contains(key)) {
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            QFilter qf = new QFilter("id", "in", (Object)primaryKeyValues);
            qf.and("org", "<>", (Object)orgId);
            boolean exists = QueryServiceHelper.exists((String)"pbd_supplier_monitor", (QFilter[])new QFilter[]{qf});
            if (exists) {
                args.setCancel(true);
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u975e\u5ba1\u6279\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u6267\u884c{0}\u64cd\u4f5c\u3002", (String)"PbdSupplierMonitorListPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]), operatename));
                return;
            }
        }
        switch (key) {
            case "querymonitordetail": {
                if (listSelectedData.isEmpty()) {
                    args.setCancel(true);
                    break;
                }
                if (listSelectedData.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u4e00\u6761\u6570\u636e\u67e5\u770b\u98ce\u9669\u8be6\u60c5\u3002", (String)"PbdSupplierMonitorListPlugin_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                ListSelectedRow listSelectedRow = listSelectedData.get(0);
                Object entryPrimaryKeyValue = listSelectedRow.getEntryPrimaryKeyValue();
                Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
                QFilter qf = new QFilter("id", "=", primaryKeyValue);
                qf.and("entryentity.id", "=", entryPrimaryKeyValue);
                DynamicObject load = QueryServiceHelper.queryOne((String)"pbd_supplier_monitor", (String)"id,entryentity.id,entryentity.supplier,entryentity.suppliername", (QFilter[])new QFilter[]{qf});
                if (load == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u4f9b\u5e94\u5546\u67e5\u8be2\u6743\u9650\u3002", (String)"PbdSupplierMonitorListPlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                String suppliername = load.getString("entryentity.suppliername");
                Long supplierId = load.getLong("entryentity.supplier");
                QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)BD_SUPPLIER, (Long)orgId);
                qFilter.and("id", "=", (Object)supplierId);
                DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((String)BD_SUPPLIER, (QFilter[])new QFilter[]{qFilter});
                if (loadSingle == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u4f9b\u5e94\u5546\u67e5\u8be2\u6743\u9650\u3002", (String)"PbdSupplierMonitorListPlugin_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                this.showBillForm("pbd_supplier_data", suppliername);
                break;
            }
            case "changemonitor": {
                Object[] entryPrimaryKeyValues = listSelectedData.getEntryPrimaryKeyValues();
                Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
                if (primaryKeyValues == null || primaryKeyValues.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u540c\u4e00\u6279\u6b21\u52a0\u5165\u76d1\u63a7\u6c60\u7684\u4f9b\u5e94\u5546\u8fdb\u884c\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"PbdSupplierMonitorListPlugin_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    break;
                }
                Object primaryKeyValue1 = primaryKeyValues[0];
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("entryPrimaryKeyValues", entryPrimaryKeyValues);
                map.put("changemonitor", true);
                this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"pbd_supplier_monitor", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)((Long)primaryKeyValue1), map, null));
                break;
            }
        }
    }

    public void showBillForm(String entityKey, String suppliername) {
        if (suppliername == null || entityKey == null || entityKey.isEmpty()) {
            return;
        }
        QFilter qf = new QFilter("suppliername", "=", (Object)suppliername);
        DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"pbd_supplier_data", (String)"org,suppliername,monitorstatus,suppliermonitorid,monitorbeforetime,monitoraftertime", (QFilter[])new QFilter[]{qf});
        if (load != null) {
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)entityKey, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)((Long)load.getPkValue()), new HashMap(8), null));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u98ce\u9669\u8be6\u60c5\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PbdSupplierMonitorListPlugin_4", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Long orgId = RequestContext.get().getOrgId();
        Object pkVal = list.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        QFilter qf = new QFilter("id", "in", (Object)new Object[]{pkVal});
        qf.and("org", "<>", (Object)orgId);
        boolean exists = QueryServiceHelper.exists((String)"pbd_supplier_monitor", (QFilter[])new QFilter[]{qf});
        if (exists) {
            args.setCancel(true);
            String loadKDString = ResManager.loadKDString((String)"\u67e5\u770b\u5355\u636e\u8be6\u60c5", (String)"PbdSupplierMonitorListPlugin_5", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u975e\u5ba1\u6279\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u6267\u884c{0}\u64cd\u4f5c\u3002", (String)"PbdSupplierMonitorListPlugin_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]), loadKDString));
            return;
        }
    }
}

