/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pbd.formplugin.util.PbdMalUtil;
import kd.scm.pbd.service.address.AbstractAddressMatcher;

public class PbdAddressEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String EMAL_TYPE = "emaltype";
    private static final String MALADDRESSREL = "pbd_maladdressrel";

    public void afterCreateNewData(EventObject e) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("emaladdress");
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener(this::beforeF7Select);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterBindData(e);
        ComboEdit comboEdit = (ComboEdit)this.getControl(EMAL_TYPE);
        List<ComboItem> data = PbdMalUtil.getComboItemList();
        comboEdit.setComboItems(data);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name;
        switch (name = beforeF7SelectEvent.getProperty().getName()) {
            case "emaladdress": {
                Object emalType = this.getModel().getValue(EMAL_TYPE);
                DynamicObject address = (DynamicObject)this.getModel().getValue("addressid");
                if (emalType != null && !emalType.toString().isEmpty()) {
                    int level = Integer.parseInt(address.getString("level"));
                    QFilter levelFilter = AbstractAddressMatcher.DIRECT_PROVINCE_NUM_LIST.contains(address.getString("longnumber").split("\\.")[0]) ? new QFilter("level", "in", (Object)Stream.of(level, level + 1).toArray()) : new QFilter("level", "=", (Object)Integer.parseInt(address.getString("level")));
                    ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(levelFilter.and(new QFilter(EMAL_TYPE, "=", emalType)));
                    beforeF7SelectEvent.getFormShowParameter().setCustomParam(EMAL_TYPE, emalType);
                    break;
                }
                beforeF7SelectEvent.setCancel(true);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject dyo;
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        DynamicObject emaladdress = (DynamicObject)this.getModel().getValue("emaladdress");
        DynamicObject address = (DynamicObject)this.getModel().getValue("addressid");
        String emalType = (String)this.getModel().getValue(EMAL_TYPE);
        if (key.equals("save") && emaladdress != null && (dyo = QueryServiceHelper.queryOne((String)MALADDRESSREL, (String)"id", (QFilter[])new QFilter[]{new QFilter("emaladdress", "=", (Object)Long.parseLong(emaladdress.getString("id"))), new QFilter("addressid", "!=", (Object)Long.parseLong(address.getString("id"))), new QFilter("emalType", "=", (Object)emalType)})) != null) {
            this.getView().showConfirm(ResManager.loadKDString((String)ResManager.loadKDString((String)"\u5f53\u524d\u5730\u5740\u5df2\u5b58\u5728\u5339\u914d\u5173\u7cfb\uff0c\u662f\u5426\u66f4\u65b0\uff1f", (String)"PbdAddressEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdAddressEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirm"));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.equals("save")) {
            this.getModel().setValue("modifier", (Object)RequestContext.get().getUserId());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newVal;
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        if (StringUtils.equals((CharSequence)"emaladdress", (CharSequence)fieldKey) && null != (newVal = (DynamicObject)changedData[0].getNewValue())) {
            this.getModel().setValue("longnumber", (Object)newVal.getString("longnumber"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        DynamicObject emaladdress = (DynamicObject)this.getModel().getValue("emaladdress");
        DynamicObject address = (DynamicObject)this.getModel().getValue("addressid");
        String emalType = (String)this.getModel().getValue(EMAL_TYPE);
        DynamicObject dyo = BusinessDataServiceHelper.loadSingle((String)MALADDRESSREL, (String)"modifier, emaladdress, addressid, longnumber, matchstatus", (QFilter[])new QFilter[]{new QFilter("addressid", "=", (Object)Long.parseLong(address.getString("masterid"))), new QFilter("emalType", "=", (Object)emalType)});
        String newNumber = (String)emaladdress.get("number");
        String oldNumber = dyo.getString("emaladdress.number");
        Integer level = address.getInt("level");
        if (oldNumber == null) {
            oldNumber = "";
        }
        String oldLongNumber = dyo.getString("longnumber");
        DynamicObject[] childrenDyos = new DynamicObject[]{};
        dyo.set("longnumber", (Object)((String)emaladdress.get("longnumber")));
        if (level < 4) {
            childrenDyos = BusinessDataServiceHelper.load((String)MALADDRESSREL, (String)"emaladdress, addressid, longnumber", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(oldLongNumber + ".%")), new QFilter("emalType", "=", (Object)emalType)});
        }
        for (int i = 0; i < childrenDyos.length; ++i) {
            DynamicObject item = childrenDyos[i];
            item.set("longnumber", (Object)StringUtil.replace((String)item.getString("longnumber"), (String)(oldNumber + "."), (String)(newNumber + ".")));
        }
        if (childrenDyos.length > 0) {
            SaveServiceHelper.save((DynamicObject[])childrenDyos);
        }
        dyo.set("emaladdress", emaladdress.get("masterid"));
        dyo.set("matchstatus", (Object)2);
        this.getModel().setValue("modifier", (Object)RequestContext.get().getUserId());
        dyo.set("modifier", (Object)RequestContext.get().getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyo});
        this.getView().updateView();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PbdAddressEdit_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdAddressEdit_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        this.getModel().setDataChanged(false);
    }
}

