/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class PbdApiLogSettingPlugin
extends AbstractFormPlugin {
    public static final String BTNSAVE = "btnsave";
    public static final String AUTOARCHIVEAMT = "autoarchiveamt";
    public static final String AUTOCLEARTIME = "autocleartime";

    public void beforeClick(BeforeClickEvent evt) {
        Button button;
        super.beforeClick(evt);
        Object source = evt.getSource();
        if (source instanceof Button && StringUtils.equals((CharSequence)BTNSAVE, (CharSequence)(button = (Button)source).getKey())) {
            this.deleteLogSet();
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNSAVE});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadLogSetData();
        this.getView().getModel().setDataChanged(false);
    }

    private void loadLogSetData() {
        String selectList = "autoarchiveamt,autocleartime";
        DynamicObject logSetting = BusinessDataServiceHelper.loadSingle((String)"pbd_apilogsettings", (String)selectList, (QFilter[])new QFilter[0]);
        if (logSetting != null) {
            IDataModel model = this.getModel();
            model.setValue(AUTOARCHIVEAMT, logSetting.get(AUTOARCHIVEAMT));
            model.setValue(AUTOCLEARTIME, logSetting.get(AUTOCLEARTIME));
            this.getView().updateView(AUTOARCHIVEAMT);
            this.getView().updateView(AUTOCLEARTIME);
        }
    }

    private void deleteLogSet() {
        DynamicObjectCollection dyoCol = QueryServiceHelper.query((String)"pbd_apilogsettings", (String)"id", (QFilter[])new QFilter[0]);
        if (null != dyoCol && dyoCol.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>(dyoCol.size());
            for (DynamicObject dyo : dyoCol) {
                ids.add(dyo.getLong("id"));
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            DeleteServiceHelper.delete((String)"pbd_apilogsettings", (QFilter[])new QFilter[]{qFilter});
        }
    }
}

