/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.es.storage.EsDataType;
import kd.scm.common.util.ExceptionUtil;

public class PbdEsMappingPropertyEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog((String)PbdEsMappingPropertyEdit.class.getName());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit mappingField = (TextEdit)this.getControl("mappingfield");
        mappingField.addClickListener((ClickListener)this);
        MulBasedataEdit nestsControl = (MulBasedataEdit)this.getControl("nests");
        nestsControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("mappingfield".equals(key)) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("pbd_property_select");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, this.getView().getEntityId()));
            Object indexEntityDyn = this.getModel().getValue("indexentity");
            if (indexEntityDyn != null) {
                fsp.setCustomParam("entityNumber", (Object)((DynamicObject)indexEntityDyn).getString("number"));
                this.getView().showForm(fsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (this.getView().getEntityId().equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            TreeNode node = (TreeNode)closedCallBackEvent.getReturnData();
            this.getModel().setValue("number", (Object)node.getId());
            this.getModel().setValue("name", (Object)node.getText());
            this.getModel().setValue("mappingfield", (Object)node.getId());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String subIndexEntityKey;
        IDataEntityProperty property;
        DynamicObjectType indexEntityType;
        if ("datatype".equals(e.getProperty().getName())) {
            if (EsDataType.NESTED.getVal().equals(e.getChangeSet()[0].getNewValue())) {
                indexEntityType = this.getMappingEnityType();
                if (null == indexEntityType) {
                    return;
                }
                property = this.getMappingProperty(indexEntityType, (String)this.getModel().getValue("mappingfield"));
                if (property instanceof DynamicComplexProperty) {
                    subIndexEntityKey = ((DynamicComplexProperty)property).getComplexType().getName();
                    this.insertEsMappingFieldBySubEntity(subIndexEntityKey);
                } else if (!(property instanceof EntryProp)) {
                    this.getModel().beginInit();
                    this.getModel().setValue("datatype", e.getChangeSet()[0].getOldValue());
                    this.getModel().endInit();
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6620\u5c04\u5b57\u6bb5\u4e0d\u652f\u6301\u5d4c\u5957\u7c7b\u578b\u3002", (String)"PbdEsMappingPropertyEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                this.getModel().setValue("nests", null);
            }
        }
        if ("mappingfield".equals(e.getProperty().getName()) && EsDataType.NESTED.getVal().equals(this.getModel().getValue("datatype"))) {
            indexEntityType = this.getMappingEnityType();
            if (indexEntityType == null) {
                return;
            }
            property = this.getMappingProperty(indexEntityType, (String)this.getModel().getValue("mappingfield"));
            if (property instanceof DynamicComplexProperty) {
                subIndexEntityKey = ((DynamicComplexProperty)property).getComplexType().getName();
                this.insertEsMappingFieldBySubEntity(subIndexEntityKey);
                this.getModel().setValue("nests", null);
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("datatype", (Object)EsDataType.KEYWORD.getVal());
                this.getModel().endInit();
            }
        }
    }

    private DynamicObjectType getMappingEnityType() {
        Object indexEntity = this.getModel().getValue("indexentity");
        if (indexEntity == null) {
            return null;
        }
        return BusinessDataServiceHelper.newDynamicObject((String)((DynamicObject)indexEntity).getString("number")).getDynamicObjectType();
    }

    private DynamicObjectType getMappingEnityTypeByProp(DynamicComplexProperty property) {
        return BusinessDataServiceHelper.newDynamicObject((String)property.getComplexType().getName()).getDynamicObjectType();
    }

    private String getMappingEnityName() {
        Object indexEntity = this.getModel().getValue("indexentity");
        if (indexEntity == null) {
            return "";
        }
        return ((DynamicObject)indexEntity).getString("number");
    }

    private IDataEntityProperty getMappingProperty(DynamicObjectType indexEntityType, String mappingPropName) {
        for (IDataEntityProperty iDataEntityProperty : indexEntityType.getProperties()) {
            if (iDataEntityProperty.getName().equals(mappingPropName)) {
                return iDataEntityProperty;
            }
            if (!iDataEntityProperty.getName().equals(mappingPropName.split("\\.")[0])) continue;
            if (iDataEntityProperty instanceof DynamicComplexProperty) {
                return this.getMappingProperty(this.getMappingEnityTypeByProp((DynamicComplexProperty)iDataEntityProperty), mappingPropName.split("\\.")[1]);
            }
            if (!(iDataEntityProperty instanceof EntryProp)) continue;
            return iDataEntityProperty;
        }
        throw new KDBizException(mappingPropName + " not found in " + indexEntityType.getName());
    }

    private void insertEsMappingFieldBySubEntity(String entityName) {
        TreeNode curMappingFieldNode = this.getTreeNode(this.getMappingEnityName()).getTreeNode((String)this.getModel().getValue("mappingfield"));
        DynamicObject subIndexEntityDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entityName)});
        ArrayList<DynamicObject> esMappingDyns = new ArrayList<DynamicObject>(curMappingFieldNode.getChildren().size());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"pbd_esmapping_property");
        for (TreeNode node : curMappingFieldNode.getChildren()) {
            DynamicObject esMappingDyn = ParameterUtils.createDefaultEntity((MainEntityType)entityType, (DynamicObject)((DynamicObject)entityType.createInstance()));
            esMappingDyn.set("name", (Object)node.getText());
            esMappingDyn.set("number", (Object)node.getId());
            esMappingDyn.set("indexentity", (Object)subIndexEntityDyn);
            esMappingDyn.set("mappingfield", (Object)node.getId());
            esMappingDyn.set("datatype", (Object)EsDataType.KEYWORD.getVal());
            esMappingDyns.add(esMappingDyn);
        }
        this.saveSubmitAuditEsMapping(esMappingDyns);
    }

    private void saveSubmitAuditEsMapping(List<DynamicObject> esMappingDyns) {
        OperationResult saveOperationResult = OperationServiceHelper.executeOperate((String)"save", (String)this.getView().getEntityId(), (DynamicObject[])esMappingDyns.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!saveOperationResult.getSuccessPkIds().isEmpty()) {
            OperationResult submitOperationResult = OperationServiceHelper.executeOperate((String)"submit", (String)this.getView().getEntityId(), (DynamicObject[])esMappingDyns.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!submitOperationResult.getSuccessPkIds().isEmpty()) {
                OperationResult auditOperationResult = OperationServiceHelper.executeOperate((String)"audit", (String)this.getView().getEntityId(), (DynamicObject[])esMappingDyns.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (auditOperationResult.getSuccessPkIds().isEmpty()) {
                    log.info("\u540e\u53f0\u5d4c\u5957\u751f\u6210\u5168\u6587\u68c0\u7d22\u6620\u5c04\u5ba1\u6838\u5c5e\u6027\u5931\u8d25:" + ExceptionUtil.getErrorInfoDetails((List)auditOperationResult.getAllErrorOrValidateInfo()));
                }
            } else {
                log.info("\u540e\u53f0\u5d4c\u5957\u751f\u6210\u5168\u6587\u68c0\u7d22\u6620\u5c04\u5c5e\u6027\u63d0\u4ea4\u5931\u8d25:" + ExceptionUtil.getErrorInfoDetails((List)submitOperationResult.getAllErrorOrValidateInfo()));
            }
        } else {
            log.info("\u540e\u53f0\u5d4c\u5957\u751f\u6210\u5168\u6587\u68c0\u7d22\u6620\u5c04\u5c5e\u6027\u4fdd\u5b58\u5931\u8d25:" + ExceptionUtil.getErrorInfoDetails((List)saveOperationResult.getAllErrorOrValidateInfo()));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("nests".equals(beforeF7SelectEvent.getProperty().getName())) {
            Object indexEntity = this.getModel().getValue("indexentity");
            if (indexEntity == null) {
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            String subIndexEntityKey = this.getSubIndexEntityKey((DynamicObject)indexEntity);
            if (!StringUtils.isEmpty((CharSequence)subIndexEntityKey)) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("indexentity.number", "=", (Object)subIndexEntityKey));
            }
        }
    }

    private String getSubIndexEntityKey(DynamicObject indexEntityDyn) {
        DynamicObjectType indexEntityType = BusinessDataServiceHelper.newDynamicObject((String)indexEntityDyn.getString("number")).getDynamicObjectType();
        IDataEntityProperty mappingProperty = this.getMappingProperty(indexEntityType, (String)this.getModel().getValue("mappingfield"));
        if (mappingProperty instanceof DynamicComplexProperty) {
            return ((DynamicComplexProperty)mappingProperty).getComplexType().getName();
        }
        return "";
    }

    private TreeNode getTreeNode(String entityName) {
        return FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)EntityMetadataCache.getDataEntityType((String)entityName), null);
    }
}

