/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.orm.query.QFilter;

public class PbdEsOutputEdit
extends AbstractBasePlugIn {
    private static final String TARGETENTITY = "targetentity";
    private static final String FIELDKEY = "fieldkey";
    private static final String ISARRAY = "isarray";
    private static final String FIELDTYPE = "fieldtype";
    private static final String ENTRYENTITY = "entryentity";
    private static final String STRING = "string";
    private static final String DECIMAL = "decimal";
    private static final String DATETIME = "datetime";
    private static final String INT = "int";
    private static final String BOOLEAN = "boolean";
    private static final String STRUCT = "STRUCT";
    private static final String LONG = "long";
    private static final String ESMAPPING = "esmapping";
    private static final String UPDATEFIELDINFO = "updatefieldinfo";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        Object tartgetDyn;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (UPDATEFIELDINFO.equals(afterDoOperationEventArgs.getOperateKey()) && (tartgetDyn = this.getModel().getValue(TARGETENTITY)) != null) {
            this.createEntryByTargetEntity(((DynamicObject)tartgetDyn).getString("number"));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit esMappingEdit = (BasedataEdit)this.getControl(ESMAPPING);
        esMappingEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            Object indexEntityDyn = this.getModel().getValue("indexentity");
            if (indexEntityDyn == null) {
                throw new KDBizException("indexentity first.");
            }
            QFilter filter = new QFilter("indexentity.id", "=", ((DynamicObject)indexEntityDyn).getPkValue());
            beforeF7SelectEvent.addCustomQFilter(filter);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (TARGETENTITY.equals(e.getProperty().getName())) {
            DynamicObject tartgetDyn = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.getModel().deleteEntryData(ENTRYENTITY);
            if (tartgetDyn != null) {
                String tartgetEntityNumber = tartgetDyn.getString("number");
                this.createEntryByTargetEntity(tartgetEntityNumber);
            }
        }
    }

    private void createEntryByTargetEntity(String tartgetEntityNumber) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)tartgetEntityNumber);
        Set<String> hasCreateSet = this.getHasCreatedSet();
        for (Map.Entry entry : mainEntityType.getAllEntities().entrySet()) {
            EntityType entityType = (EntityType)entry.getValue();
            if (tartgetEntityNumber.equals(entry.getKey())) {
                this.createEntry(entityType);
                continue;
            }
            int rowIndex = hasCreateSet.contains(entityType.getName()) ? this.getRowIndexFromCreated(entityType.getName(), hasCreateSet) : this.getModel().createNewEntryRow(ENTRYENTITY);
            this.setEntryTargetFieldInfo(rowIndex, entityType.getName(), STRUCT, true);
            this.insertEntry(entityType, rowIndex);
        }
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(ENTRYENTITY);
        treeEntryGrid.setCollapse(false);
        this.getView().updateView();
    }

    private int getRowIndexFromCreated(String fieldKey, Set<String> hasCreateSet) {
        int res = 0;
        for (String created : hasCreateSet) {
            if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)created)) {
                return res;
            }
            ++res;
        }
        return res;
    }

    private void createEntry(EntityType entityType) {
        Set<String> hasCreateSet = this.getHasCreatedSet();
        for (IDataEntityProperty property : entityType.getFields().values()) {
            int rowIndex;
            if (hasCreateSet.contains(property.getName())) continue;
            if (property instanceof IComplexProperty) {
                if (!(property instanceof BasedataProp)) continue;
                rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.setEntryTargetFieldInfo(rowIndex, property.getName(), LONG, false);
                continue;
            }
            if (!(property instanceof ISimpleProperty)) continue;
            rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
            String fielddType = this.getFieldType(property);
            this.setEntryTargetFieldInfo(rowIndex, property.getName(), fielddType, false);
        }
    }

    private Set<String> getHasCreatedSet() {
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject entry : entryCol) {
            res.add(entry.getString(FIELDKEY));
        }
        return res;
    }

    private void insertEntry(EntityType entityType, int rowIndex) {
        Set<String> hasCreateSet = this.getHasCreatedSet();
        for (IDataEntityProperty property : entityType.getFields().values()) {
            int curRowIndex;
            if (hasCreateSet.contains(property.getName())) continue;
            if (property instanceof IComplexProperty) {
                if (!(property instanceof BasedataProp)) continue;
                curRowIndex = this.getModel().insertEntryRow(ENTRYENTITY, rowIndex);
                this.setEntryTargetFieldInfo(curRowIndex, property.getName(), LONG, false);
                continue;
            }
            if (!(property instanceof ISimpleProperty)) continue;
            curRowIndex = this.getModel().insertEntryRow(ENTRYENTITY, rowIndex);
            String filedType = this.getFieldType(property);
            this.setEntryTargetFieldInfo(curRowIndex, property.getName(), filedType, false);
        }
    }

    private String getFieldType(IDataEntityProperty property) {
        String filedType = STRING;
        if (property instanceof DecimalProp) {
            filedType = DECIMAL;
        }
        if (property instanceof DateTimeProp) {
            filedType = DATETIME;
        }
        if (property instanceof IntegerProp) {
            filedType = INT;
        }
        if (property instanceof BooleanProp) {
            filedType = BOOLEAN;
        }
        return filedType;
    }

    private void setEntryTargetFieldInfo(int rowIndex, String fieldKey, String filedType, boolean isArray) {
        this.getModel().setValue(FIELDKEY, (Object)fieldKey, rowIndex);
        this.getModel().setValue(ISARRAY, (Object)isArray, rowIndex);
        this.getModel().setValue(FIELDTYPE, (Object)filedType, rowIndex);
    }
}

