/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.helper.apiconnector.api.AbstractApiMeta;
import kd.scm.common.helper.apiconnector.api.ApiMetaManager;
import kd.scm.common.helper.apiconnector.api.ApiParam;
import kd.scm.common.helper.apiconnector.api.util.ApiMetaUtil;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.helper.apiconnector.api.util.StringUtil;
import kd.scm.common.util.BillFormUtil;

public class PbdExtSysApiEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String PBD_MONITOR_API = "pbd_monitor_api";
    private static final String ISC_APIC_WEBAPI = "isc_apic_webapi";
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ItemClassEdit conconfig = (ItemClassEdit)this.getView().getControl("conconfig");
        conconfig.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        DynamicObject sourceDyo;
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        String contype = this.getModel().getDataEntity().getString("contype");
        if (ISC_METADATA_SCHEMA.equals(contype) && StringUtils.equals((CharSequence)fieldKey, (CharSequence)"conconfig") && (sourceDyo = (DynamicObject)this.getModel().getValue("group")) != null) {
            Long sourceId = sourceDyo.getLong("syssource.id");
            QFilter filter = new QFilter("group", "=", (Object)sourceId);
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String fieldKey = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        String contype = this.getModel().getDataEntity().getString("contype");
        if (ISC_METADATA_SCHEMA.equals(contype) && StringUtils.equals((CharSequence)"conconfig", (CharSequence)fieldKey)) {
            this.setIscMetaDataSchema(model, fieldKey, changedData, contype);
        } else if (PBD_MONITOR_API.equals(contype) && StringUtils.equals((CharSequence)"conconfig", (CharSequence)fieldKey)) {
            DynamicObject config = (DynamicObject)changedData[0].getNewValue();
            if (config == null) {
                return;
            }
            DynamicObject allConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)config.getPkValue(), (String)contype);
            this.getModel().setValue("number", (Object)allConfig.getString("number"));
            this.getModel().setValue("name", (Object)allConfig.getString("name"));
            this.getModel().setValue("full_name", (Object)allConfig.getString("full_name"));
            DynamicObject platformapitype = allConfig.getDynamicObject("platformapitype");
            if (platformapitype != null) {
                this.getModel().setValue("platformapitype", platformapitype.getPkValue());
            }
            DynamicObjectCollection inputs = allConfig.getDynamicObjectCollection("inputs");
            DynamicObjectCollection outputs = allConfig.getDynamicObjectCollection("outputs");
            this.setMonitorApiParamEntry(inputs);
            this.setMonitorApiResultEntry(outputs);
        } else if (ISC_APIC_WEBAPI.equals(contype) && StringUtils.equals((CharSequence)"conconfig", (CharSequence)fieldKey)) {
            this.setIscApicWebapi(model, fieldKey, changedData, contype);
        }
    }

    private void setMonitorApiParamEntry(DynamicObjectCollection inputs) {
        if (null == inputs || inputs.size() <= 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("inputs");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < inputs.size(); ++i) {
            vs.set("input_field", (Object)((DynamicObject)inputs.get(i)).getString("input_field"), i);
            vs.set("input_description", (Object)((DynamicObject)inputs.get(i)).getString("input_description"), i);
            vs.set("input_data_type", (Object)((DynamicObject)inputs.get(i)).getString("input_data_type"), i);
            vs.set("input_is_array", (Object)((DynamicObject)inputs.get(i)).getString("input_is_array"), i);
            vs.set("required", (Object)true, i);
        }
        model.batchCreateNewEntryRow("inputs", vs);
    }

    private void setMonitorApiResultEntry(DynamicObjectCollection outputs) {
        if (null == outputs || outputs.size() <= 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("outputs");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < outputs.size(); ++i) {
            vs.set("output_field", (Object)((DynamicObject)outputs.get(i)).getString("output_field"), i);
            vs.set("output_description", (Object)((DynamicObject)outputs.get(i)).getString("output_description"), i);
            vs.set("output_data_type", (Object)((DynamicObject)outputs.get(i)).getString("output_data_type"), i);
            vs.set("output_is_array", (Object)((DynamicObject)outputs.get(i)).getString("output_is_array"), i);
        }
        model.batchCreateNewEntryRow("outputs", vs);
    }

    private void setIscApicWebapi(IDataModel model, String fieldKey, ChangeData[] changedData, String contype) {
        DynamicObject config = (DynamicObject)changedData[0].getNewValue();
        if (config == null) {
            this.clealAll();
            return;
        }
        String number = config.getString("number");
        String name = config.getString("name");
        model.setValue("number", (Object)number);
        model.setValue("name", (Object)name);
        String selectProperties = "number,name,group,conn_type,web_req_body.req_b_param_desc,web_req_body.req_b_param_name,web_req_body.req_b_param_type,web_resp_body.resp_b_param_name,web_resp_body.resp_b_param_type,web_resp_body.resp_b_param_desc,web_resp_body.resp_b_param_desc";
        DynamicObject allConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)config.getPkValue(), (String)contype, (String)selectProperties);
        String remark = allConfig.getString("name");
        String fullName = allConfig.getString("number");
        model.setValue("description", (Object)remark);
        model.setValue("full_name", (Object)fullName);
        DynamicObjectCollection inputs = allConfig.getDynamicObjectCollection("web_req_body");
        DynamicObjectCollection outputs = allConfig.getDynamicObjectCollection("web_resp_body");
        this.setWebapiParamEntry(inputs);
        this.setWebapiResultEntry(outputs);
    }

    private void setWebapiParamEntry(DynamicObjectCollection inputs) {
        if (null == inputs || inputs.size() <= 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("inputs");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < inputs.size(); ++i) {
            vs.set("input_field", (Object)((DynamicObject)inputs.get(i)).getString("req_b_param_name"), i);
            vs.set("input_description", (Object)((DynamicObject)inputs.get(i)).getString("req_b_param_desc"), i);
            vs.set("input_data_type", (Object)this.getDataType(((DynamicObject)inputs.get(i)).getString("req_b_param_type")), i);
            vs.set("input_is_array", (Object)((DynamicObject)inputs.get(i)).getString("req_b_param_type").equalsIgnoreCase("list"), i);
            vs.set("required", (Object)true, i);
        }
        model.batchCreateNewEntryRow("inputs", vs);
    }

    private void setWebapiResultEntry(DynamicObjectCollection outputs) {
        if (null == outputs || outputs.size() <= 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("outputs");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < outputs.size(); ++i) {
            vs.set("output_field", (Object)((DynamicObject)outputs.get(i)).getString("resp_b_param_name"), i);
            vs.set("output_description", (Object)((DynamicObject)outputs.get(i)).getString("resp_b_param_desc"), i);
            vs.set("output_data_type", (Object)this.getDataType(((DynamicObject)outputs.get(i)).getString("resp_b_param_type")), i);
            vs.set("output_is_array", (Object)((DynamicObject)outputs.get(i)).getString("resp_b_param_desc").equalsIgnoreCase("list"), i);
        }
        model.batchCreateNewEntryRow("outputs", vs);
    }

    private void setIscMetaDataSchema(IDataModel model, String fieldKey, ChangeData[] changedData, String contype) {
        DynamicObject config = (DynamicObject)changedData[0].getNewValue();
        if (config == null) {
            this.clealAll();
            return;
        }
        String number = config.getString("number");
        String name = config.getString("name");
        model.setValue("number", (Object)number);
        model.setValue("name", (Object)name);
        String selectProperties = "number,name,remark,full_name,param_entryentity.param_remark,param_entryentity.param_number,param_entryentity.param_type,prop_entryentity.prop_remark,prop_entryentity.prop_name,prop_entryentity.prop_label,prop_entryentity.data_type";
        DynamicObject allConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)config.getPkValue(), (String)contype, (String)selectProperties);
        String remark = allConfig.getString("remark");
        String fullName = allConfig.getString("full_name");
        model.setValue("description", (Object)remark);
        model.setValue("full_name", (Object)fullName);
        DynamicObjectCollection inputs = allConfig.getDynamicObjectCollection("param_entryentity");
        DynamicObjectCollection outputs = allConfig.getDynamicObjectCollection("prop_entryentity");
        this.setParamEntry(inputs);
        this.setResultEntry(outputs);
    }

    private void clealAll() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("inputs");
        model.deleteEntryData("outputs");
        model.setValue("number", null);
        model.setValue("name", null);
        model.setValue("description", null);
        model.setValue("full_name", null);
    }

    private void setParamEntry(DynamicObjectCollection inputs) {
        if (null == inputs || inputs.size() <= 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("inputs");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < inputs.size(); ++i) {
            vs.set("input_field", (Object)((DynamicObject)inputs.get(i)).getString("param_number"), i);
            vs.set("input_description", (Object)((DynamicObject)inputs.get(i)).getString("param_remark"), i);
            vs.set("input_data_type", (Object)this.getDataType(((DynamicObject)inputs.get(i)).getString("param_type")), i);
            vs.set("input_is_array", (Object)((DynamicObject)inputs.get(i)).getString("param_type").equalsIgnoreCase("list"), i);
            vs.set("required", (Object)true, i);
        }
        model.batchCreateNewEntryRow("inputs", vs);
    }

    private void setResultEntry(DynamicObjectCollection outputs) {
        if (null == outputs || outputs.size() <= 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("outputs");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < outputs.size(); ++i) {
            vs.set("output_field", (Object)((DynamicObject)outputs.get(i)).getString("prop_name"), i);
            vs.set("output_description", (Object)this.getDescription((DynamicObject)outputs.get(i), "prop_label", "prop_remark"), i);
            vs.set("output_data_type", (Object)this.getDataType(((DynamicObject)outputs.get(i)).getString("data_type")), i);
            vs.set("output_is_array", (Object)((DynamicObject)outputs.get(i)).getString("data_type").equalsIgnoreCase("list"), i);
        }
        model.batchCreateNewEntryRow("outputs", vs);
    }

    private String getDescription(DynamicObject dyo, String key1, String key2) {
        String title = dyo.getString(key1);
        String remark = dyo.getString(key2);
        if (StringUtils.isBlank((CharSequence)title)) {
            return remark;
        }
        if (StringUtils.isBlank((CharSequence)remark)) {
            return title;
        }
        return title + "," + remark;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operationKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("test".equals(operationKey) && ((String)this.getModel().getValue("enable")).equals("0")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u8be5API\u3002", (String)"PbdExtSysApiEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        long id = (Long)this.getModel().getValue("id");
        if ("test".equals(operationKey)) {
            Map<String, Object> params;
            DynamicObject exApi = BusinessDataServiceHelper.loadSingle((Object)id, (String)"pbd_extsys_api");
            try {
                params = this.prepareApiTestParams(exApi);
            }
            catch (Exception e) {
                this.getView().showMessage(e.getMessage(), StringUtil.toString((Throwable)e), MessageTypes.Default);
                return;
            }
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pbd_api_test", params, null, (ShowType)ShowType.Modal));
        }
    }

    public Map<String, Object> prepareApiTestParams(DynamicObject exApi) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>(10);
        String apiNumber = exApi.getString("full_name");
        DynamicObject link = BusinessDataServiceHelper.loadSingleFromCache((Object)exApi.getDynamicObject("group.syssource").getPkValue(), (String)"isc_data_source", (String)"dblink");
        String selectPro = "server_ip,http_protocal,server_port";
        DynamicObject linkConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)link.getLong("dblink_id"), (String)"isc_database_link", (String)selectPro);
        String port = linkConfig.getString("server_port");
        String resultUrl = linkConfig.getString("http_protocal") + "://" + linkConfig.getString("server_ip") + (StringUtils.isNotBlank((CharSequence)port) && !StringUtils.equals((CharSequence)port, (CharSequence)"0") ? ":" + port : "") + apiNumber;
        AbstractApiMeta meta = ApiMetaManager.getById((Long)Parser.toLong((Object)exApi.getPkValue()), (String)this.getView().getEntityId());
        String paramStr = ApiMetaUtil.getInputParamSimpleString((ApiParam)meta.getInputs());
        params.put("name", exApi.getString("name"));
        params.put("url", resultUrl);
        params.put("paramStr", paramStr);
        params.put("apiNumber", exApi.getString("number"));
        return params;
    }

    private String getDataType(String key) {
        switch (StringUtils.lowerCase((String)key)) {
            case "int": {
                return "int";
            }
            case "decimal": {
                return "decimal";
            }
            case "datetime": 
            case "date": {
                return "datetime";
            }
            case "long": {
                return "long";
            }
            case "boolean": {
                return "boolean";
            }
            case "ENUM": {
                return "ENUM";
            }
            case "STRUCT": 
            case "map": {
                return "STRUCT";
            }
        }
        return "string";
    }
}

