/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleConfigType;
import kd.scm.pbd.formplugin.ScHandleDataIsvUtil;

public class PbdScDataHandleEdit
extends AbstractBillPlugIn {
    private static final String ENTRYE_NTITY = "refentity";
    private static final String CONFIG_ENTITY = "configentity";

    public void registerListener(EventObject e) {
        TextEdit handleconfig;
        TextEdit scdataconfigtext;
        super.registerListener(e);
        TextEdit scserviceconfig = (TextEdit)this.getControl("scserviceconfig");
        if (scserviceconfig != null) {
            scserviceconfig.addClickListener((ClickListener)this);
        }
        if ((scdataconfigtext = (TextEdit)this.getControl("scdataconfigtext")) != null) {
            scdataconfigtext.addClickListener((ClickListener)this);
        }
        if ((handleconfig = (TextEdit)this.getControl("handleconfig")) != null) {
            handleconfig.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.setIsvInfo();
        this.initOperate(true);
    }

    public void afterLoadData(EventObject e) {
        this.initOperate(true);
    }

    private void setIsvInfo() {
        ISVInfo isvInfo = ISVServiceHelper.getISVInfo();
        if (isvInfo != null && isvInfo.getId() != null) {
            this.getModel().beginInit();
            this.getModel().setValue("isv", (Object)isvInfo.getId());
            this.getModel().endInit();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initIsv();
        if (this.handleDataCheck()) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
        } else {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            DynamicObject dataEntity;
            String pk;
            TextEdit evtSource = (TextEdit)evt.getSource();
            String key = evtSource.getKey();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"scserviceconfig") && (pk = (dataEntity = this.getModel().getDataEntity()).getString("id")) != null && !pk.trim().isEmpty()) {
                DynamicObject entity = this.getModel().getDataEntity().getDynamicObject("entity");
                if (entity != null) {
                    int currentRowIndex = evtSource.getModel().getEntryCurrentRowIndex(evtSource.getEntryKey());
                    DynamicObject scdataservice = this.getModel().getEntryRowEntity(evtSource.getEntryKey(), currentRowIndex).getDynamicObject("scdataservice");
                    if (scdataservice != null) {
                        FormShowParameter formShowParameter = new FormShowParameter();
                        formShowParameter.getCustomParams().put("scdatahandle", pk);
                        formShowParameter.getCustomParams().put("isv", dataEntity.getString("isv"));
                        formShowParameter.getCustomParams().put("scdatahandleentity", entity.getString("id"));
                        String keyData = this.getModel().getEntryRowEntity(evtSource.getEntryKey(), currentRowIndex).getString(key);
                        if (keyData != null && !keyData.trim().isEmpty()) {
                            formShowParameter.getCustomParams().put("scserviceconfig", keyData);
                        }
                        formShowParameter.getCustomParams().put("scdataservice", scdataservice.getString("id"));
                        formShowParameter.getCustomParams().put("scdataserviceentity", scdataservice.getDynamicObject("entity").getString("id"));
                        formShowParameter.getCustomParams().put("handleproperty", scdataservice.getString("handleproperty"));
                        formShowParameter.setFormId("pbd_serviceconfig");
                        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scserviceconfig"));
                        this.getView().showForm(formShowParameter);
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u5148\u8bbe\u7f6e\u5f53\u524d\u884c\u201c\u6267\u884c\u670d\u52a1\u201d\u7684\u503c\u3002", (String)"PbdScDataHandleEdit_4", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u5148\u8bbe\u7f6e\u201c\u6267\u884c\u8bf7\u6c42\u5b9e\u4f53\u201d\u7684\u503c\u3002", (String)"PbdScDataHandleEdit_5", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                }
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"scdataconfigtext")) {
                String scdataconfigid = null;
                HashMap<String, Object> customMap = new HashMap<String, Object>(1);
                int currentRowIndex = evtSource.getModel().getEntryCurrentRowIndex(evtSource.getEntryKey());
                String keyData = this.getModel().getEntryRowEntity(evtSource.getEntryKey(), currentRowIndex).getString(key);
                DynamicObject scdataconfig = this.getModel().getEntryRowEntity(evtSource.getEntryKey(), currentRowIndex).getDynamicObject("scdataconfig");
                if (keyData != null && !keyData.isEmpty()) {
                    customMap.put("scdatahandleargs", keyData);
                }
                if (scdataconfig != null) {
                    scdataconfigid = scdataconfig.getString("id");
                }
                if (scdataconfigid != null) {
                    this.openScDataConfig(scdataconfigid, customMap);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u5148\u8bbe\u7f6e\u201c\u5904\u7406\u53c2\u6570\u201d\u7684\u503c\u3002", (String)"PbdScDataHandleEdit_6", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                }
            }
            if (StringUtils.equals((CharSequence)key, (CharSequence)"handleconfig") && (pk = (dataEntity = this.getModel().getDataEntity()).getString("id")) != null && !pk.isEmpty()) {
                DynamicObject entityDynamicObject = dataEntity.getDynamicObject("entity");
                if (entityDynamicObject != null) {
                    FormShowParameter formShowParameter = new FormShowParameter();
                    formShowParameter.getCustomParams().put("scdatahandle", pk);
                    formShowParameter.getCustomParams().put("isv", dataEntity.getString("isv"));
                    formShowParameter.getCustomParams().put("scdatahandleentity", entityDynamicObject.getString("id"));
                    String handleconfig = this.getModel().getDataEntity().getString("handleconfig");
                    if (handleconfig != null && !handleconfig.isEmpty()) {
                        formShowParameter.getCustomParams().put("handleconfig", handleconfig);
                    }
                    StyleCss css = new StyleCss();
                    css.setWidth("660px");
                    css.setHeight("580px");
                    formShowParameter.getOpenStyle().setInlineStyleCss(css);
                    formShowParameter.setFormId("pbd_handleconfig");
                    formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "handleconfig"));
                    this.getView().showForm(formShowParameter);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u8981\u5148\u8bbe\u7f6e\u201c\u6267\u884c\u8bf7\u6c42\u5b9e\u4f53\u201d\u7684\u503c\u3002", (String)"PbdScDataHandleEdit_5", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void openScDataConfig(Object primaryKeyValue, Map<String, Object> customMap) {
        BillShowParameter billShowParameter = new BillShowParameter();
        String scdatachannelId = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_scdataconfig", (String)"scdatachannel", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)}, (String)"id", (int)1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                scdatachannelId = row.getString("scdatachannel");
            }
        }
        billShowParameter.setFormId(ScDataHandleConfigType.getChannelType(scdatachannelId));
        billShowParameter.setPkId(primaryKeyValue);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scdataconfigtext"));
        billShowParameter.setBillStatus(BillOperationStatus.EDIT);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("780px");
        billShowParameter.getOpenStyle().setInlineStyleCss(css);
        if (customMap != null) {
            billShowParameter.getCustomParams().putAll(customMap);
        }
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "scserviceconfig": {
                if (returnData == null || returnData.toString().isEmpty()) break;
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYE_NTITY);
                this.getModel().setValue("scserviceconfig", returnData, currentRowIndex);
                break;
            }
            case "scdataconfigtext": {
                if (returnData == null || returnData.toString().isEmpty()) break;
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(CONFIG_ENTITY);
                this.getModel().setValue("scdataconfigtext", returnData, currentRowIndex);
                break;
            }
            case "handleconfig": {
                if (returnData == null || returnData.toString().isEmpty()) break;
                this.getModel().setValue("handleconfig", returnData);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"entity")) {
            this.initOperate(false);
        }
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"handleclass")) {
            try {
                TypesContainer.createInstance((String)e.getChangeSet()[0].getNewValue().toString());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u90e8\u7f72\u68c0\u67e5\u6210\u529f\u3002", (String)"PbdScDataHandleEdit_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u90e8\u7f72\u68c0\u67e5\u5931\u8d25\uff0c{0}", (String)"PbdScDataHandleEdit_2", (String)"scm-pbd-formplugin", (Object[])new Object[]{ex.getLocalizedMessage()}));
            }
        }
    }

    private void initIsv() {
        if (ISVServiceHelper.isKingdeeISV()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"isv"});
        }
    }

    private boolean handleDataCheck() {
        boolean checkFlag = Boolean.TRUE;
        String isv = this.getModel().getDataEntity().getString("isv");
        Map<String, Object> handleDataIsvCheck = ScHandleDataIsvUtil.handleDataIsvCheck(isv);
        if (!((Boolean)handleDataIsvCheck.get("succed")).booleanValue()) {
            this.getView().showErrorNotification((String)handleDataIsvCheck.get("message"));
            checkFlag = Boolean.FALSE;
        }
        return checkFlag;
    }

    private void initOperate(boolean isInit) {
        ComboEdit operatekey = (ComboEdit)this.getView().getControl("operate");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        DynamicObject entity = this.getModel().getDataEntity().getDynamicObject("entity");
        ComboItem operate = null;
        if (entity != null) {
            List ops = EntityMetadataCache.getDataEntityOperate((String)entity.getString("number"));
            for (Map op : ops) {
                String opTypeId = (String)op.get("type");
                if (!OperationTypeCache.isEntityOperation((String)opTypeId)) continue;
                String opKey = (String)op.get("key");
                Map mapLocaleString = (Map)op.get("name");
                String opName = opKey;
                if (mapLocaleString != null) {
                    opName = LocaleString.fromMap((Map)mapLocaleString).toString() + "(" + opKey + ")";
                }
                operate = new ComboItem(new LocaleString(opName), opKey);
                comboItems.add(operate);
            }
        }
        operatekey.setComboItems(comboItems);
    }
}

