/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleConfigType;
import kd.scm.common.helper.scdatahandle.entity.ScDataServiceInfo;
import kd.scm.pbd.formplugin.ScHandleDataIsvUtil;

public class PbdScDataServiceParamConfigEdit
extends AbstractFormPlugin {
    private static final String CONFIG_ENTITY = "configentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok", "scdataconfigtext"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && !customParams.isEmpty()) {
            Object scdataservice;
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            Object scdatahandle = customParams.get("scdatahandle");
            Object scdatahandleentity = customParams.get("scdatahandleentity");
            if (scdatahandle != null) {
                model.setValue("scdatahandle", scdatahandle);
            }
            if (scdatahandleentity != null) {
                this.initLinkProperty(scdatahandleentity.toString());
            }
            if ((scdataservice = customParams.get("scdataservice")) != null) {
                model.setValue("scdataservice", scdataservice);
            }
            Object scdataserviceentity = customParams.get("scdataserviceentity");
            Object handleproperty = customParams.get("handleproperty");
            if (scdataserviceentity != null && handleproperty != null) {
                this.initValueProperty(scdataserviceentity.toString());
                this.initHandleVales(scdataserviceentity.toString(), handleproperty.toString());
            }
            Object scserviceconfig = customParams.get("scserviceconfig");
            TableValueSetter ts = new TableValueSetter(new String[0]);
            int i = 0;
            if (scserviceconfig != null) {
                Map scDataHandleArgsMap;
                String handlevalues;
                String valueproperty;
                ScDataServiceInfo scDataServiceInfo = (ScDataServiceInfo)SerializationUtils.fromJsonString((String)scserviceconfig.toString(), ScDataServiceInfo.class);
                String linkproperty = scDataServiceInfo.getLinkProperty();
                if (linkproperty != null) {
                    model.setValue("linkproperty", (Object)linkproperty);
                }
                if ((valueproperty = scDataServiceInfo.getValueProperty()) != null) {
                    model.setValue("valueproperty", (Object)valueproperty);
                }
                if ((handlevalues = scDataServiceInfo.getHandleValues()) != null) {
                    model.setValue("handlevalues", (Object)handlevalues);
                }
                if ((scDataHandleArgsMap = scDataServiceInfo.getScDataHandleArgsMap()) != null && !scDataHandleArgsMap.isEmpty()) {
                    for (Map.Entry entry : scDataHandleArgsMap.entrySet()) {
                        ts.set("scdataconfig", entry.getKey(), i);
                        ts.set("scdataconfigtext", entry.getValue(), i);
                        ++i;
                    }
                } else {
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"pbd_scdataconfig", (String)"pbd_scdataconfig", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")}, (String)"id");){
                        while (dataSet.hasNext()) {
                            Row row = dataSet.next();
                            ts.set("scdataconfig", (Object)row.getString("id"), i);
                            ++i;
                        }
                    }
                }
            } else {
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"pbd_scdataconfig", (String)"pbd_scdataconfig", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")}, (String)"id");){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        ts.set("scdataconfig", (Object)row.getString("id"), i);
                        ++i;
                    }
                }
            }
            model.beginInit();
            model.batchCreateNewEntryRow(CONFIG_ENTITY, ts);
            model.endInit();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && !customParams.isEmpty()) {
            String isv = String.valueOf(customParams.get("isv"));
            if (isv != null && !isv.isEmpty()) {
                Map<String, Object> handleDataIsvCheck = ScHandleDataIsvUtil.handleDataIsvCheck(isv);
                if (!((Boolean)handleDataIsvCheck.get("succed")).booleanValue()) {
                    this.getView().showErrorNotification((String)handleDataIsvCheck.get("message"));
                    this.setEnableFromIsv(false);
                } else {
                    this.setEnableFromIsv(true);
                }
            } else {
                this.setEnableFromIsv(false);
            }
        } else {
            this.setEnableFromIsv(false);
        }
    }

    private void setEnableFromIsv(Boolean isEnable) {
        this.getView().setEnable(isEnable, new String[]{"linkproperty", "handleproperty", "handlevalues"});
    }

    public void click(EventObject evt) {
        TextEdit textEdit;
        String key;
        Button button;
        super.click(evt);
        Object evtSource = evt.getSource();
        if (evtSource instanceof Button && StringUtils.equals((CharSequence)(button = (Button)evtSource).getKey(), (CharSequence)"btnok")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject scdataservice = dataEntity.getDynamicObject("scdataservice");
            if (scdataservice != null) {
                ScDataServiceInfo scDataServiceInfo = new ScDataServiceInfo();
                scDataServiceInfo.setServiceId(scdataservice.getString("id"));
                scDataServiceInfo.setServiceClass(scdataservice.getString("serviceclass"));
                scDataServiceInfo.setIsv(scdataservice.getString("isv"));
                scDataServiceInfo.setEntityKey(scdataservice.getDynamicObject("entity").getString("id"));
                String linkProperty = dataEntity.getString("linkproperty");
                scDataServiceInfo.setLinkProperty(linkProperty);
                String handleProperty = dataEntity.getString("handleproperty");
                scDataServiceInfo.setHandleProperty(handleProperty);
                String valueProperty = dataEntity.getString("valueproperty");
                if (valueProperty != null && !valueProperty.contains(handleProperty)) {
                    valueProperty = valueProperty.endsWith(",") ? valueProperty + handleProperty : valueProperty + "," + handleProperty;
                }
                scDataServiceInfo.setValueProperty(valueProperty);
                scDataServiceInfo.setHandleValues(dataEntity.getString("handlevalues"));
                String handleValues = dataEntity.getString("handlevalues");
                if (handleValues != null) {
                    String[] verifyKeys = handleValues.split(",");
                    HashSet<Object> valuesKeys = new HashSet<Object>(verifyKeys.length);
                    for (String v : verifyKeys) {
                        if (v == null || v.isEmpty()) continue;
                        valuesKeys.add(v);
                    }
                    scDataServiceInfo.setHandleValuesSet(valuesKeys);
                }
                DynamicObjectCollection configentity = dataEntity.getDynamicObjectCollection(CONFIG_ENTITY);
                HashMap<String, String> scDataHandleArgsMap = new HashMap<String, String>(configentity.size());
                for (DynamicObject config : configentity) {
                    scDataHandleArgsMap.putIfAbsent(config.getDynamicObject("scdataconfig").getString("id"), config.getString("scdataconfigtext"));
                }
                scDataServiceInfo.setScDataHandleArgsMap(scDataHandleArgsMap);
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)scDataServiceInfo));
            }
            this.getView().close();
        }
        if (evt.getSource() instanceof TextEdit && StringUtils.equals((CharSequence)(key = (textEdit = (TextEdit)evt.getSource()).getKey()), (CharSequence)"scdataconfigtext")) {
            String scdataconfigid = null;
            HashMap<String, Object> customMap = new HashMap<String, Object>(1);
            int currentRowIndex = textEdit.getModel().getEntryCurrentRowIndex(textEdit.getEntryKey());
            String keyData = this.getModel().getEntryRowEntity(textEdit.getEntryKey(), currentRowIndex).getString(key);
            DynamicObject scdataconfig = this.getModel().getEntryRowEntity(textEdit.getEntryKey(), currentRowIndex).getDynamicObject("scdataconfig");
            if (keyData != null && !keyData.isEmpty()) {
                customMap.put("scdatahandleargs", keyData);
            }
            if (scdataconfig != null) {
                scdataconfigid = scdataconfig.getString("id");
            }
            if (scdataconfigid != null) {
                this.openScDataConfig(scdataconfigid, customMap);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u201c\u5904\u7406\u53c2\u6570\u201d\u7684\u503c\u3002", (String)"PbdScDataServiceParamConfigEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "scdataconfigtext": {
                if (returnData == null || returnData.toString().isEmpty()) break;
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(CONFIG_ENTITY);
                this.getModel().setValue("scdataconfigtext", returnData, currentRowIndex);
                break;
            }
        }
    }

    private void openScDataConfig(Object primaryKeyValue, Map<String, Object> customMap) {
        BillShowParameter billShowParameter = new BillShowParameter();
        String scdatachannelId = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_scdataconfig", (String)"scdatachannel", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)}, (String)"id", (int)1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                scdatachannelId = row.getString("scdatachannel");
            }
        }
        billShowParameter.setFormId(ScDataHandleConfigType.getChannelType(scdatachannelId));
        billShowParameter.setPkId(primaryKeyValue);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scdataconfigtext"));
        billShowParameter.setBillStatus(BillOperationStatus.EDIT);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("780px");
        billShowParameter.getOpenStyle().setInlineStyleCss(css);
        if (customMap != null) {
            billShowParameter.getCustomParams().putAll(customMap);
        }
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void initLinkProperty(String handleEntity) {
        ComboEdit refproperty = (ComboEdit)this.getControl("linkproperty");
        if (handleEntity != null && !handleEntity.trim().isEmpty()) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)handleEntity);
            refproperty.setComboItems(this.assembleProperty(mainEntityType, "id"));
        }
    }

    private void initValueProperty(String serviceEntity) {
        ComboEdit valueproperty = (ComboEdit)this.getControl("valueproperty");
        if (serviceEntity != null && !serviceEntity.trim().isEmpty()) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)serviceEntity);
            valueproperty.setComboItems(this.assembleProperty(mainEntityType, ""));
        }
    }

    private void initHandleVales(String serviceEntity, String handleFiled) {
        ComboEdit handlevalues = (ComboEdit)this.getControl("handlevalues");
        ComboEdit handleproperty = (ComboEdit)this.getControl("handleproperty");
        if (serviceEntity != null && !serviceEntity.trim().isEmpty() && handleFiled != null && !handleFiled.trim().isEmpty()) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)serviceEntity);
            DynamicProperty handlepropertyType = mainEntityType.getProperty(handleFiled);
            if (handlepropertyType instanceof ComboProp) {
                handlevalues.setComboItems(this.assembleHandleValues((ComboProp)handlepropertyType));
            }
            if (handlepropertyType != null && handleproperty != null) {
                this.getModel().setValue("handleproperty", (Object)handleFiled);
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(1);
                ComboItem property = new ComboItem(new LocaleString(handlepropertyType.getDisplayName() + "(" + handlepropertyType.getName() + ")"), handlepropertyType.getName());
                comboItems.add(property);
                handleproperty.setComboItems(comboItems);
            }
        }
    }

    private List<ComboItem> assembleProperty(MainEntityType mainEntityType, String suffix) {
        ComboItem property = null;
        Map typeAllFields = mainEntityType.getAllFields();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(typeAllFields.size());
        for (Map.Entry entry : typeAllFields.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.endsWith(suffix)) continue;
            IDataEntityProperty value = (IDataEntityProperty)entry.getValue();
            if (value.getParent() instanceof EntryType) {
                key = value.getParent().getName() + "." + key;
            }
            property = new ComboItem(new LocaleString(value.getDisplayName() + "(" + key + ")"), key);
            comboItems.add(property);
        }
        return comboItems;
    }

    private List<ComboItem> assembleHandleValues(ComboProp comboProp) {
        List comboItems;
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        ComboItem property = null;
        if (comboProp != null && (comboItems = comboProp.getComboItems()) != null) {
            for (ValueMapItem valueMapItem : comboItems) {
                property = new ComboItem(new LocaleString(valueMapItem.getName() + "(" + valueMapItem.getValue() + ")"), valueMapItem.getValue());
                comboItemList.add(property);
            }
        }
        return comboItemList;
    }
}

