/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.edit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ScmcUtil;

public class PbdSupplierTplEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String PROVINCE = "province";
    private static final String CTIY = "city";
    private static final String TABAP = "tabap";
    private static final String EXAMTABAP = "approveinfo";
    private static final String TAXRATEID = "taxrateid";
    private static final String INVOICETYPE = "invoicetypeid";

    public void registerListener(EventObject e) {
        BasedataEdit invoicetype;
        super.registerListener(e);
        e.getSource();
        BasedataEdit city = (BasedataEdit)this.getView().getControl(CTIY);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        if (Objects.nonNull(tab)) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        if (null != city) {
            city.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((invoicetype = (BasedataEdit)this.getView().getControl(INVOICETYPE)) != null) {
            invoicetype.addBeforeF7SelectListener(this::beforeF7Select);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        IDataModel model = this.getModel();
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        int index = arg0.getRow();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)CTIY)) {
            DynamicObjectCollection province = (DynamicObjectCollection)model.getValue(PROVINCE, index);
            ArrayList<String> proLongNumberList = new ArrayList<String>();
            for (DynamicObject pro : province) {
                String proID = ((DynamicObject)pro.get(1)).getString("id");
                proLongNumberList.add(proID);
            }
            QFilter filter = new QFilter("parent", "in", (Object)ScmcUtil.getLongList(proLongNumberList));
            showParameter.getListFilterParameter().getQFilters().add(filter);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)INVOICETYPE)) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_invoicetype", (String)"id,number,name,bd_applicationfield", (QFilter[])new QFilter[]{new QFilter("bd_applicationfield.fbasedataId.number", "=", (Object)"PUR")});
            List ids = query.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            showParameter.getListFilterParameter().setFilter(new QFilter("bd_applicationfield", "in", ids));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity("scopeentity");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObjectCollection province = (DynamicObjectCollection)model.getValue(PROVINCE, i);
            if (province.size() == 1) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{CTIY});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{CTIY});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        IDataModel model = this.getModel();
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "newentry_scope": {
                DynamicObjectCollection entries = model.getEntryEntity("scopeentity");
                this.getView().setEnable(Boolean.FALSE, entries.size() - 1, new String[]{CTIY});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        int rowIndex = changedData[0].getRowIndex();
        switch (name) {
            case "province": {
                DynamicObjectCollection province = (DynamicObjectCollection)model.getValue(PROVINCE, rowIndex);
                model.setValue("longnumber", null, rowIndex);
                model.setValue(CTIY, null, rowIndex);
                if (province.size() == 1) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{CTIY});
                } else {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{CTIY});
                }
                ArrayList<String> proLongNumberList = new ArrayList<String>();
                for (DynamicObject pro : province) {
                    String longnumber = ((DynamicObject)pro.get(1)).getString("longnumber");
                    proLongNumberList.add(longnumber);
                }
                model.setValue("longnumber", (Object)String.join((CharSequence)",", proLongNumberList), rowIndex);
                break;
            }
            case "city": {
                DynamicObjectCollection procoll = (DynamicObjectCollection)model.getValue(PROVINCE, rowIndex);
                if (this.checkBeforeSave(model)) {
                    DynamicObjectCollection cities = (DynamicObjectCollection)model.getValue(CTIY, rowIndex);
                    if (null == cities || cities.size() == 0) {
                        model.setValue("longnumber", null, rowIndex);
                        if (procoll.size() == 0) {
                            model.setValue("longnumber", null, rowIndex);
                            break;
                        }
                        model.setValue("longnumber", (Object)((DynamicObject)((DynamicObject)procoll.get(0)).get(1)).getString("longnumber"), rowIndex);
                        break;
                    }
                    ArrayList<String> cityLongNumberList = new ArrayList<String>();
                    for (DynamicObject city : cities) {
                        String longnumber = ((DynamicObject)city.get(1)).getString("longnumber");
                        cityLongNumberList.add(longnumber);
                    }
                    model.setValue("longnumber", (Object)String.join((CharSequence)",", cityLongNumberList), rowIndex);
                    break;
                }
                model.setValue(CTIY, null, rowIndex);
                if (procoll.size() == 0) {
                    model.setValue("longnumber", null, rowIndex);
                    break;
                }
                model.setValue("longnumber", (Object)((DynamicObject)((DynamicObject)procoll.get(0)).get(1)).getString("longnumber"), rowIndex);
                break;
            }
            case "taxrateid": {
                if (!Objects.isNull(this.getModel().getValue(TAXRATEID))) break;
                this.getModel().setValue("taxrate", null);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        if (operateKey.equals("submit") && !this.checkBeforeSave(model)) {
            args.setCancel(true);
            return;
        }
    }

    private boolean checkBeforeSave(IDataModel model) {
        HashMap<String, Integer> proMap = new HashMap<String, Integer>();
        DynamicObjectCollection entries = model.getEntryEntity("scopeentity");
        if (null != entries && entries.size() >= 1) {
            for (int i = 0; i < entries.size(); ++i) {
                int j = i + 1;
                DynamicObject entry = (DynamicObject)entries.get(i);
                DynamicObjectCollection city = (DynamicObjectCollection)entry.get(CTIY);
                if (null == city || city.size() == 0) {
                    DynamicObjectCollection provinces = (DynamicObjectCollection)entry.get(PROVINCE);
                    for (DynamicObject obj : provinces) {
                        DynamicObject pro = obj.getDynamicObject(1);
                        if (null != proMap.get(pro.getPkValue().toString())) {
                            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u516c\u53f8\u7b80\u4ecb\u9875\u7b7e\u4f9b\u8d27\u8303\u56f4\u5206\u5f55\uff0c\u7b2c{0}\u884c\u5206\u5f55\u548c\u7b2c{1}\u884c\u5206\u5f55\u5b58\u5728\u76f8\u540c\u7701\u4efd\u4e14\u540c\u65f6\u672a\u5f55\u5165\u5e02\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PbdSupplierTplEdit_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]), j, proMap.get(pro.getPkValue().toString())));
                            return false;
                        }
                        proMap.put(pro.getPkValue().toString(), j);
                    }
                    continue;
                }
                for (DynamicObject obj : city) {
                    DynamicObject cobj = obj.getDynamicObject(1);
                    if (null != proMap.get(cobj.getPkValue().toString())) {
                        this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u516c\u53f8\u7b80\u4ecb\u9875\u7b7e\u4f9b\u8d27\u8303\u56f4\u5206\u5f55\uff0c\u7b2c{0}\u884c\u5206\u5f55\u548c\u7b2c{1}\u884c\u5206\u5f55\u5b58\u5728\u76f8\u540c\u5e02\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PbdSupplierTplEdit_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]), j, proMap.get(cobj.getPkValue().toString())));
                        return false;
                    }
                    proMap.put(cobj.getPkValue().toString(), j);
                }
            }
        }
        return true;
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        DynamicObjectCollection entry_exams;
        String tabKey = tabSelectEvent.getTabKey();
        if (tabKey.equals(EXAMTABAP) && Objects.nonNull(entry_exams = this.getModel().getDataEntity(true).getDynamicObjectCollection("entry_exam")) && entry_exams.size() > 1) {
            Collections.sort(entry_exams, (x, y) -> y.getDate("examtime").compareTo(x.getDate("examtime")));
            this.getView().updateView("entry_exam");
        }
    }
}

