/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.list;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.pbd.formplugin.util.PbdMalUtil;

public class PbdAddressList
extends StandardTreeListPlugin
implements TreeNodeQueryListener {
    private static final String KEY_TREEVIEW = "treeview";
    private static final String EMAL_TYPE = "emaltype";
    private static final String ADDRESS = "addressid";
    private static final String EMAL_ADDRESS = "emaladdress";
    private static final String MATCH_STATUS = "matchstatus";
    private static final Integer COUNTRY_NUMBER = 1000001;
    private static final String ENTITY = "pbd_maladdressrel";
    private static final String AUTO_MATCH_DIALOG = "pbd_automatch";
    private static final String AUTO_MATCH_STATUS_DIALOG = "pbd_matchstatus";
    private static final String ROOT_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final Integer NOT_MATCH = 1;
    private static final Integer FAIL_MATCH = 3;
    private static final String AFTER_AUTO_MATCH = "afterAutoMatch";
    private static final String AFTER_SHOW_AUTO_MATCH = "afterShowAutoMatch";

    public void initialize() {
        super.initialize();
    }

    public void setFilter(SetFilterEvent e) {
        List qfs = e.getQFilters();
        qfs.add(new QFilter(EMAL_TYPE, "=", this.getModel().getValue(EMAL_TYPE)));
        if (this.getModel().getValue(MATCH_STATUS) != null) {
            qfs.add(new QFilter(MATCH_STATUS, "=", this.getModel().getValue(MATCH_STATUS)));
        } else {
            String currentNodeId = (String)this.getTreeModel().getCurrentNodeId();
            if (!currentNodeId.equals(ROOT_ID)) {
                if (PbdMalUtil.isCountry(currentNodeId)) {
                    qfs.add(new QFilter("addressid.country", "=", (Object)Long.parseLong(currentNodeId)));
                } else {
                    DynamicObject dyo = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(currentNodeId), (String)"bd_admindivision");
                    if (null != dyo && StringUtils.isNotBlank((CharSequence)dyo.getString("number"))) {
                        qfs.add(new QFilter("addressid.longnumber", "like", (Object)("%" + dyo.getString("number") + ".%")));
                    }
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView tv1 = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tv1.addTreeNodeQueryListener((TreeNodeQueryListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals(EMAL_TYPE)) {
            this.getView().updateView();
        }
    }

    public void afterCreateNewData(EventObject e) {
        ComboEdit comboEdit = (ComboEdit)this.getControl(EMAL_TYPE);
        List<ComboItem> data = PbdMalUtil.getAddressComboItemList();
        comboEdit.setComboItems(data);
        this.getModel().setValue(EMAL_TYPE, (Object)EcPlatformEnum.ECPLATFORM_JD.getVal());
        this.getModel().setValue(MATCH_STATUS, null);
    }

    public void initializeTree(EventObject e) {
        ITreeModel treeModel = this.getTreeModel();
        TreeNode rootNode = this.getRootNode();
        treeModel.setRoot(rootNode);
    }

    public TreeNode getRootNode() {
        TreeNode rootNode = this.getTreeModel().createRootNode();
        rootNode.setText(ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212", (String)"PbdAddressList_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"bd_country", (String)"bd_country", (String)"id,number,name", null, (String)null);){
            for (Row row : ds) {
                String name = row.getString("name");
                String id = row.getString("id");
                boolean isParent = !row.getString("id").equals("1000008") && !row.getString("id").equals("1000006");
                TreeNode node = new TreeNode(rootNode.getId(), id, name, isParent, (Object)row);
                rootNode.addChild(node);
            }
        }
        return rootNode;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.getNodeChildren(e);
    }

    public void queryTreeNodeChildren(TreeNodeEvent e) {
        this.getNodeChildren(e);
    }

    public void getNodeChildren(TreeNodeEvent e) {
        this.getModel().setValue(MATCH_STATUS, null);
        String parentId = (String)e.getNodeId();
        TreeView tv = (TreeView)e.getSource();
        if (e.getNodeId().equals(ROOT_ID)) {
            TreeNode root = this.getRootNode();
            tv.addNodes(root.getChildren());
        } else {
            QFilter filter = new QFilter("parent", "=", (Object)Long.parseLong(parentId));
            if (PbdMalUtil.isCountry((String)e.getNodeId())) {
                filter = new QFilter("parent", "=", (Object)0);
                filter.and(new QFilter("country", "=", (Object)Long.parseLong(parentId)));
            }
            QFilter[] filters = new QFilter[]{filter};
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getNodeChildren", (String)"bd_admindivision", (String)"id,number,name,isleaf", (QFilter[])filters, (String)null);){
                for (Row row : ds) {
                    String name = row.getString("name");
                    String id = row.getString("id");
                    tv.addNode(new TreeNode(parentId, id, name, row.getBoolean("isleaf") == false));
                }
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "remove": {
                this.handleRemove();
                break;
            }
            case "automatch": {
                this.handleAutoMatch();
                break;
            }
            case "init": {
                this.init();
                break;
            }
            case "manualmatch": {
                this.toPage();
                break;
            }
            case "refresh": {
                this.getView().updateView();
                break;
            }
        }
    }

    private void toPage() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection selectCol = view.getSelectedRows();
        if (selectCol.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u518d\u64cd\u4f5c\u3002", (String)"PbdAddressList_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectCol.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\u3002", (String)"PbdAddressList_4", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection col = selectCol.getBillListSelectedRowCollection();
        Long id = Long.valueOf(col.get(0).toString());
        view.showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)ENTITY, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)id, null, null));
    }

    public QFilter getBdAddrFilter() {
        if (EcPlatformEnum.ECPLATFORM_JD.getVal().equals(this.getModel().getValue(EMAL_TYPE))) {
            return new QFilter("enable", "=", (Object)"1");
        }
        QFilter levelFilter = new QFilter("level", "in", (Object)new ArrayList<Integer>(){
            {
                this.add(1);
                this.add(2);
                this.add(3);
            }
        });
        QFilter filter = new QFilter("issystem", "=", (Object)"1");
        return new QFilter("enable", "=", (Object)"1").and(levelFilter).and(filter);
    }

    public void init() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter filter1 = new QFilter("country", "=", (Object)COUNTRY_NUMBER);
        DynamicObjectCollection admindivisionCollection = QueryServiceHelper.query((String)"bd_admindivision", (String)"id", (QFilter[])new QFilter[]{filter1, enableFilter, this.getBdAddrFilter()});
        QFilter filter2 = new QFilter(EMAL_TYPE, "=", this.getModel().getValue(EMAL_TYPE));
        DynamicObjectCollection addressRelCollection = QueryServiceHelper.query((String)ENTITY, (String)"addressid, emaltype", (QFilter[])new QFilter[]{filter2, enableFilter});
        DynamicObject[] arr = new DynamicObject[admindivisionCollection.size()];
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        int index = 0;
        for (DynamicObject dyo : admindivisionCollection) {
            Boolean isExist = false;
            String adminId = dyo.getString("id");
            for (DynamicObject addressRelDyo : addressRelCollection) {
                if (!adminId.equals(addressRelDyo.getString(ADDRESS))) continue;
                isExist = true;
            }
            if (isExist.booleanValue()) continue;
            DynamicObject newDyo = BusinessDataServiceHelper.newDynamicObject((String)ENTITY);
            newDyo.set(ADDRESS, (Object)adminId);
            newDyo.set(EMAL_TYPE, this.getModel().getValue(EMAL_TYPE));
            newDyo.set("enable", (Object)"1");
            newDyo.set(MATCH_STATUS, (Object)"1");
            newDyo.set("status", (Object)"A");
            arr[index++] = newDyo;
            list.add(newDyo);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
        this.getView().invokeOperation("refresh");
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResultValue().equals("Yes")) {
            super.confirmCallBack(event);
            this.remove();
        }
    }

    public void handleAutoMatch() {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put(EMAL_TYPE, this.getModel().getValue(EMAL_TYPE));
        params.put("currentNodeId", this.getTreeModel().getCurrentNodeId());
        OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)AUTO_MATCH_DIALOG, (ShowType)ShowType.Modal, params, (CloseCallBack)new CloseCallBack((IFormPlugin)this, AFTER_AUTO_MATCH));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals(AFTER_AUTO_MATCH) && closedCallBackEvent.getReturnData() != null) {
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)AUTO_MATCH_STATUS_DIALOG, (ShowType)ShowType.Modal, (Map)((Map)closedCallBackEvent.getReturnData()), (CloseCallBack)new CloseCallBack((IFormPlugin)this, AFTER_SHOW_AUTO_MATCH));
            IListView listview = (IListView)this.getView();
            listview.refresh();
        }
        if (closedCallBackEvent.getActionId().equals(AFTER_SHOW_AUTO_MATCH) && closedCallBackEvent.getReturnData() != null) {
            this.getModel().setValue(MATCH_STATUS, (Object)FAIL_MATCH);
            this.focusRoot();
            this.getView().updateView();
        }
    }

    public void focusRoot() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        TreeNode RootNode = this.getTreeModel().createRootNode();
        treeView.focusNode(RootNode);
    }

    public void handleRemove() {
        if (this.getSelectedRowsSize() != 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)ResManager.loadKDString((String)"\u89e3\u9664\u5f53\u524d\u7535\u5546\u5730\u5740\u4e0e\u7cfb\u7edf\u9884\u8bbe\u7684\u884c\u653f\u533a\u5212\u7684\u5bf9\u5e94\u5173\u7cfb\u540e\uff0c\u6570\u636e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"PbdAddressList_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdAddressList_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirm"));
        }
    }

    public int remove() {
        IListView listview = (IListView)this.getView();
        String emalType = (String)this.getModel().getValue(EMAL_TYPE);
        ArrayList<Long> idList = new ArrayList<Long>();
        for (ListSelectedRow lsc : listview.getSelectedRows()) {
            idList.add((Long)lsc.getPrimaryKeyValue());
        }
        QFilter emalTypeFilter = new QFilter(EMAL_TYPE, "=", (Object)emalType);
        QFilter numberFilter = new QFilter("id", "in", idList);
        DynamicObject[] queryRes = BusinessDataServiceHelper.load((String)ENTITY, (String)"matchstatus,emaladdress,longnumber", (QFilter[])new QFilter[]{emalTypeFilter, numberFilter});
        for (int i = 0; i < queryRes.length; ++i) {
            queryRes[i].set(MATCH_STATUS, (Object)NOT_MATCH);
            queryRes[i].set(EMAL_ADDRESS, null);
        }
        SaveServiceHelper.save((DynamicObject[])queryRes);
        listview.refresh();
        return idList.size();
    }

    public int getSelectedRowsSize() {
        return ((IListView)this.getView()).getSelectedRows().size();
    }
}

