/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.jd.errorcode.JDAPIErrorCode;
import kd.scm.common.jd.util.JDAccessTokenUtil;
import kd.scm.common.jd.util.JDHttpsUtil;
import kd.scm.common.parent.TreeListBuildTreePlugin;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PbdJDClassList
extends TreeListBuildTreePlugin {
    private static Log log = LogFactory.getLog(PbdJDClassList.class);
    private static final String KEY_TREEBUTTONPANEL = "flexpanel_treebtn";
    private static final String KEY_TREEVIEW = "treeview";
    private static final String SOURCE = "source";
    private static final String SELECTCATE = "selectcate";
    private static final String RESULTCALLBACKID = "confirmActionId";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_PMLJD");
        if (!checkResult.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(checkResult.getMsg());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LicenseCheckResult checkResult = LicenseServiceHelper.checkPerformGroup((String)"PRO_PMLJD");
        if (!checkResult.getHasLicense().booleanValue()) {
            this.getView().showMessage(checkResult.getMsg());
            return;
        }
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_TREEBUTTONPANEL});
    }

    public void setFilter(SetFilterEvent e) {
        QFilter qfilter = new QFilter(SOURCE, "=", (Object)"2");
        List qFilters = e.getQFilters();
        qFilters.add(qfilter);
        super.setFilter(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String clickKey;
        super.beforeItemClick(evt);
        switch (clickKey = evt.getItemKey()) {
            case "tblshow": {
                ListSelectedRowCollection selectCol = this.selectCheck();
                if (null != selectCol && selectCol.size() >= 1) break;
                evt.setCancel(true);
                return;
            }
            case "tblunshow": {
                ListSelectedRowCollection selectCol = this.selectCheck();
                if (null != selectCol && selectCol.size() >= 1) break;
                evt.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        IFormView view = this.getView();
        String clickKey = evt.getItemKey();
        int byte0 = -1;
        switch (clickKey) {
            case "tblrefeshcat": {
                byte0 = 0;
                break;
            }
            case "tblmapcate": {
                byte0 = 1;
                break;
            }
            case "tblshow": {
                this.setMainShow(true);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u9996\u9875\u5c55\u793a\u6210\u529f\u3002", (String)"PbdJDClassList_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
                break;
            }
            case "tblunshow": {
                this.setMainShow(false);
                view.showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u9996\u9875\u5c55\u793a\u6210\u529f\u3002", (String)"PbdJDClassList_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
            }
        }
        switch (byte0) {
            case 0: {
                try {
                    this.updateCategorys();
                    this.getView().updateView();
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    view.showMessage(e.getMessage());
                }
                break;
            }
            case 1: {
                this.openDealPage();
            }
        }
    }

    private void setMainShow(boolean isShow) {
        DynamicObject[] categories;
        ListSelectedRowCollection selectCol = this.selectCheck();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ListSelectedRow row : selectCol) {
            Long id = (Long)row.getPrimaryKeyValue();
            ids.add(id);
        }
        QFilter idfilter = new QFilter("id", "in", ids);
        for (DynamicObject category : categories = BusinessDataServiceHelper.load((String)"pbd_goodsclass", (String)"id,isonhomepage", (QFilter[])new QFilter[]{idfilter})) {
            if (isShow) {
                category.set("isonhomepage", (Object)1);
                continue;
            }
            category.set("isonhomepage", (Object)0);
        }
        SaveServiceHelper.save((DynamicObject[])categories);
        this.getView().invokeOperation("refresh");
    }

    private void openDealPage() {
        IFormView view = this.getView();
        HashMap paramMap = new HashMap();
        BillList list = (BillList)view.getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects == null) {
            return;
        }
        ArrayList<Long> selectid = new ArrayList<Long>();
        for (int i = 0; i < objects.length; ++i) {
            selectid.add(Long.valueOf(objects[i].toString()));
        }
        paramMap.put(SELECTCATE, selectid);
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pmm_categorymapping", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, RESULTCALLBACKID), (ShowType)ShowType.Modal));
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        List filter = this.getTreeModel().getTreeFilter();
        filter.clear();
        QFilter sourceFilter = new QFilter(SOURCE, "=", (Object)"2");
        QFilter levelFilter = new QFilter("level", "!=", (Object)Long.valueOf("3"));
        filter.add(levelFilter);
        filter.add(sourceFilter);
    }

    private void updateCategorys() {
        DynamicObjectCollection isHomedetailCols;
        QFilter isHomeFilter;
        DynamicObjectCollection enabledetailCols;
        IFormView view = this.getView();
        ORM orm = ORM.create();
        List enableNumberList = new ArrayList();
        List isHomeNumberList = new ArrayList();
        DataSet enableDataSet = null;
        DataSet isHomeDataSet = null;
        DataSet detailDataSet = null;
        QFilter enableFilter = new QFilter("enable", "=", (Object)"0");
        enableDataSet = PbdJDClassList.getOrderDataSet(enableFilter);
        if (enableDataSet != null) {
            detailDataSet = enableDataSet.copy();
        }
        if ((enabledetailCols = orm.toPlainDynamicObjectCollection(detailDataSet)).size() > 0) {
            enableNumberList = DynamicObjectUtil.getProVal2List((DynamicObject[])((DynamicObject[])enabledetailCols.toArray((Object[])new DynamicObject[0])), (String)"number");
        }
        if ((isHomeDataSet = PbdJDClassList.getOrderDataSet(isHomeFilter = new QFilter("isonhomepage", "=", (Object)"1"))) != null) {
            detailDataSet = isHomeDataSet.copy();
        }
        if ((isHomedetailCols = orm.toPlainDynamicObjectCollection(detailDataSet)).size() > 0) {
            isHomeNumberList = DynamicObjectUtil.getProVal2List((DynamicObject[])((DynamicObject[])isHomedetailCols.toArray((Object[])new DynamicObject[0])), (String)"number");
        }
        QFilter sourceFilter = new QFilter(SOURCE, "=", (Object)"2");
        DeleteServiceHelper.delete((String)"pbd_goodsclass", (QFilter[])new QFilter[]{sourceFilter});
        ArrayList<String> catelist = new ArrayList<String>();
        HashMap<String, DynamicObject> catemap = new HashMap<String, DynamicObject>();
        for (int cat = 0; cat < 3; ++cat) {
            JSONArray categorys = this.getCategoryBynumber(cat);
            log.info("$$$$" + categorys);
            boolean isleaf = false;
            if (null == categorys) continue;
            for (int i = 0; i < categorys.size(); ++i) {
                DynamicObject category = new DynamicObject();
                JSONObject catJS = categorys.getJSONObject(i);
                category = ORMUtil.newDynamicObject((String)"pbd_goodsclass");
                Object number = catJS.get("catId");
                if (catJS.getInt("state") == 0) continue;
                category.set("id", number);
                category.set("masterid", number);
                category.set("number", number);
                category.set("name", catJS.get("name"));
                category.set("parent", catJS.get("parentId"));
                category.set("level", (Object)((Integer)catJS.get("catClass") + 1));
                category.set(SOURCE, (Object)"2");
                if (cat == 2) {
                    isleaf = true;
                }
                category.set("isleaf", (Object)isleaf);
                category.set("status", (Object)"C");
                if (enableNumberList.contains(String.valueOf(number))) {
                    category.set("enable", (Object)"0");
                } else {
                    category.set("enable", (Object)"1");
                }
                if (isHomeNumberList.contains(String.valueOf(number))) {
                    category.set("isonhomepage", (Object)"1");
                } else {
                    category.set("isonhomepage", (Object)"0");
                }
                String longnmber = this.jointLongnumber(catemap, catJS.get("parentId"), number.toString());
                category.set("longnumber", (Object)longnmber);
                catelist.add(category.getString("id"));
                catemap.put(category.getString("id"), category);
            }
        }
        Object[] categories = this.removeCategory(catelist, catemap);
        log.info("$$$$" + Arrays.toString(categories));
        view.showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u6210\u529f", (String)"PbdJDClassList_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        SaveServiceHelper.save((IDataEntityType)categories[0].getDataEntityType(), (Object[])categories);
        log.info("$$$$\u4fdd\u5b58\u6210\u529f");
    }

    private String jointLongnumber(Map<String, DynamicObject> catemap, Object parentid, String number) {
        if (null == parentid) {
            return null;
        }
        String longnumber = "";
        if (parentid.equals(0)) {
            longnumber = number;
        } else {
            DynamicObject parent = catemap.get(parentid.toString());
            if (null == parent) {
                longnumber = number;
            } else {
                String parLongNum = parent.getString("longnumber");
                longnumber = parLongNum + "." + number;
            }
        }
        return longnumber;
    }

    private DynamicObject[] removeCategory(ArrayList<String> list, Map<String, DynamicObject> map) {
        for (int i = 0; i < list.size(); ++i) {
            String id = list.get(i);
            DynamicObject cate = map.get(id);
            if (cate.getInt("parent") == 0 || null != map.get(cate.get("parent").toString())) continue;
            map.remove(id);
        }
        DynamicObject[] categories = new DynamicObject[map.size()];
        int m = 0;
        Iterator<DynamicObject> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            DynamicObject category;
            categories[m] = category = iterator.next();
            ++m;
        }
        return categories;
    }

    public JSONArray getCategoryBynumber(Integer catClass) {
        IFormView view = this.getView();
        Integer pagNo = 1;
        String tenantId = RequestContext.getOrCreate().getTenantId();
        String json = "";
        try {
            log.info("$$$$" + tenantId);
            String token = JDAccessTokenUtil.getAccessTokenByKD((String)tenantId);
            String data = "token=" + token + "&pageNo=" + pagNo + "&pageSize=5000&catClass=" + catClass;
            log.info("$$$$" + data);
            json = JDHttpsUtil.httpsJDPost((String)" https://bizapi.jd.com/api/product/getCategorys", (String)data);
            JSONObject node = JSONObject.fromObject((Object)json);
            log.info("$$$$" + node);
            if (node.getBoolean("success")) {
                log.info("$$$$ success");
                JSONArray categorys = node.getJSONObject("result").getJSONArray("categorys");
                return categorys;
            }
            log.info("$$$$ error");
            String msg = node.getString("resultMessage");
            view.showMessage(msg);
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new KDException(JDAPIErrorCode.INVOKE_JD_FAILED, new Object[]{e.getMessage()});
        }
    }

    private ListSelectedRowCollection selectCheck() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        if (selectCol.size() < 1) {
            listview.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5206\u7c7b\u3002", (String)"PbdJDClassList_3", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        }
        return selectCol;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
    }

    public static DataSet getOrderDataSet(QFilter filter) {
        DataSet dataSet = null;
        try {
            filter.and(new QFilter(SOURCE, "=", (Object)"2"));
            StringBuilder selectFields = new StringBuilder();
            selectFields.append("id,number,enable,isonhomepage");
            String orderBys = "number";
            dataSet = QueryServiceHelper.queryDataSet((String)ORMUtil.class.getSimpleName(), (String)"pbd_jdclass", (String)selectFields.toString(), (QFilter[])new QFilter[]{filter}, (String)orderBys);
        }
        catch (Exception e) {
            log.error("getDateSet exception:" + e.getMessage());
        }
        return dataSet;
    }
}

