/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.multijoint;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;

public final class PbdEntityLinkConfigPlugin
extends AbstractBillPlugIn {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.initLinkProperty(dataEntity.getString("entity.number"));
        this.initValueProperty(dataEntity.getString("executescene.entity.number"));
        this.initValeOptions(dataEntity.getString("executescene.entity.number"), dataEntity.getString("valueproperty"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"entity") && (newValue = e.getChangeSet()[0].getNewValue()) != null) {
            this.initLinkProperty(((DynamicObject)newValue).getString("number"));
        }
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"executescene") && (newValue = e.getChangeSet()[0].getNewValue()) != null) {
            this.initValueProperty(((DynamicObject)newValue).getString("entity.number"));
        }
        if (StringUtils.equals((CharSequence)propertyName, (CharSequence)"valueproperty") && (newValue = e.getChangeSet()[0].getNewValue()) != null) {
            this.initValeOptions(this.getModel().getDataEntity().getString("executescene.entity.number"), newValue.toString());
        }
    }

    private void initLinkProperty(String executeEntityNumber) {
        ComboEdit refproperty = (ComboEdit)this.getControl("linkproperty");
        if (executeEntityNumber != null && !executeEntityNumber.trim().isEmpty()) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)executeEntityNumber);
            Map typeAllFields = mainEntityType.getAllFields();
            refproperty.setComboItems(this.assembleProperty(typeAllFields, "id"));
        }
    }

    private List<ComboItem> assembleProperty(Map<String, IDataEntityProperty> typeAllFields, String suffix) {
        ComboItem property = null;
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(typeAllFields.size());
        for (Map.Entry<String, IDataEntityProperty> entry : typeAllFields.entrySet()) {
            String key = entry.getKey();
            if (!key.endsWith(suffix)) continue;
            IDataEntityProperty value = entry.getValue();
            if (value.getParent() instanceof EntryType) {
                key = value.getParent().getName() + "." + key;
            }
            property = new ComboItem(new LocaleString(value.getDisplayName() + "(" + key + ")"), key);
            comboItems.add(property);
        }
        return comboItems;
    }

    private void initValueProperty(String sceneEntityNumber) {
        ComboEdit valueproperty = (ComboEdit)this.getControl("valueproperty");
        if (sceneEntityNumber != null && !sceneEntityNumber.trim().isEmpty()) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sceneEntityNumber);
            HashMap<String, IDataEntityProperty> typeAllFields = new HashMap<String, IDataEntityProperty>(1024);
            for (Map.Entry entry : mainEntityType.getAllFields().entrySet()) {
                if (!(entry.getValue() instanceof ComboProp)) continue;
                typeAllFields.put((String)entry.getKey(), (IDataEntityProperty)entry.getValue());
            }
            valueproperty.setComboItems(this.assembleProperty(typeAllFields, ""));
        }
    }

    private void initValeOptions(String sceneEntityNumber, String handleFiled) {
        MainEntityType mainEntityType;
        DynamicProperty handlepropertyType;
        ComboEdit valueoption = (ComboEdit)this.getControl("valueoption");
        if (sceneEntityNumber != null && !sceneEntityNumber.trim().isEmpty() && handleFiled != null && !handleFiled.trim().isEmpty() && (handlepropertyType = (mainEntityType = EntityMetadataCache.getDataEntityType((String)sceneEntityNumber)).getProperty(handleFiled)) instanceof ComboProp) {
            valueoption.setComboItems(this.assembleHandleValues((ComboProp)handlepropertyType));
        }
    }

    private List<ComboItem> assembleHandleValues(ComboProp comboProp) {
        List comboItems;
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        ComboItem property = null;
        if (comboProp != null && (comboItems = comboProp.getComboItems()) != null) {
            for (ValueMapItem valueMapItem : comboItems) {
                property = new ComboItem(new LocaleString(valueMapItem.getName() + "(" + valueMapItem.getValue() + ")"), valueMapItem.getValue());
                comboItemList.add(property);
            }
        }
        return comboItemList;
    }
}

