/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.multijoint;

import java.util.EventObject;
import java.util.Locale;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.scm.common.store.SRMStoreExceptionTraceHelper;

public final class PbdMServiceConfigPlugin
extends AbstractBillPlugIn {
    private String[] lockFileds = new String[]{"bizcloud", "bizapp", "name", "number"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!ISVServiceHelper.isKingdeeISV()) {
            this.getView().setEnable(Boolean.valueOf(false), this.lockFileds);
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
        } else {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject bizcloud = dataEntity.getDynamicObject("bizcloud");
            String cloudId = bizcloud.getString("number").toLowerCase(Locale.ROOT);
            if ("eip".equalsIgnoreCase(cloudId)) {
                cloudId = "isc";
            } else if ("pur".equalsIgnoreCase(cloudId)) {
                cloudId = "scm";
            }
            DynamicObject bizapp = dataEntity.getDynamicObject("bizapp");
            String bizAppId = bizapp.getString("number").toLowerCase(Locale.ROOT);
            String serviceName = dataEntity.getString("name");
            String methodName = dataEntity.getString("number");
            try {
                DispatchServiceHelper.invokeBizService((String)cloudId, (String)bizAppId, (String)serviceName, (String)methodName, (Object[])new Object[0]);
            }
            catch (Exception exception) {
                this.showMessage(String.valueOf(exception.getMessage()));
            }
            catch (Throwable throwable) {
                SRMStoreExceptionTraceHelper.saveExceptionData((Throwable)throwable);
                this.showMessage(String.valueOf(throwable.getMessage()));
                args.setCancel(true);
            }
        }
    }

    private void showMessage(String message) {
        this.getView().showTipNotification(message, Integer.valueOf(Integer.parseInt("12000")));
    }
}

