/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.multijoint;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeQuickAddNewEvent;
import kd.bos.form.field.events.BeforeQuickAddNewListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;

public final class PbdMutilStrategyConfigPlugin
extends AbstractBillPlugIn
implements BeforeQuickAddNewListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit entity = (BasedataEdit)this.getControl("entity");
        if (entity != null) {
            entity.addBeforeQuickAddNewListener((BeforeQuickAddNewListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.updateFilterGridValue();
        FilterGrid filterGrid = (FilterGrid)this.getControl("commonfilter");
        String commonFilterJson = this.getModel().getDataEntity().getString("filterjson_tag");
        FilterCondition condition = StringUtils.isBlank((CharSequence)commonFilterJson) ? new FilterCondition() : (FilterCondition)SerializationUtils.fromJsonString((String)commonFilterJson, FilterCondition.class);
        filterGrid.SetValue(condition);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("entity".equalsIgnoreCase(name)) {
            this.entityChange(e.getChangeSet()[0].getOldValue(), e.getChangeSet()[0].getOldValue());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equalsIgnoreCase(operateKey)) {
            this.modifyFilterData();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        String customVaule = messageBoxClosedEvent.getCustomVaule();
        if ("entitychangeconfirm".equalsIgnoreCase(callBackId) && customVaule != null && !customVaule.isEmpty()) {
            Map confirmMap = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
            if (MessageBoxResult.Yes.equals((Object)messageBoxResult)) {
                this.getModel().setValue("filterformula_tag", null);
                this.getModel().setValue("filterjson_tag", null);
                this.updateFilterGridValue();
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("entity", confirmMap.get("entityid"));
                this.getView().updateView("entity");
                this.getModel().endInit();
            }
        }
    }

    private void entityChange(Object oldValue, Object newValue) {
        if (oldValue != null) {
            DynamicObject oldEntity = (DynamicObject)oldValue;
            String message = ResManager.loadKDString((String)"\u5207\u6362\u6570\u636e\u5904\u7406\u5bf9\u8c61\uff0c\u5c06\u6e05\u7406\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u4fe1\u606f\u548c\u5206\u4eab\u5bf9\u8c61\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"PbdMutilStrategyConfigPlugin_0", (String)"scm-pbd-formplugin", (Object[])new Object[0]);
            HashMap<String, String> confirmMap = new HashMap<String, String>(1);
            confirmMap.put("entityid", oldEntity.getString("id"));
            this.getView().showConfirm(message, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("entitychangeconfirm", (IFormPlugin)this), null, SerializationUtils.toJsonString(confirmMap));
        } else {
            this.updateFilterGridValue();
        }
    }

    private void updateFilterGridValue() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("commonfilter");
        DynamicObject entity = this.getModel().getDataEntity().getDynamicObject("entity");
        if (entity == null) {
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFilterColumns(new ArrayList());
            filterGrid.setEntityNumber((String)null);
        } else {
            String billNo;
            String entityNumber = entity.getString("number");
            EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            List filterColumns = entityTypeUtil.getFilterColumns((IDataEntityType)entityType, true);
            ArrayList<Map> availablefilterColumns = new ArrayList<Map>(56);
            DataEntityPropertyCollection entityTypeProperties = entityType.getProperties();
            HashSet<String> availablePro = new HashSet<String>(50);
            for (IDataEntityProperty dataEntityProperty : entityTypeProperties) {
                String entityId;
                if (dataEntityProperty instanceof MainOrgProp || dataEntityProperty instanceof CreaterProp) {
                    availablePro.add(dataEntityProperty.getName());
                    continue;
                }
                if (!(dataEntityProperty instanceof BasedataProp) || !"bd_supplier".equals(entityId = ((BasedataProp)dataEntityProperty).getBaseEntityId())) continue;
                availablePro.add(dataEntityProperty.getName());
            }
            if (entityType instanceof BillEntityType && (billNo = ((BillEntityType)entityType).getBillNo()) != null && !billNo.trim().isEmpty()) {
                availablePro.add(billNo);
            }
            for (Map objectMap : filterColumns) {
                boolean isFilterProKey = objectMap.values().stream().anyMatch(availablePro::contains);
                if (!isFilterProKey) continue;
                availablefilterColumns.add(objectMap);
            }
            filterGrid.SetValue(new FilterCondition());
            filterGrid.setFieldColumns(availablefilterColumns);
            filterGrid.setEntityNumber(entityType.getName());
            filterGrid.setFilterColumns(availablefilterColumns);
            filterGrid.setFilterFields(new ArrayList(availablePro));
        }
        this.getView().updateView("commonfilter");
    }

    private void modifyFilterData() {
        IDataModel model = this.getModel();
        FilterGrid grid = (FilterGrid)this.getControl("commonfilter");
        FilterCondition condition = grid.getFilterGridState().getFilterCondition();
        String jsonStr = SerializationUtils.toJsonString((Object)condition);
        DynamicObject monitorObj = this.getModel().getDataEntity().getDynamicObject("entity");
        if (monitorObj != null) {
            String monitorObjNum = monitorObj.getString("number");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)monitorObjNum);
            FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
            filterBuilder.buildFilter(false);
            String[] scripts = filterBuilder.buildFilterScript();
            model.setValue("filterjson_tag", (Object)jsonStr);
            model.setValue("filterformula_tag", (Object)scripts[0]);
        }
    }

    public void beforeQuickAddNew(BeforeQuickAddNewEvent beforeQuickAddNewEvent) {
        DynamicObject entity;
        Control control = (Control)beforeQuickAddNewEvent.getSource();
        String controlKey = control.getKey();
        if ("entity".equalsIgnoreCase(controlKey) && (entity = this.getModel().getDataEntity().getDynamicObject("entity")) != null) {
            beforeQuickAddNewEvent.getShowParameter().setCustomParam("quickAddNew", (Object)Boolean.TRUE);
            beforeQuickAddNewEvent.getShowParameter().setCustomParam("monitorobj", entity.getPkValue());
        }
    }
}

