/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.util;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pbd.common.enums.DigitalCreditOpenStatusEnum;
import kd.scm.pbd.common.utils.PbdCreditUtils;

public class PbdDigitalCreditLinkUtils {
    private static Log log = LogFactory.getLog(PbdDigitalCreditLinkUtils.class);
    private static final String ORGENTITY = "orgentity";
    private static final String COMPANYORG = "companyorg";
    private static final String WHOLEGROUP = "wholegroup";
    private static final String ENABLE = "enable";
    public static final String OPENSTATUS = "openstatus";

    public static void showNeedsToknow(IFormView view, DynamicObject dataEntity, CloseCallBack callback) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("pbd_needs_to_know");
        formShowParameter.setCloseCallBack(callback);
        view.showForm(formShowParameter);
    }

    public static void open(IFormView view, DynamicObject dataEntity) {
        dataEntity.set(OPENSTATUS, (Object)DigitalCreditOpenStatusEnum.OPENSTATUS_2.getVal());
        dataEntity.set(ENABLE, (Object)"1");
        DynamicObject platform = dataEntity.getDynamicObject("platform");
        String name = platform.getString("name");
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dataEntity});
        view.showSuccessNotification(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u4e0e%1\u8fde\u63a5\u6210\u529f\u3002", (String)"PbdDigitalCreditLinkUtils_2", (String)"scm-pbd-formplugin", (Object[])new Object[0]), (String)"PbdDigitalCreditLinkUtils_0", (String)"scm-pbd-formplugin", (Object[])new Object[]{name}));
        view.updateView();
    }

    public static void stop(IFormView view, DynamicObject dataEntity) {
        dataEntity.set(OPENSTATUS, (Object)DigitalCreditOpenStatusEnum.OPENSTATUS_3.getVal());
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dataEntity});
        view.showSuccessNotification(ResManager.loadKDString((String)"\u505c\u7528\u6210\u529f\u3002", (String)"PbdDigitalCreditLinkUtils_1", (String)"scm-pbd-formplugin", (Object[])new Object[0]));
        view.updateView();
    }

    public static boolean validOrg(DynamicObject dataEntity, DynamicObjectCollection entryEntity, Integer entryCurrentRowIndex) {
        DynamicObject dy;
        HashMap<Long, Boolean> entryOrgIdIncludeSubOrgMap = new HashMap<Long, Boolean>(8);
        DynamicObject platform = dataEntity.getDynamicObject("platform");
        Long platformId = (Long)platform.getPkValue();
        DynamicObject curOrg = null;
        if (entryCurrentRowIndex != null && (curOrg = (dy = (DynamicObject)entryEntity.get(entryCurrentRowIndex.intValue())).getDynamicObject(COMPANYORG)) == null) {
            return true;
        }
        Set entrySubordinateOrgs = new HashSet(8);
        if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
            int startRowIndex = entryEntity.getStartRowIndex();
            for (DynamicObject dy2 : entryEntity) {
                DynamicObject companyorg = dy2.getDynamicObject(COMPANYORG);
                if (entryCurrentRowIndex != null && curOrg != null && curOrg.equals(companyorg) && startRowIndex == entryCurrentRowIndex) {
                    ++startRowIndex;
                    continue;
                }
                Boolean includesuborg = dy2.getBoolean("includesuborg");
                if (companyorg != null) {
                    entryOrgIdIncludeSubOrgMap.put((Long)companyorg.getPkValue(), includesuborg);
                }
                ++startRowIndex;
            }
            entrySubordinateOrgs = PbdCreditUtils.getAllSubordinateOrgs(entryOrgIdIncludeSubOrgMap, (Boolean)Boolean.FALSE);
        }
        log.info("\u5f53\u524d\u7ec4\u7ec7\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(entryOrgIdIncludeSubOrgMap));
        Long pkValue = (Long)dataEntity.getPkValue();
        HashSet allSubordinateOrgs = new HashSet(8);
        QFilter qf = new QFilter(OPENSTATUS, "=", (Object)"2");
        qf.and("id", "!=", (Object)pkValue);
        qf.and("platform", "=", (Object)platformId);
        DynamicObjectCollection links = QueryServiceHelper.query((String)"pbd_credit_link", (String)"id,platform,wholegroup,orgentity.companyorg,orgentity.includesuborg", (QFilter[])new QFilter[]{qf});
        if (!CollectionUtils.isEmpty((Collection)links)) {
            HashMap<Long, Boolean> orgIdIncludeSubOrgMap = new HashMap<Long, Boolean>(8);
            for (DynamicObject dy3 : links) {
                Boolean wholegroup = dy3.getBoolean(WHOLEGROUP);
                if (wholegroup.booleanValue()) {
                    return false;
                }
                Long companyorg = dy3.getLong("orgentity.companyorg");
                Boolean includesuborg = dy3.getBoolean("orgentity.includesuborg");
                orgIdIncludeSubOrgMap.put(companyorg, includesuborg);
            }
            Set allOrgs = PbdCreditUtils.getAllSubordinateOrgs(orgIdIncludeSubOrgMap, (Boolean)Boolean.FALSE);
            if (!CollectionUtils.isEmpty((Collection)allOrgs)) {
                allSubordinateOrgs.addAll(allOrgs);
            }
        }
        Set curSubordinateOrgs = new HashSet(8);
        if (entryCurrentRowIndex != null) {
            Long curOrgId = 0L;
            if (curOrg != null) {
                curOrgId = (Long)curOrg.getPkValue();
            }
            HashMap<Long, Boolean> curOrgIdIncludeSubOrgMap = new HashMap<Long, Boolean>(8);
            Boolean curIncludesuborg = ((DynamicObject)entryEntity.get(entryCurrentRowIndex.intValue())).getBoolean("includesuborg");
            curOrgIdIncludeSubOrgMap.put(curOrgId, curIncludesuborg);
            curSubordinateOrgs = PbdCreditUtils.getAllSubordinateOrgs(curOrgIdIncludeSubOrgMap, (Boolean)Boolean.FALSE);
            allSubordinateOrgs.addAll(entrySubordinateOrgs);
        } else {
            curSubordinateOrgs = entrySubordinateOrgs;
        }
        if (CollectionUtils.isEmpty(allSubordinateOrgs)) {
            return true;
        }
        Boolean curwholegroup = dataEntity.getBoolean(WHOLEGROUP);
        if (curwholegroup.booleanValue()) {
            return false;
        }
        if (!CollectionUtils.isEmpty(curSubordinateOrgs)) {
            boolean flag = Collections.disjoint(curSubordinateOrgs, allSubordinateOrgs);
            return flag;
        }
        return true;
    }
}

