/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.formplugin.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PurBaseServiceHelper {
    private String entityName;

    public PurBaseServiceHelper(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public DynamicObject generateEmptyEntryDynamicObject(String entryEntity) {
        return this.generateEmptyEntryDynamicObject(this.getEntityName(), entryEntity);
    }

    public DynamicObject generateEmptyEntryDynamicObject(String entityName, String entryEntity) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityName);
        EntityType type = (EntityType)mainType.getAllEntities().get(entryEntity);
        return (DynamicObject)type.createInstance();
    }

    public DynamicObjectCollection generateEmptyEntryCollection(DynamicObject dy, String entryEntity) {
        MainEntityType mainType = (MainEntityType)dy.getDataEntityType();
        EntityType type = (EntityType)mainType.getAllEntities().get(entryEntity);
        DynamicObjectCollection dyColl = new DynamicObjectCollection((DynamicObjectType)type, (Object)dy);
        dy.set(entryEntity, (Object)dyColl);
        return dyColl;
    }

    public DynamicObject generateEmptyDynamicObject() {
        return this.generateEmptyDynamicObject(this.getEntityName());
    }

    public DynamicObject generateEmptyDynamicObject(String entityName) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return (DynamicObject)type.createInstance();
    }

    public DynamicObject generateDynamicObject(Object pk, String selectProperties) {
        return this.generateDynamicObject(this.getEntityName(), pk, selectProperties);
    }

    public DynamicObject generateDynamicObject(DynamicObject dobj, String selectProperties) {
        return this.generateDynamicObject(this.getEntityName(), dobj, selectProperties);
    }

    public DynamicObject generateDynamicObject(String entityName, DynamicObject dobj, String selectProperties) {
        return this.generateDynamicObject(entityName, dobj.getPkValue(), selectProperties);
    }

    public DynamicObject generateDynamicObject(String entityName, Object pk, String selectProperties) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName, (String)selectProperties);
    }

    public void updateOne(DynamicObject dobj) {
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dobj});
    }

    public void update(DynamicObject[] dobjs) {
        SaveServiceHelper.save((DynamicObject[])dobjs);
    }

    public DynamicObject queryOne(Object pk) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)this.getEntityName());
    }

    public DynamicObject queryOne(String selectProperties, Object pk) {
        QFilter filter = new QFilter("id", "=", pk);
        return this.queryOne(selectProperties, new QFilter[]{filter});
    }

    public DynamicObject queryOne(QFilter[] filters) {
        DynamicObject[] dobjs = this.load(this.getEntityName(), filters);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject queryOne(String selectProperties, QFilter[] filters) {
        DynamicObject[] dobjs = BusinessDataServiceHelper.load((String)this.getEntityName(), (String)selectProperties, (QFilter[])filters);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject queryOriginalOne(String selectFields, QFilter[] filters) {
        return QueryServiceHelper.queryOne((String)this.getEntityName(), (String)selectFields, (QFilter[])filters);
    }

    public DynamicObject[] query(QFilter[] filters) {
        return this.load(this.getEntityName(), filters);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)this.getEntityName(), (String)selectProperties, (QFilter[])filters);
    }

    public DynamicObject[] query(QFilter[] filters, String orderBys) {
        return this.load(this.getEntityName(), filters, orderBys);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters, String orderBys) {
        return this.load(this.getEntityName(), selectProperties, filters, orderBys);
    }

    public DynamicObjectCollection queryColl(String selectFields, QFilter[] filters, String orderBys) {
        return QueryServiceHelper.query((String)this.getEntityName(), (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    public DataSet queryDataSet(String algoKey, String selectFields) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, null, null);
    }

    public DataSet queryDataSet(String algoKey, String selectFields, String orderBys) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, null, (String)orderBys);
    }

    public DataSet queryDataSet(String algoKey, String selectFields, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, (QFilter[])filters, null);
    }

    public DataSet queryDataSet(String algoKey, String selectFields, QFilter[] filters, String orderBys) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    public boolean isExist(Object pk) {
        return QueryServiceHelper.exists((String)this.getEntityName(), (Object)pk);
    }

    public boolean isExist(QFilter[] filters) {
        return QueryServiceHelper.exists((String)this.getEntityName(), (QFilter[])filters);
    }

    public void deleteOne(Object pk) {
        this.delete(this.getEntityName(), pk);
    }

    public void delete(Object[] pks) {
        this.delete(this.getEntityName(), pks);
    }

    public int deleteByFilter(QFilter[] filters) {
        return this.delete(this.getEntityName(), filters);
    }

    public Object saveOne(DynamicObject dobj) {
        Object[] pks = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dobj});
        return pks[0];
    }

    public Object[] save(DynamicObject[] dobjs) {
        return SaveServiceHelper.save((DynamicObject[])dobjs);
    }

    public int count(String entityName, QFilter[] filters) {
        ORM orm = ORM.create();
        return orm.count("QueryServiceHelper." + entityName, entityName, filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject[] load(String entityName, QFilter[] filters) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        ArrayList listIds = new ArrayList();
        try (DataSet ds = null;){
            ds = QueryServiceHelper.queryDataSet((String)"BusinessDataServiceHelper.LoadFromCache", (String)entityName, (String)"id", (QFilter[])filters, null);
            ds.forEach(row -> listIds.add(row.get(0)));
        }
        return BusinessDataReader.load((Object[])listIds.toArray(new Object[0]), (DynamicObjectType)type, (Boolean)Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject[] load(String entityName, QFilter[] filters, String orderBys) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        ArrayList<Object> listIds = new ArrayList<Object>();
        try (DataSet ds = null;){
            ds = QueryServiceHelper.queryDataSet((String)"BusinessDataServiceHelper.LoadFromCache", (String)entityName, (String)"id", (QFilter[])filters, (String)orderBys);
            ds.forEach(row -> listIds.add(row.get(0)));
        }
        DynamicObject[] dobjs = BusinessDataReader.load((Object[])listIds.toArray(new Object[0]), (DynamicObjectType)type, (Boolean)Boolean.TRUE);
        return this.resortByIds(dobjs, listIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters, String orderBys) {
        DynamicObjectType type = PurBaseServiceHelper.getSubEntityType(entityName, selectProperties);
        ArrayList<Object> listIds = new ArrayList<Object>();
        try (DataSet ds = null;){
            ds = QueryServiceHelper.queryDataSet((String)"BusinessDataServiceHelper.LoadFromCache", (String)entityName, (String)"id", (QFilter[])filters, (String)orderBys);
            ds.forEach(row -> listIds.add(row.get(0)));
        }
        DynamicObject[] dobjs = BusinessDataReader.load((Object[])listIds.toArray(new Object[0]), (DynamicObjectType)type, (Boolean)Boolean.TRUE);
        return this.resortByIds(dobjs, listIds);
    }

    private DynamicObject[] resortByIds(DynamicObject[] dobjs, List<Object> listIds) {
        HashMap<Long, DynamicObject> dobjMap = new HashMap<Long, DynamicObject>((int)((double)dobjs.length / 0.75));
        for (DynamicObject dobj : dobjs) {
            dobjMap.put((Long)dobj.getPkValue(), dobj);
        }
        DynamicObject[] newDobjs = new DynamicObject[listIds.size()];
        int idx = 0;
        for (Object obj : listIds) {
            newDobjs[idx++] = (DynamicObject)dobjMap.get((Long)obj);
        }
        return newDobjs;
    }

    private static DynamicObjectType getSubEntityType(String entityName, String selectProperties) {
        String[] properties = selectProperties.split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        for (String prop : properties) {
            select.add(prop);
        }
        DynamicObjectType type = EntityMetadataCache.getSubDataEntityType((String)entityName, select);
        return type;
    }

    private void delete(String entityName, Object pk) {
        Object[] pks = new Object[]{pk};
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])pks);
    }

    private void delete(String entityName, Object[] pks) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])pks);
    }

    private int delete(String entityName, QFilter[] filters) {
        return DeleteServiceHelper.delete((String)entityName, (QFilter[])filters);
    }
}

