/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scm.pbd.common.entity.FieldMappingModel;
import kd.scm.pbd.common.entity.PluginModel;
import kd.scm.pbd.common.entity.ProgrammeParserModel;
import kd.scm.pbd.common.utils.PbdCreditUtils;

public class PbdProgrammeParserHelper {
    public static Map<Long, ProgrammeParserModel> parse(Long orgId, String entityKey, String operator, String apipurpose) {
        String tracerKey = entityKey + operator + orgId;
        try (TraceSpan create = Tracer.create((String)"PbdProgrammeParserHelper.parse", (String)tracerKey);){
            Map<Long, ProgrammeParserModel> parseMap;
            List<DynamicObject> availableProgrammeDy = PbdProgrammeParserHelper.findAvailableProgramme(orgId, entityKey, operator);
            Map<Long, ProgrammeParserModel> map = parseMap = PbdProgrammeParserHelper.parse(orgId, availableProgrammeDy, apipurpose);
            return map;
        }
    }

    private static Map<Long, ProgrammeParserModel> parse(Long orgId, List<DynamicObject> availableProgrammeDy, String apipurpose) {
        Map<Long, ProgrammeParserModel> map = PbdProgrammeParserHelper.parseProgramme(orgId, availableProgrammeDy, apipurpose);
        if (CollectionUtils.isEmpty(map)) {
            return new HashMap<Long, ProgrammeParserModel>();
        }
        PbdProgrammeParserHelper.parseRules(map);
        return map;
    }

    private static void parseRules(Map<Long, ProgrammeParserModel> map) {
        Set<Long> apipkIds = map.keySet();
        DynamicObject[] ruleDys = BusinessDataServiceHelper.load((Object[])apipkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pbd_service_rule_config"));
        if (ruleDys != null && ruleDys.length > 0) {
            if (map.size() > ruleDys.length) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u8c03\u7528\u65b9\u6848\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e\uff0c\u8bf7\u901a\u8fc7\u5916\u90e8\u6570\u636e\u5bf9\u63a5\u914d\u7f6e\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u6a21\u5757\u914d\u7f6e\u540e\u67e5\u8be2\u3002", (String)"PbdProgrammeParserHelper_1", (String)"scm-pbd-common", (Object[])new Object[0]));
            }
            for (DynamicObject dy : ruleDys) {
                Long pkValue = (Long)dy.getPkValue();
                ProgrammeParserModel model = map.get(pkValue);
                DynamicObjectCollection inputsfieldmap = dy.getDynamicObjectCollection("inputsfieldmap");
                PbdProgrammeParserHelper.parseInputsFieldMap(inputsfieldmap, model, "input");
                DynamicObjectCollection outputsfieldmap = dy.getDynamicObjectCollection("outputsfieldmap");
                PbdProgrammeParserHelper.parseInputsFieldMap(outputsfieldmap, model, "output");
                DynamicObjectCollection inputscheckdata = dy.getDynamicObjectCollection("inputscheckdata");
                PbdProgrammeParserHelper.parseInputsCheckData(inputscheckdata, model, "input");
                DynamicObjectCollection outputscheckdata = dy.getDynamicObjectCollection("outputscheckdata");
                PbdProgrammeParserHelper.parseInputsCheckData(outputscheckdata, model, "output");
                DynamicObjectCollection pluginpolicyfield = dy.getDynamicObjectCollection("pluginpolicyfield");
                PbdProgrammeParserHelper.parsePluginPolicyField(pluginpolicyfield, model);
                DynamicObjectCollection pluginpolicyrule = dy.getDynamicObjectCollection("pluginpolicyrule");
                PbdProgrammeParserHelper.parsePluginPolicyRule(pluginpolicyrule, model);
                map.put(pkValue, model);
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u4e1a\u52a1\u8c03\u7528\u65b9\u6848\u4e1a\u52a1\u89c4\u5219\u914d\u7f6e\uff0c\u8bf7\u901a\u8fc7\u5916\u90e8\u6570\u636e\u5bf9\u63a5\u914d\u7f6e\u4e1a\u52a1\u65b9\u6848\u914d\u7f6e\u6a21\u5757\u914d\u7f6e\u540e\u67e5\u8be2\u3002", (String)"PbdProgrammeParserHelper_1", (String)"scm-pbd-common", (Object[])new Object[0]));
        }
    }

    private static Map<Long, ProgrammeParserModel> parseProgramme(Long orgId, List<DynamicObject> availableProgrammeDy, String apipurpose) {
        HashMap<Object, DynamicObject> linkLoads = new HashMap<Object, DynamicObject>(8);
        HashMap<Object, DynamicObject> standardapiLoads = new HashMap<Object, DynamicObject>(8);
        HashMap<Object, String> linkOpenStatusMap = new HashMap<Object, String>(8);
        PbdProgrammeParserHelper.loadData(orgId, availableProgrammeDy, linkLoads, standardapiLoads, linkOpenStatusMap);
        LinkedHashMap<Long, ProgrammeParserModel> map = new LinkedHashMap<Long, ProgrammeParserModel>(8);
        Date time = KDDateUtils.now();
        for (DynamicObject dy : availableProgrammeDy) {
            DynamicObjectCollection entitys = dy.getDynamicObjectCollection("apiassosettingentity");
            DynamicObject linkDy = dy.getDynamicObject("link");
            Long pkId = (Long)dy.getPkValue();
            Long link = 0L;
            Long syssource = 0L;
            String syssourceNumber = "";
            if (linkDy != null) {
                DynamicObject syssourceDy;
                link = (Long)linkDy.getPkValue();
                DynamicObject loadSingleLink = (DynamicObject)linkLoads.get(linkDy.getPkValue());
                if (loadSingleLink != null && (syssourceDy = loadSingleLink.getDynamicObject("syssource")) != null) {
                    syssource = (Long)syssourceDy.getPkValue();
                    syssourceNumber = syssourceDy.getString("number");
                }
            }
            DynamicObject billentityDy = dy.getDynamicObject("billentity");
            String billentity = "";
            if (billentityDy != null) {
                billentity = (String)billentityDy.getPkValue();
            }
            DynamicObject groupDy = dy.getDynamicObject("group");
            Long group = 0L;
            if (groupDy != null) {
                group = (Long)groupDy.getPkValue();
            }
            String triggertype = dy.getString("triggertype");
            String operatorStr = dy.getString("operator");
            List entrysSorted = entitys.stream().sorted(Comparator.comparing(row -> row.getInt("seq"))).collect(Collectors.toList());
            for (DynamicObject entity : entrysSorted) {
                String apipurpose0 = entity.getString("apipurpose");
                if (apipurpose == null || !apipurpose.equals(apipurpose0)) continue;
                ProgrammeParserModel model = new ProgrammeParserModel();
                Long pkValue = (Long)entity.getPkValue();
                String standardBillKey = "";
                String standardEntityKeys = "";
                DynamicObject standardapiDy = PbdProgrammeParserHelper.buildStandardApiAndReturn(standardapiLoads, entity, model, standardBillKey, standardEntityKeys);
                PbdProgrammeParserHelper.buildPlatformApi(entity, model, standardapiDy);
                Integer effectiveness = entity.getInt("effectiveness");
                model.setLink(link);
                model.setOpenStatusLink((String)linkOpenStatusMap.get(link));
                model.setSyssource(syssource);
                model.setSyssourceNumber(syssourceNumber);
                model.setBillentity(billentity);
                model.setGroup(group);
                model.setTriggertype(triggertype);
                model.setOperator(operatorStr);
                model.setEffectiveness(effectiveness);
                model.setApipurpose(apipurpose);
                model.setId(pkId);
                model.setDateTime(time);
                model.setOrgId(orgId);
                map.put(pkValue, model);
            }
        }
        return map;
    }

    private static void buildPlatformApi(DynamicObject entity, ProgrammeParserModel model, DynamicObject standardapiDy) {
        DynamicObjectCollection entryentitys;
        DynamicObject platformapiDy = entity.getDynamicObject("platformapi");
        Long platformapi = 0L;
        String platformApiNumber = "";
        String platformApiFullName = "";
        String platformApiName = "";
        String contype = "";
        if (platformapiDy != null) {
            platformapi = (Long)platformapiDy.getPkValue();
            platformApiNumber = platformapiDy.getString("number");
            platformApiFullName = platformapiDy.getString("full_name");
            contype = platformapiDy.getString("contype");
            platformApiName = platformapiDy.getString("name");
        }
        Long entryEntityId = null;
        if (standardapiDy != null && !CollectionUtils.isEmpty((Collection)(entryentitys = standardapiDy.getDynamicObjectCollection("entryentity")))) {
            for (DynamicObject entryentity : entryentitys) {
                DynamicObject entryPlatformapiDy = entryentity.getDynamicObject("platformapi");
                if (platformapiDy == null || !platformapi.equals(entryPlatformapiDy.getPkValue())) continue;
                entryEntityId = (Long)entryentity.getPkValue();
                break;
            }
        }
        model.setContype(contype);
        model.setStandardEntryEntityId(entryEntityId);
        model.setPlatformapi(platformapi);
        model.setPlatformApiNumber(platformApiNumber);
        model.setPlatformApiFullName(platformApiFullName);
        model.setPlatformApiName(platformApiName);
    }

    private static DynamicObject buildStandardApiAndReturn(Map<Object, DynamicObject> standardapiLoads, DynamicObject entity, ProgrammeParserModel model, String standardBillKey, String standardEntityKeys) {
        DynamicObject standardapiDy = entity.getDynamicObject("standardapi");
        Long standardapi = 0L;
        if (standardapiDy != null) {
            DynamicObject source;
            standardapi = (Long)standardapiDy.getPkValue();
            if ((standardapiDy = standardapiLoads.get(standardapiDy.getPkValue())) != null && (source = standardapiDy.getDynamicObject("source")) != null) {
                DynamicObject billKey = source.getDynamicObject("source");
                if (billKey != null) {
                    standardBillKey = (String)billKey.getPkValue();
                }
                standardEntityKeys = source.getString("entitycode");
            }
        }
        model.setStandardapi(standardapi);
        model.setLoadSingleStandardapi(standardapiDy);
        model.setStandardBillKey(standardBillKey);
        model.setStandardEntityKeys(PbdProgrammeParserHelper.getEntityKeyList(standardEntityKeys));
        return standardapiDy;
    }

    private static void loadData(Long orgId, List<DynamicObject> availableProgrammeDy, Map<Object, DynamicObject> linkLoads, Map<Object, DynamicObject> standardapiLoads, Map<Object, String> linkOpenStatusMap) {
        Map loads;
        ArrayList<Object> linkPkIds = new ArrayList<Object>(8);
        ArrayList<Object> standardapiIds = new ArrayList<Object>(8);
        for (DynamicObject dy : availableProgrammeDy) {
            DynamicObject linkDy = dy.getDynamicObject("link");
            if (linkDy != null) {
                linkPkIds.add(linkDy.getPkValue());
            }
            DynamicObjectCollection entitys = dy.getDynamicObjectCollection("apiassosettingentity");
            for (DynamicObject entity : entitys) {
                DynamicObject standardapiDy = entity.getDynamicObject("standardapi");
                if (standardapiDy == null) continue;
                standardapiIds.add(standardapiDy.getPkValue());
            }
        }
        if (!CollectionUtils.isEmpty(linkPkIds)) {
            loads = BusinessDataServiceHelper.loadFromCache((Object[])linkPkIds.toArray(), (String)"pbd_credit_link");
            if (!CollectionUtils.isEmpty((Map)loads)) {
                for (Map.Entry entry : loads.entrySet()) {
                    String linkOpenStatus = "1";
                    DynamicObject link = (DynamicObject)entry.getValue();
                    Object linkPkId = entry.getKey();
                    linkOpenStatus = PbdProgrammeParserHelper.getLinkOpenStatus(orgId, link, linkOpenStatus);
                    linkOpenStatusMap.put(linkPkId, linkOpenStatus);
                }
            }
            linkLoads.putAll(loads);
        }
        if (!CollectionUtils.isEmpty(standardapiIds)) {
            loads = BusinessDataServiceHelper.loadFromCache((Object[])standardapiIds.toArray(), (String)"pbd_standard_api");
            standardapiLoads.putAll(loads);
        }
    }

    private static String getLinkOpenStatus(Long orgId, DynamicObject loadSingleLink, String linkOpenStatus) {
        Boolean linkwholegroup = loadSingleLink.getBoolean("wholegroup");
        Set<Long> entrySubordinateOrgsLink = PbdCreditUtils.getLinkCompanyOrgIds(loadSingleLink);
        String openStatusLink = null;
        if (linkwholegroup.booleanValue() || entrySubordinateOrgsLink.contains(orgId)) {
            openStatusLink = loadSingleLink.getString("openstatus");
        }
        return openStatusLink;
    }

    private static List<String> getEntityKeyList(String standardEntityKeys) {
        ArrayList<String> entityKeyList = new ArrayList<String>(8);
        if (StringUtils.isNotBlank((CharSequence)standardEntityKeys)) {
            String[] entityKeys;
            for (String entityKey : entityKeys = standardEntityKeys.split(",")) {
                if ("".equals(entityKey)) continue;
                entityKeyList.add(entityKey);
            }
        }
        return entityKeyList;
    }

    private static void parsePluginPolicyField(DynamicObjectCollection pluginpolicy, ProgrammeParserModel model) {
        if (CollectionUtils.isEmpty((Collection)pluginpolicy)) {
            return;
        }
        ArrayList<PluginModel> pluginModelList = new ArrayList<PluginModel>(8);
        for (DynamicObject dy : pluginpolicy) {
            PluginModel pluginModel = new PluginModel();
            pluginModel.setPlclassname(dy.getString("plclassnamefield"));
            pluginModel.setPldisplayname(dy.getString("pldisplaynamefield"));
            pluginModel.setPlisenable(dy.getBoolean("plisenablefield"));
            pluginModel.setPldescription(dy.getString("pldescriptionfield"));
            pluginModelList.add(pluginModel);
        }
        model.setPluginPolicyField(pluginModelList);
    }

    private static void parsePluginPolicyRule(DynamicObjectCollection pluginpolicy, ProgrammeParserModel model) {
        if (CollectionUtils.isEmpty((Collection)pluginpolicy)) {
            return;
        }
        ArrayList<PluginModel> pluginModelList = new ArrayList<PluginModel>(8);
        for (DynamicObject dy : pluginpolicy) {
            PluginModel pluginModel = new PluginModel();
            pluginModel.setPlclassname(dy.getString("plclassnamerule"));
            pluginModel.setPldisplayname(dy.getString("pldisplaynamerule"));
            pluginModel.setPlisenable(dy.getBoolean("plisenablerule"));
            pluginModel.setPldescription(dy.getString("pldescriptionrule"));
            pluginModelList.add(pluginModel);
        }
        model.setPluginPolicyRule(pluginModelList);
    }

    private static void parseInputsCheckData(DynamicObjectCollection checkdata, ProgrammeParserModel model, String type) {
        if (CollectionUtils.isEmpty((Collection)checkdata)) {
            return;
        }
        ArrayList<FieldMappingModel> fieldMappingList = new ArrayList<FieldMappingModel>(8);
        if ("input".equals(type)) {
            for (DynamicObject dy : checkdata) {
                FieldMappingModel fieldMapping = new FieldMappingModel();
                fieldMapping.setSourcefield(dy.getString("inputsrcrulefield"));
                fieldMapping.setSourcefielddesc(dy.getString("inputsrcrulefielddesc"));
                fieldMapping.setFieldtype(dy.getString("inputruletype"));
                fieldMapping.setTargetfield(dy.getString("inputtarrulefield"));
                fieldMapping.setTargetfieldname(dy.getString("inputtarrulefieldname"));
                fieldMapping.setTargetconstant(dy.getString("inputtarruletconstant"));
                fieldMapping.setRemark(dy.getString("inputruleremark"));
                fieldMappingList.add(fieldMapping);
            }
            model.setInputscheckdata(fieldMappingList);
        } else if ("output".equals(type)) {
            for (DynamicObject dy : checkdata) {
                FieldMappingModel fieldMapping = new FieldMappingModel();
                fieldMapping.setSourcefield(dy.getString("outputsrcrulefield"));
                fieldMapping.setSourcefielddesc(dy.getString("outputsrcrulefielddesc"));
                fieldMapping.setFieldtype(dy.getString("outputruletype"));
                fieldMapping.setTargetfield(dy.getString("outputtarrulefield"));
                fieldMapping.setTargetfieldname(dy.getString("outputtarrulefieldname"));
                fieldMapping.setTargetconstant(dy.getString("outputtarruletconstant"));
                fieldMapping.setRemark(dy.getString("outputruleremark"));
                fieldMappingList.add(fieldMapping);
            }
            model.setOutputscheckdata(fieldMappingList);
        }
    }

    private static void parseInputsFieldMap(DynamicObjectCollection fieldmap, ProgrammeParserModel model, String type) {
        if (CollectionUtils.isEmpty((Collection)fieldmap)) {
            return;
        }
        ArrayList<FieldMappingModel> fieldMappingList = new ArrayList<FieldMappingModel>(8);
        if ("input".equals(type)) {
            for (DynamicObject dy : fieldmap) {
                FieldMappingModel fieldMapping = new FieldMappingModel();
                fieldMapping.setSourcefield(dy.getString("inputsourcefield"));
                fieldMapping.setSourcefielddesc(dy.getString("inputsourcefielddesc"));
                fieldMapping.setFieldtype(dy.getString("inputfieldtype"));
                fieldMapping.setTargetfield(dy.getString("inputtargetfield"));
                fieldMapping.setTargetfieldname(dy.getString("inputtargetfieldname"));
                fieldMapping.setRemark(dy.getString("inputremark"));
                fieldMapping.setTargetconstant(dy.getString("inputtargetconstant"));
                fieldMappingList.add(fieldMapping);
            }
            model.setInputsfieldmap(fieldMappingList);
        } else if ("output".equals(type)) {
            for (DynamicObject dy : fieldmap) {
                FieldMappingModel fieldMapping = new FieldMappingModel();
                fieldMapping.setSourcefield(dy.getString("outputsourcefield"));
                fieldMapping.setSourcefielddesc(dy.getString("outputsourcefielddesc"));
                fieldMapping.setFieldtype(dy.getString("outputfieldtype"));
                fieldMapping.setTargetfield(dy.getString("outputtargetfield"));
                fieldMapping.setTargetfieldname(dy.getString("outputtargetfieldname"));
                fieldMapping.setRemark(dy.getString("outputfieldformula"));
                fieldMapping.setRemark(dy.getString("outputfieldformuladesc"));
                fieldMappingList.add(fieldMapping);
            }
            model.setOutputsfieldmap(fieldMappingList);
        }
    }

    private static List<DynamicObject> findAvailableProgramme(Long orgId, String entityKey, String operator) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("operator", "=", (Object)operator);
        qFilter.and("billentity", "=", (Object)entityKey);
        String selectProperties = "number,name,group,createorg,link,billentity,triggertype,operator,wholegroup,,apiassosettingentity.seq,apiassosettingentity.standardapi,apiassosettingentity.platformapi,apiassosettingentity.effectiveness,apiassosettingentity.apipurpose,orgentity.companyorg,orgentity.includesuborg";
        DynamicObject[] programmeDys = BusinessDataServiceHelper.load((String)"pbd_service_programme", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
        if (programmeDys != null && programmeDys.length > 0) {
            for (DynamicObject dy : programmeDys) {
                DynamicObjectCollection entryEntitys = dy.getDynamicObjectCollection("orgentity");
                Boolean wholegroup = dy.getBoolean("wholegroup");
                if (wholegroup.booleanValue() && CollectionUtils.isEmpty((Collection)entryEntitys)) {
                    list.add(dy);
                    continue;
                }
                Set<Object> entrySubordinateOrgs = new HashSet(8);
                HashMap<Long, Boolean> entryOrgIdIncludeSubOrgMap = new HashMap<Long, Boolean>(8);
                if (!CollectionUtils.isEmpty((Collection)entryEntitys)) {
                    for (DynamicObject orgdy : entryEntitys) {
                        DynamicObject companyorg = orgdy.getDynamicObject("companyorg");
                        Boolean includesuborg = orgdy.getBoolean("includesuborg");
                        if (companyorg == null) continue;
                        entryOrgIdIncludeSubOrgMap.put((Long)companyorg.getPkValue(), includesuborg);
                    }
                    entrySubordinateOrgs = PbdCreditUtils.getAllSubordinateOrgs(entryOrgIdIncludeSubOrgMap, Boolean.FALSE);
                }
                if (!entrySubordinateOrgs.contains(orgId)) continue;
                list.add(dy);
            }
        }
        return list;
    }
}

