/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.CodeRuleUtil;
import kd.scm.pbd.common.entity.TycMonitorResultDto;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

public class PbdSupplierMonitorHelper {
    private static final String OK = "OK";
    private static Log log = LogFactory.getLog(PbdSupplierMonitorHelper.class);

    public static String addMonitor(DynamicObject dy, Set<Long> selectedRows, String operator) {
        DynamicObject org = dy.getDynamicObject("org");
        DynamicObjectCollection entryentity = dy.getDynamicObjectCollection("entryentity");
        String suppliername = PbdSupplierMonitorHelper.getColFieldDatas(entryentity, selectedRows, "suppliername", true, true);
        if (StringUtils.isEmpty((CharSequence)suppliername)) {
            return null;
        }
        dy.set("suppliernames", (Object)suppliername);
        DynamicObject group = dy.getDynamicObject("group");
        String groupstrid = dy.getString("groupstr");
        dy.set("opttype", (Object)"1");
        if (group != null && StringUtils.isBlank((CharSequence)groupstrid)) {
            String groupid = PbdSupplierMonitorHelper.addMonitorGroup(org.getPkValue(), group);
            if (groupid == null) {
                log.warn("\u8c03\u7528\u542f\u4fe1\u5b9d\u6dfb\u52a0\u76d1\u63a7\u5206\u7ec4\u8fd4\u56de\u4e3a\u7a7a\u3002");
                return null;
            }
            dy.set("groupstr", (Object)groupid);
        }
        String jobid = dy.getString("jobid");
        TycMonitorResultDto monitorResultDto = null;
        String operatorName = ResManager.loadKDString((String)"\u52a0\u5165\u76d1\u63a7\u4f01\u4e1a", (String)"PbdSupplierMonitorHelper_1", (String)"scm-pbd-common", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)jobid)) {
            Object result = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"IBusinessRulesService", (String)"query", (Object[])new Object[]{org.getPkValue(), "pbd_supplier_monitor", operator, dy});
            log.info("\u8c03\u7528\u67e5\u8be2\u7c7b\u63a5\u53e3\u8fd4\u56deresult:{}", (Object)SerializationUtils.toJsonString((Object)result));
            monitorResultDto = PbdSupplierMonitorHelper.analysisResult(result, operator, selectedRows.size());
        } else {
            monitorResultDto = new TycMonitorResultDto();
            monitorResultDto.setSysnumber("SCM-QiXinBao");
            monitorResultDto.setState(OK);
        }
        if (monitorResultDto != null) {
            String state;
            String sysnumber = monitorResultDto.getSysnumber();
            if (sysnumber.contains("QiXinBao")) {
                String data = monitorResultDto.getData();
                dy.set("jobid", (Object)data);
                String successCountStr = PbdSupplierMonitorHelper.executeQiXinBaoMonitorResult(dy, org.getPkValue());
                monitorResultDto.setData(successCountStr);
            }
            if ((state = monitorResultDto.getState()) != null && OK.equalsIgnoreCase(state.toString())) {
                Integer successCount = 0;
                if (StringUtils.isNotBlank((CharSequence)monitorResultDto.getData())) {
                    successCount = Integer.valueOf(monitorResultDto.getData());
                }
                if (successCount > 0) {
                    for (DynamicObject entrydy : entryentity) {
                        Long entryId = (Long)entrydy.getPkValue();
                        if (!selectedRows.contains(entryId) || !PbdSupplierMonitorHelper.addMonitorCheck(entrydy)) continue;
                        entrydy.set("monitorstatus", (Object)"B");
                    }
                    Boolean isbandurl = dy.getBoolean("isbindurl");
                    if (!isbandurl.booleanValue()) {
                        PbdSupplierMonitorHelper.bindCallBack(dy, "bindcallback");
                        dy.set("isbindurl", (Object)true);
                    }
                    SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{dy});
                    PbdSupplierMonitorHelper.updateSupplierData(dy);
                    String parseResult = PbdSupplierMonitorHelper.parseResult(monitorResultDto, operatorName);
                    return parseResult;
                }
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{dy});
        }
        return null;
    }

    private static TycMonitorResultDto analysisResult(Object result, String operator, Integer size) {
        TycMonitorResultDto tycmonitorResult = null;
        if (result instanceof Map) {
            Map map = (Map)result;
            Boolean success = (Boolean)map.get("success");
            if (!success.booleanValue() || map.get("data") == null) {
                return null;
            }
            Object sysnumberObj = map.get("sysnumber");
            Object data = map.get("data");
            log.info("\u8c03\u7528\u76d1\u63a7\u63a5\u53e3\u8fd4\u56de\u7ed3\u679cdata:{}", (Object)SerializationUtils.toJsonString(data));
            if (sysnumberObj != null) {
                String sysnumber = sysnumberObj.toString();
                if (sysnumber.contains("TYC-MONITOR")) {
                    if (data instanceof Map) {
                        Map dataMap = (Map)data;
                        if (!dataMap.containsKey("result")) {
                            return null;
                        }
                        String resultTyc = (String)dataMap.get("result");
                        tycmonitorResult = (TycMonitorResultDto)SerializationUtils.fromJsonString((String)resultTyc, TycMonitorResultDto.class);
                        tycmonitorResult.setSysnumber(sysnumber);
                    }
                } else if (sysnumber.contains("QiXinBao")) {
                    tycmonitorResult = new TycMonitorResultDto();
                    tycmonitorResult.setData(SerializationUtils.toJsonString(data));
                    tycmonitorResult.setSysnumber(sysnumber);
                    tycmonitorResult.setState(OK);
                    PbdSupplierMonitorHelper.analysisQiXinBaoResult(tycmonitorResult, data, operator, size);
                }
            }
        }
        return tycmonitorResult;
    }

    private static void analysisQiXinBaoResult(TycMonitorResultDto tycmonitorResult, Object data, String operator, Integer size) {
        if (data instanceof Map) {
            JSONObject fromObject = JSONObject.fromObject((Object)data);
            switch (operator) {
                case "addgroup": {
                    Object groupIdObj = fromObject.get("group_id");
                    if (groupIdObj == null || groupIdObj instanceof JSONNull) break;
                    String groupId = (String)groupIdObj;
                    tycmonitorResult.setData(groupId);
                    break;
                }
                case "addmonitor": {
                    Object jobidObj = fromObject.get("jobid");
                    if (jobidObj == null || jobidObj instanceof JSONNull) break;
                    String jobid = (String)jobidObj;
                    tycmonitorResult.setData(jobid);
                    break;
                }
                case "delmonitor": {
                    tycmonitorResult.setData(String.valueOf(size));
                }
            }
        } else if (data instanceof List && "getaddmonitorresult".equals(operator)) {
            JSONArray jsonArray = JSONArray.fromObject((Object)data);
            if (jsonArray == null || jsonArray.isEmpty()) {
                tycmonitorResult.setData("0");
            } else {
                tycmonitorResult.setData(String.valueOf(jsonArray.size()));
            }
        }
    }

    private static String executeQiXinBaoMonitorResult(DynamicObject dy, Object orgId) {
        Object result = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"IBusinessRulesService", (String)"query", (Object[])new Object[]{orgId, "pbd_supplier_monitor", "getaddmonitorresult", dy});
        TycMonitorResultDto monitorResultDto = PbdSupplierMonitorHelper.analysisResult(result, "getaddmonitorresult", 1);
        if (monitorResultDto == null) {
            return "0";
        }
        return monitorResultDto.getData();
    }

    private static String addMonitorGroup(Object orgId, DynamicObject group) {
        DynamicObjectCollection entryentity = group.getDynamicObjectCollection("entryentity");
        String apiidstr = PbdSupplierMonitorHelper.getColFieldDatas(entryentity, null, "apiid", false, false);
        if (StringUtils.isEmpty((CharSequence)apiidstr)) {
            return null;
        }
        group.set("apiids", (Object)apiidstr);
        Object result = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"IBusinessRulesService", (String)"query", (Object[])new Object[]{orgId, "pbd_monitor_group", "addgroup", group});
        log.info("\u8c03\u7528\u542f\u4fe1\u5b9d\u6dfb\u52a0\u76d1\u63a7\u5206\u7ec4\u63a5\u53e3\u8fd4\u56de\u7ed3\u679cresult:{}", (Object)SerializationUtils.toJsonString((Object)result));
        TycMonitorResultDto monitorResultDto = PbdSupplierMonitorHelper.analysisResult(result, "addgroup", 1);
        if (monitorResultDto == null) {
            return null;
        }
        String data = monitorResultDto.getData();
        Object pkValue = group.getPkValue();
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"pbd_monitor_group");
        loadSingle.set("group", (Object)data);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{loadSingle});
        return data;
    }

    private static String getColFieldDatas(DynamicObjectCollection entryentity, Set<Long> selectedRows, String fieldCode, Boolean isaddMonitorImpl, Boolean isAdd) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject entrydy : entryentity) {
            String fielddata = entrydy.getString(fieldCode);
            if (isaddMonitorImpl.booleanValue()) {
                Long entryId = (Long)entrydy.getPkValue();
                boolean check = PbdSupplierMonitorHelper.addMonitorCheck(entrydy);
                if (!isAdd.booleanValue()) {
                    check = PbdSupplierMonitorHelper.removeMonitorCheck(entrydy);
                }
                if (selectedRows == null || !selectedRows.contains(entryId) || !check) continue;
                sb.append(fielddata).append(",");
                continue;
            }
            sb.append(fielddata).append(",");
        }
        if (sb.length() == 0) {
            return null;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean removeMonitorCheck(DynamicObject entrydy) {
        String monitorstatus = entrydy.getString("monitorstatus");
        return "B".equals(monitorstatus);
    }

    private static String parseResult(TycMonitorResultDto data, String operatorName) {
        StringBuilder sbResult = new StringBuilder();
        String successCount = data.getData();
        sbResult.append(operatorName).append(ResManager.loadKDString((String)"\u6210\u529f\u6761\u6570\uff1a", (String)"PbdSupplierMonitorHelper_2", (String)"scm-pbd-common", (Object[])new Object[0])).append(successCount.toString()).append("\r\n");
        return sbResult.toString();
    }

    public static boolean addMonitorCheck(DynamicObject entrydy) {
        Date monitorbeforetime = entrydy.getDate("monitorbeforetime");
        Date monitoraftertime = entrydy.getDate("monitoraftertime");
        Date date = KDDateUtils.now();
        if (monitorbeforetime.compareTo(date) > 0 || monitoraftertime.compareTo(date) <= 0) {
            return false;
        }
        String monitorstatus = entrydy.getString("monitorstatus");
        return !"B".equals(monitorstatus);
    }

    public static String removeMonitor(DynamicObject dy, Set<Long> selectedRows, String operator) {
        DynamicObject org = dy.getDynamicObject("org");
        DynamicObjectCollection entryentity = dy.getDynamicObjectCollection("entryentity");
        String suppliername = PbdSupplierMonitorHelper.getColFieldDatas(entryentity, selectedRows, "suppliername", true, false);
        if (StringUtils.isEmpty((CharSequence)suppliername)) {
            return null;
        }
        dy.set("suppliernames", (Object)suppliername);
        dy.set("opttype", (Object)"0");
        Object result = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"IBusinessRulesService", (String)"query", (Object[])new Object[]{org.getPkValue(), "pbd_supplier_monitor", operator, dy});
        log.info("\u8c03\u7528\u5929\u773c\u67e5\u79fb\u9664\u76d1\u63a7\u4f01\u4e1a\u63a5\u53e3\u8fd4\u56deresult:", (Object)SerializationUtils.toJsonString((Object)result));
        TycMonitorResultDto monitorResultDto = PbdSupplierMonitorHelper.analysisResult(result, operator, selectedRows.size());
        if (monitorResultDto == null) {
            return null;
        }
        String state = monitorResultDto.getState();
        if (state == null || !OK.equalsIgnoreCase(state.toString())) {
            return null;
        }
        for (DynamicObject entrydy : entryentity) {
            Long entryId = (Long)entrydy.getPkValue();
            if (!selectedRows.contains(entryId) || !PbdSupplierMonitorHelper.removeMonitorCheck(entrydy)) continue;
            entrydy.set("monitorstatus", (Object)"C");
        }
        dy.set("jobid", (Object)"");
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{dy});
        PbdSupplierMonitorHelper.updateSupplierData(dy);
        String msg = ResManager.loadKDString((String)"\u79fb\u9664\u76d1\u63a7\u4f01\u4e1a\u6210\u529f\u6761\u6570\uff1a", (String)"PbdSupplierMonitorHelper_5", (String)"scm-pbd-common", (Object[])new Object[0]);
        String data2 = monitorResultDto.getData();
        String parseResult = msg + data2;
        return parseResult;
    }

    public static void bindCallBack(DynamicObject dyn, String operator) {
        DynamicObject org = dyn.getDynamicObject("org");
        Object result = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pbd", (String)"IBusinessRulesService", (String)"query", (Object[])new Object[]{org.getPkValue(), "pbd_supplier_monitor", operator, dyn});
        log.info("\u7ed1\u5b9a\u56de\u8c03\u5730\u5740\u8fd4\u56deresult:", (Object)SerializationUtils.toJsonString((Object)result));
    }

    public static void updateSupplierData(DynamicObject dyn) {
        DynamicObjectCollection entryentity = dyn.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return;
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        DynamicObject org = dyn.getDynamicObject("org");
        for (DynamicObject dy : entryentity) {
            String billno;
            String suppliername = dy.getString("suppliername");
            Date monitorbeforetime = dy.getDate("monitorbeforetime");
            Date monitoraftertime = dy.getDate("monitoraftertime");
            String monitorstatus = dy.getString("monitorstatus");
            QFilter qf = new QFilter("suppliername", "=", (Object)suppliername);
            DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"pbd_supplier_data", (String)"billno,billstatus,org,suppliername,monitorstatus,suppliermonitorid,monitorbeforetime,monitoraftertime", (QFilter[])new QFilter[]{qf});
            if (load == null) {
                load = BusinessDataServiceHelper.newDynamicObject((String)"pbd_supplier_data");
            }
            if (StringUtils.isEmpty((CharSequence)(billno = load.getString("billno")))) {
                String codeRule = CodeRuleUtil.getCodeRule((String)"pbd_service_rule_config");
                load.set("billno", (Object)codeRule);
            }
            load.set("billstatus", (Object)"C");
            load.set("suppliername", (Object)suppliername);
            load.set("monitorbeforetime", (Object)monitorbeforetime);
            load.set("monitoraftertime", (Object)monitoraftertime);
            load.set("suppliermonitorid", dyn.getPkValue());
            load.set("org", org.getPkValue());
            load.set("monitorstatus", (Object)monitorstatus);
            list.add(load);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    public static Set<Long> assembleSelectRowIds(String listselectedrowcollection) {
        Object[] entryPrimaryKeyValues;
        ListSelectedRowCollection rows;
        HashSet<Long> selectRows = new HashSet<Long>(8);
        if (StringUtils.isNotBlank((CharSequence)listselectedrowcollection) && (rows = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)listselectedrowcollection, ListSelectedRowCollection.class)) != null && !rows.isEmpty() && (entryPrimaryKeyValues = rows.getEntryPrimaryKeyValues()) != null) {
            Arrays.stream(entryPrimaryKeyValues).forEach(row -> selectRows.add(Long.valueOf(row.toString())));
        }
        return selectRows;
    }
}

