/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.common.utils;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.BasedataEntityType;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.businessfield.UserField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.FormulaField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.scm.pbd.common.utils.DateFormatUtil;
import kd.scm.pbd.common.utils.NumberFormatUtil;

public class FieldTypeUtil {
    public static final String TEXTFIELD = "string";
    public static final String DECIMALFIELD = "decimal";
    public static final String DATEFIELD = "datetime";
    public static final String ENUMFIELD = "ENUM";
    public static final String TIMEFIELD = "datetime";
    public static final String BASEDATAFIELD = "basedatafield";
    public static final String BOOLEANFIELD = "boolean";
    public static final String PICTUREFIELD = "pic";
    public static final String MULBASEDATAFIELD = "mulbasedatafield";
    public static final String BIGINTFIELD = "long";
    public static final String INTEGERFIELD = "int";

    public static String getPropType(Field<?> field) {
        if (field instanceof DateField || field instanceof DateTimeField || field instanceof DateRangeField) {
            return "datetime";
        }
        if (field instanceof TimeField || field instanceof TimeRangeField) {
            return "datetime";
        }
        if (field instanceof BigIntField && !(field instanceof IntegerField)) {
            return BIGINTFIELD;
        }
        if (field instanceof IntegerField && !(field instanceof DecimalField) && !(field instanceof FormulaField)) {
            return INTEGERFIELD;
        }
        if (field instanceof DecimalField || field instanceof FormulaField) {
            return DECIMALFIELD;
        }
        if (field instanceof RadioField || field instanceof CheckBoxField) {
            return BOOLEANFIELD;
        }
        if (field instanceof RadioGroupField || field instanceof ComboField || field instanceof MulComboField) {
            return ENUMFIELD;
        }
        if (field instanceof OrgField || field instanceof UserField || field instanceof BasedataField) {
            return BASEDATAFIELD;
        }
        if (field instanceof MulBasedataField) {
            return MULBASEDATAFIELD;
        }
        return TEXTFIELD;
    }

    public static Object transferFieldValue(String fieldType, Object data) {
        if (data == null) {
            return data;
        }
        ArrayList<Object> newData = null;
        if ("datetime".equals(fieldType)) {
            newData = DateFormatUtil.object2date(data, null);
        } else if ("datetime".equals(fieldType)) {
            newData = DateFormatUtil.object2date(data, null);
        } else if (DECIMALFIELD.equals(fieldType)) {
            newData = NumberFormatUtil.format2Decimal(data);
        } else if (BOOLEANFIELD.equals(fieldType)) {
            newData = "true".equals(data) || "1".equals(data) ? "1" : "0";
        } else if (BASEDATAFIELD.equals(fieldType)) {
            DynamicObject dy = (DynamicObject)data;
            Object id = dy.getPkValue();
            newData = id;
        } else if (MULBASEDATAFIELD.equals(fieldType)) {
            ArrayList<Object> list = new ArrayList<Object>(8);
            DynamicObjectCollection cols = (DynamicObjectCollection)data;
            for (DynamicObject dy : cols) {
                Object id = dy.getPkValue();
                list.add(id);
            }
            newData = list;
        } else {
            Object basedataNameValue = FieldTypeUtil.getNameValue(data);
            newData = basedataNameValue;
        }
        return newData;
    }

    public static Object getNameValue(Object value) {
        if (value instanceof DynamicObject && ((DynamicObject)value).getDataEntityType() instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)((DynamicObject)value).getDataEntityType();
            String nameProperty = basedataEntityType.getNameProperty();
            String nameValue = ((DynamicObject)value).getString(nameProperty);
            return nameValue;
        }
        Object newData = FieldTypeUtil.getLocalValue(value);
        return newData;
    }

    public static Object transferThirdFieldValue(String thirdfieldtype, Object data) {
        Object newData = FieldTypeUtil.getLocalValue(data);
        if ("datetime".equals(thirdfieldtype)) {
            newData = DateFormatUtil.object2date(data, null);
        } else if ("datetime".equals(thirdfieldtype)) {
            newData = DateFormatUtil.object2date(data, null);
        } else if (DECIMALFIELD.equals(thirdfieldtype)) {
            newData = NumberFormatUtil.format2Decimal(data);
        } else if (BOOLEANFIELD.equals(thirdfieldtype)) {
            newData = "true".equals(data) || "1".equals(data);
        } else if (BASEDATAFIELD.equals(thirdfieldtype)) {
            DynamicObject dy = (DynamicObject)data;
            Object name = dy.get("name");
            newData = FieldTypeUtil.getLocalValue(name);
        } else if (MULBASEDATAFIELD.equals(thirdfieldtype)) {
            ArrayList<String> list = new ArrayList<String>(8);
            DynamicObjectCollection cols = (DynamicObjectCollection)data;
            for (DynamicObject dy : cols) {
                Object name = dy.get("name");
                newData = FieldTypeUtil.getLocalValue(name);
                list.add((String)newData);
            }
            newData = list;
        }
        return newData;
    }

    private static Object getLocalValue(Object name) {
        Object newData = null;
        if (name instanceof OrmLocaleValue) {
            OrmLocaleValue value = (OrmLocaleValue)name;
            String localeValue = value.getLocaleValue();
            newData = localeValue;
        } else {
            newData = name;
        }
        return newData;
    }
}

