/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.common.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class PbdCreditUtils {
    public static Set<Long> getAllSubordinateOrgs(Map<Long, Boolean> orgIdIncludeSubOrgMap, Boolean isWholeGroup) {
        HashSet<Long> orgIds = new HashSet<Long>(8);
        if (isWholeGroup.booleanValue()) {
            List allOrgIds = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"01", (boolean)Boolean.FALSE);
            orgIds.addAll(allOrgIds);
            return orgIds;
        }
        ArrayList<Long> orgIdIncludeSubOrgId = new ArrayList<Long>(8);
        for (Map.Entry<Long, Boolean> entrySet : orgIdIncludeSubOrgMap.entrySet()) {
            Long orgId = entrySet.getKey();
            Boolean includeSubOrg = entrySet.getValue();
            if (includeSubOrg.booleanValue()) {
                orgIdIncludeSubOrgId.add(orgId);
                continue;
            }
            orgIds.add(orgId);
        }
        if (CollectionUtils.isEmpty(orgIdIncludeSubOrgId)) {
            return orgIds;
        }
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgIdIncludeSubOrgId, (boolean)Boolean.TRUE);
        orgIds.addAll(subOrgIds);
        return orgIds;
    }

    public static void updateApplyOrg(IDataModel model, IFormView view) {
        Boolean wholegroup = model.getDataEntity().getBoolean("wholegroup");
        if (wholegroup.booleanValue()) {
            model.setValue("applyorg", (Object)ResManager.loadKDString((String)"\u5168\u96c6\u56e2", (String)"PbdCreditUtils_1", (String)"scm-pbd-common", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entryEntitys = model.getEntryEntity("orgentity");
        StringBuilder sb = new StringBuilder();
        String subStr = ResManager.loadKDString((String)"\u53ca\u4e0b\u7ea7\u7ec4\u7ec7", (String)"PbdCreditUtils_2", (String)"scm-pbd-common", (Object[])new Object[0]);
        String subSplit = "\uff1b";
        for (DynamicObject dy : entryEntitys) {
            DynamicObject companyorg = dy.getDynamicObject("companyorg");
            if (companyorg == null) continue;
            String orgName = companyorg.getLocaleString("name").getLocaleValue();
            sb.append(orgName);
            Boolean includesuborg = dy.getBoolean("includesuborg");
            if (includesuborg.booleanValue()) {
                sb.append(subStr);
            }
            sb.append(subSplit);
        }
        int length = sb.length();
        if (length > 0) {
            if (length >= 999) {
                sb.delete(996, length - 1);
                sb.append("...");
            } else {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        model.setValue("applyorg", (Object)sb.toString());
    }

    public static Set<Long> getLinkCompanyOrgIds(DynamicObject loadSingleLink) {
        HashSet<Long> entrySubordinateOrgsLink = new HashSet(8);
        Map<Long, Boolean> entryOrgIdIncludeSubOrgMapLink = PbdCreditUtils.getOrgEntityMap(loadSingleLink);
        entrySubordinateOrgsLink = PbdCreditUtils.getAllSubordinateOrgs(entryOrgIdIncludeSubOrgMapLink, Boolean.FALSE);
        return entrySubordinateOrgsLink;
    }

    public static Map<Long, Boolean> getOrgEntityMap(DynamicObject loadSingleLink) {
        HashMap<Long, Boolean> entryOrgIdIncludeSubOrgMapLink = new HashMap<Long, Boolean>(8);
        DynamicObjectCollection companyorgDys = loadSingleLink.getDynamicObjectCollection("orgentity");
        if (!CollectionUtils.isEmpty((Collection)companyorgDys)) {
            for (DynamicObject companyorgDy : companyorgDys) {
                Boolean linkIncludeSubOrg = companyorgDy.getBoolean("includesuborg");
                DynamicObject linkCompanyOrgDy = companyorgDy.getDynamicObject("companyorg");
                if (linkCompanyOrgDy == null) continue;
                entryOrgIdIncludeSubOrgMapLink.put((Long)linkCompanyOrgDy.getPkValue(), linkIncludeSubOrg);
            }
        }
        return entryOrgIdIncludeSubOrgMapLink;
    }

    public static void platformF7Select(BeforeF7SelectEvent args) {
        List<String> types = PbdCreditUtils.creditTypes();
        QFilter qFilter = new QFilter("systype", "in", types);
        ListShowParameter showParameter = (ListShowParameter)args.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    public static List<String> creditTypes() {
        ArrayList<String> types = new ArrayList<String>(8);
        types.add("U");
        types.add("V");
        types.add("W");
        types.add("X");
        types.add("Y");
        types.add("Z");
        types.add("u");
        types.add("v");
        types.add("w");
        types.add("x");
        types.add("y");
        types.add("z");
        return types;
    }
}

