/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.common.utils;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.i18n.api.model.TelephoneVerifyResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.login.utils.MessageUtils;
import kd.bos.message.api.EmailInfo;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class PbdRegCommonUtils {
    private static int verfyCodeExpireTime = 300;

    public static void addOnProgressListener(AbstractFormPlugin dataModelPlugin, String progress, String getmsg, String htmlap) {
        ((ProgressBar)dataModelPlugin.getControl(progress)).addProgressListener(progressEvent -> {
            ProgressBar progressBar = (ProgressBar)dataModelPlugin.getControl(progress);
            progressBar.stop();
            dataModelPlugin.getView().setVisible(Boolean.TRUE, new String[]{getmsg});
            dataModelPlugin.getView().setVisible(Boolean.FALSE, new String[]{htmlap});
            dataModelPlugin.getView().updateView();
        });
    }

    public static Map<String, Object> getMsgValid(String account, IAppCache verifyCodeExpire) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("success", true);
        StringBuilder msg = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)account)) {
            if (account.contains("+86")) {
                account = account.substring(3, 14);
            }
            if (StringUtils.isEmail((String)account) || StringUtils.isPhoneNumberValid((String)account) || account.contains("-")) {
                if (verifyCodeExpire == null) {
                    msg.append(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4ecd\u6709\u6548\uff0c\u65e0\u9700\u518d\u6b21\u83b7\u53d6\u3002", (String)"PbdRegCommonUtils_0", (String)"scm-pbd-common", (Object[])new Object[0]));
                    resultMap.put("success", false);
                    resultMap.put("msg", msg);
                }
            } else {
                msg.append(ResManager.loadKDString((String)"\u624b\u673a\u53f7/\u90ae\u7bb1\u8f93\u5165\u9519\u8bef\u3002", (String)"PbdRegCommonUtils_1", (String)"scm-pbd-common", (Object[])new Object[0]));
                resultMap.put("success", false);
                resultMap.put("msg", msg);
            }
        } else {
            msg.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u624b\u673a\u53f7/\u90ae\u7bb1\u3002", (String)"PbdRegCommonUtils_2", (String)"scm-pbd-common", (Object[])new Object[0]));
            resultMap.put("success", false);
            resultMap.put("msg", msg);
        }
        return resultMap;
    }

    public static void getMsg(AbstractFormPlugin dataModelPlugin, IAppCache verifyCodeExpire, String fun) {
        boolean isDebug;
        String randomStr = PbdRegCommonUtils.createRandNum();
        IFormView view = dataModelPlugin.getView();
        String msg = String.format(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\uff1a%1$s\u3002\u60a8\u6b63\u5728\u4f7f\u7528\u77ed\u4fe1\u9a8c\u8bc1\u7801%2$s\u529f\u80fd\uff0c\u8be5\u9a8c\u8bc1\u7801\u4ec5\u7528\u4e8e\u8eab\u4efd\u9a8c\u8bc1\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u52ff\u6cc4\u9732\u7ed9\u4ed6\u4eba\u4f7f\u7528\u3002", (String)"PbdRegCommonUtils_3", (String)"scm-pbd-common", (Object[])new Object[0]), randomStr, fun);
        String emailmsg = String.format(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\uff1a%1$s\u3002\u60a8\u6b63\u5728\u4f7f\u7528\u90ae\u7bb1\u9a8c\u8bc1\u7801%2$s\u529f\u80fd\uff0c\u8be5\u9a8c\u8bc1\u7801\u4ec5\u7528\u4e8e\u8eab\u4efd\u9a8c\u8bc1\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u52ff\u6cc4\u9732\u7ed9\u4ed6\u4eba\u4f7f\u7528\u3002", (String)"PbdRegCommonUtils_4", (String)"scm-pbd-common", (Object[])new Object[0]), randomStr, fun);
        view.getPageCache().put("randomStr", randomStr);
        String account = String.valueOf(dataModelPlugin.getView().getModel().getValue("number"));
        EmailInfo emailInfo = new EmailInfo();
        emailInfo.setContentMimeType("TEXT");
        ArrayList<String> receivers = new ArrayList<String>();
        receivers.add(account);
        emailInfo.setReceiver(receivers);
        emailInfo.setTitle(String.format(ResManager.loadKDString((String)"\u90ae\u7bb1%1$s\u9a8c\u8bc1\u7801", (String)"PbdRegCommonUtils_5", (String)"scm-pbd-common", (Object[])new Object[0]), fun));
        emailInfo.setContent(emailmsg);
        if (account.contains("+86")) {
            account = account.substring(3, 14);
        }
        if (StringUtils.isEmail((String)account)) {
            if (verifyCodeExpire != null) {
                verifyCodeExpire.put(account, (Object)randomStr, verfyCodeExpireTime);
                MessageServiceHelper.sendEmail((EmailInfo)emailInfo);
            }
        } else if ((StringUtils.isPhoneNumberValid((String)account) || account.contains("-")) && verifyCodeExpire != null) {
            Object codesignal;
            verifyCodeExpire.put(account, (Object)randomStr, verfyCodeExpireTime);
            AppParam appParam = new AppParam();
            appParam.setViewType("15");
            appParam.setAppId("XV1IC150UR4");
            appParam.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
            Map systemMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            String signal = null;
            if (Objects.nonNull(systemMap) && Objects.nonNull(codesignal = systemMap.get("codesignal"))) {
                signal = codesignal.toString();
            }
            MessageUtils.sendMessage((String)account, (String)msg, signal);
        }
        view.getPageCache().put("randomStr", randomStr + account);
        view.setVisible(Boolean.FALSE, new String[]{"getmsg"});
        view.setVisible(Boolean.TRUE, new String[]{"htmlap"});
        Control control = view.getControl("isdebug");
        if (control != null && (isDebug = view.getModel().getDataEntity().getBoolean("isdebug"))) {
            view.getModel().setValue("validate", (Object)randomStr);
        }
        Html html = (Html)view.getControl("htmlap");
        html.setConent(PbdRegCommonUtils.getHtmlStr());
        ProgressBar progress = (ProgressBar)view.getControl("progressbarap");
        progress.start();
    }

    public static String createRandNum() {
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= 5; ++i) {
            String s = random.nextInt(10) + "";
            sb.append(s);
        }
        return sb.toString();
    }

    public static String validateVerycode(String randomStr, String validate) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)validate)) {
            if (StringUtils.isEmpty((CharSequence)randomStr)) {
                sb.append(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u3002", (String)"PbdRegCommonUtils_6", (String)"scm-pbd-common", (Object[])new Object[0]));
                return sb.toString();
            }
            if (!StringUtils.equals((CharSequence)randomStr, (CharSequence)validate)) {
                sb.append(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PbdRegCommonUtils_7", (String)"scm-pbd-common", (Object[])new Object[0]));
            }
        } else {
            sb.append(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"PbdRegCommonUtils_8", (String)"scm-pbd-common", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    private static String getHtmlStr() {
        StringBuilder content = new StringBuilder();
        content.append("<html><style>.cell{font-family:'Microsoft YaHei';");
        content.append("width:7em;height:1em;font-size:1em;overflow:hidden;position:relative;line-height:1em;top:28%;left:5%;margin:0;opacity:0;animation:go 60s;transform-origin:left bottom;}");
        content.append(".num{display:inline;position:absolute;margin-top:-1px;margin-left:2px;width:1.8em;color:#333;line-height:1em;text-align:center;text-shadow:0px 0px 0px rgba(255,255,255,.3);animation:run 60s steps(60);}");
        content.append("@keyframes run{0%{top:0;}100%{top:-60em;}}");
        content.append("@keyframes go{0%{opacity:1;}99.84%{opacity:1;transform:rotate(0deg)scale(1);}100%{opacity:0;transform:rotate(0deg)scale(.01);}}.main{display:inline-block;width:90px;height:28px;border:1px solid#BBB;background-color:#DDD;}");
        content.append(".content{margin-left:3px;margin-right:2px}</style><body><div class='main'><div class='cell'><span class='content'>");
        StringBuilder getMSg = new StringBuilder(ResManager.loadKDString((String)"\u91cd\u65b0\u83b7\u53d6", (String)"PbdRegCommonUtils_10", (String)"scm-pbd-common", (Object[])new Object[0]));
        content.append((CharSequence)getMSg);
        content.append("</span><div class='num'>(59) (58) (57) (56) (55) (54) (53) (52) (51) (50) (49) (48) (47) (46) (45) (44) (43) (42) (41) (40) (39) (38) (37) (36) (35) (34) (33) (32) (31) (30) (29) (28) (27) (26) (25) (24) (23) (22) (21) (20)");
        content.append("(19) (18) (17) (16) (15) (14) (13) (12) (11) (10) (9) (8) (7) (6) (5) (4) (3) (2) (1) (0)</div></div></div></body></html>");
        return content.toString();
    }

    public static boolean isEmail(String email) {
        String regex = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
        return Pattern.matches(regex, email);
    }

    public static String getFullPhoneFormat(String phone) {
        if (!phone.startsWith("+")) {
            phone = phone.contains("-") ? "+" + phone : "+86-" + phone;
        }
        return phone;
    }

    public static Map<String, Object> isPhone(String phoneNum) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        try {
            phoneNum = PbdRegCommonUtils.getFullPhoneFormat(phoneNum);
            List<String> phoneList = Collections.singletonList(phoneNum);
            PbdRegCommonUtils.validatePhone(phoneList);
        }
        catch (KDBizException e) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", e.getMessage());
        }
        return resultMap;
    }

    public static void validatePhone(List<String> phoneList) {
        List resultList = I18nServiceHelper.batchVerifyTelephoneNumber(phoneList);
        StringBuilder msg = new StringBuilder();
        for (TelephoneVerifyResult item : resultList) {
            Map result;
            String message;
            if (!item.isParseSuccess()) {
                throw new KDBizException(item.getParseErrorMsg());
            }
            if (item.isVerifySuccess() || !StringUtils.isNotBlank((CharSequence)(message = CollectionUtils.isEmpty((Map)(result = item.getVerifyResult())) ? "" : (String)result.get("message")))) continue;
            msg.append(String.format(ResManager.loadKDString((String)"\u8d26\u53f7\uff1a%1$s\u3002", (String)"PbdRegCommonUtils_9", (String)"scm-pbd-common", (Object[])new Object[0]), message));
            throw new KDBizException(msg.toString());
        }
    }
}

