/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;

public final class PbdMallGoodsPriceSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("mallgoods.id");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] mallGoodsDyns;
        DynamicObject[] objs = e.getDataEntities();
        if (objs.length > 0 && objs[0].getDataEntityType().getName().equals("pbd_mallgoods_pricelog")) {
            return;
        }
        HashMap<Long, DynamicObject> goodsId2PriceIdMap = new HashMap<Long, DynamicObject>(objs.length << 2);
        for (DynamicObject obj : objs) {
            goodsId2PriceIdMap.put(obj.getLong("mallgoods.id"), obj);
        }
        for (DynamicObject mallGoodsDyn : mallGoodsDyns = BusinessDataServiceHelper.load((String)"pbd_mallgoods", (String)"id, mallgoods.id,priceinfo", (QFilter[])new QFilter[]{new QFilter("id", "in", goodsId2PriceIdMap.keySet())})) {
            mallGoodsDyn.set("priceinfo", goodsId2PriceIdMap.get(mallGoodsDyn.getLong("id")));
        }
        SaveServiceHelper.save((DynamicObject[])mallGoodsDyns);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        ArrayList<Long> goodsIds = new ArrayList<Long>(16);
        for (DynamicObject obj : objs) {
            goodsIds.add(obj.getLong("mallgoods.id"));
        }
        if (goodsIds.size() > 0) {
            String name = objs[0].getDataEntityType().getName();
            if ("pbd_mallgoods_pricelog".equals(name)) {
                return;
            }
            QFilter logQf = new QFilter("mallgoods.id", "in", goodsIds);
            boolean isExistPriceLog = QueryServiceHelper.exists((String)"pbd_mallgoods_pricelog", (QFilter[])logQf.toArray());
            if (!isExistPriceLog) {
                return;
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            dataMap.put("goodsIds", goodsIds);
            dataMap.put("type", "1");
            EventServiceHelper.triggerEventSubscribe((String)"pmm_ecgoods.pricemonitor", (String)SerializationUtils.toJsonString(dataMap));
        }
    }
}

