/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.opplugin;

import java.util.LinkedHashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.scm.common.helper.multisystemjoint.business.MultiJointFailTaskHelper;
import kd.scm.common.helper.multisystemjoint.entity.MultiDataHandleConfig;
import kd.scm.common.helper.multisystemjoint.entity.MultiJointStoreDataHandleMessageInfo;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.scdatahandle.ScDataHandleTaskHelper;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleConfig;
import kd.scm.common.helper.scdatahandle.args.ScStoreDataHandleMessageInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PbdScDataFailRetryOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PbdScDataFailRetryOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("state");
        e.getFieldKeys().add("config_tag");
        e.getFieldKeys().add("params_tag");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        LinkedHashSet<ScStoreDataHandleMessageInfo> scStoreDataHandleMessageInfos = new LinkedHashSet<ScStoreDataHandleMessageInfo>(e.getDataEntities().length);
        LinkedHashSet<MultiJointStoreDataHandleMessageInfo> multiJointStoreDataHandleMessageInfoSet = new LinkedHashSet<MultiJointStoreDataHandleMessageInfo>(e.getDataEntities().length);
        for (DynamicObject failData : e.getDataEntities()) {
            String scDataLogId = failData.getString("id");
            try {
                String config = failData.getString("config_tag");
                ScDataHandleConfig scDataHandleConfig = (ScDataHandleConfig)SerializationUtils.fromJsonString((String)config, ScDataHandleConfig.class);
                String params = failData.getString("params_tag");
                ScDataHandleArgs scDataHandleArgs = (ScDataHandleArgs)SerializationUtils.fromJsonString((String)params, ScDataHandleArgs.class);
                ScStoreDataHandleMessageInfo scStoreDataHandleMessageInfo = new ScStoreDataHandleMessageInfo(scDataLogId);
                scStoreDataHandleMessageInfo.setScDataHandleArgs(scDataHandleArgs);
                scStoreDataHandleMessageInfo.setScDataHandleConfig(scDataHandleConfig);
                scStoreDataHandleMessageInfos.add(scStoreDataHandleMessageInfo);
            }
            catch (Throwable throwable) {
                log.error((Object)("\u5b58\u5728\u65e0\u6cd5\u53cd\u5e8f\u5217\u5316\u7684\u5b9e\u4f53\uff0c\u4f46\u662f\u4e0d\u5f71\u54cd\u53ef\u4ee5\u6b63\u5e38\u5e8f\u5217\u5316\u7684\u8bf7\u6c42\u6267\u884c" + throwable.getMessage()));
            }
            try {
                MultiJointStoreDataHandleMessageInfo jointStoreDataHandleMessageInfo = new MultiJointStoreDataHandleMessageInfo(scDataLogId);
                String config = failData.getString("config_tag");
                MultiDataHandleConfig multiDataHandleConfig = (MultiDataHandleConfig)SerializationUtils.fromJsonString((String)config, MultiDataHandleConfig.class);
                String params = failData.getString("params_tag");
                ScMultiParamArgs scMultiParamArgs = (ScMultiParamArgs)SerializationUtils.fromJsonString((String)params, ScMultiParamArgs.class);
                jointStoreDataHandleMessageInfo.setMultiParamArgs(scMultiParamArgs);
                jointStoreDataHandleMessageInfo.setMultiDataHandleConfig(multiDataHandleConfig);
                multiJointStoreDataHandleMessageInfoSet.add(jointStoreDataHandleMessageInfo);
            }
            catch (RuntimeException runtimeException) {
                log.error((Object)("\u5b58\u5728\u65e0\u6cd5\u53cd\u5e8f\u5217\u5316\u7684\u5b9e\u4f53\uff0c\u4f46\u662f\u4e0d\u5f71\u54cd\u53ef\u4ee5\u6b63\u5e38\u5e8f\u5217\u5316\u7684\u8bf7\u6c42\u6267\u884c" + runtimeException.getMessage()));
            }
        }
        if (!scStoreDataHandleMessageInfos.isEmpty()) {
            ScDataHandleTaskHelper.batchExecuteTask(scStoreDataHandleMessageInfos);
        }
        if (!multiJointStoreDataHandleMessageInfoSet.isEmpty()) {
            MultiJointFailTaskHelper.batchExecuteTask(multiJointStoreDataHandleMessageInfoSet);
        }
    }
}

