/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.opplugin.billrelation;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.helper.businesstracking.domain.BillRelationParam;

public final class PbdExecuteBillRelationSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog((String)PbdExecuteBillRelationSaveOp.class.getName());

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public Set<String> preparePropertys() {
                Set propertys = super.preparePropertys();
                propertys.add("number");
                propertys.add("isentrydim");
                propertys.add("entryentity.sourceentity");
                propertys.add("targetentryentity.seq");
                propertys.add("targetentryentity.targetentity");
                propertys.add("targetentryentity.executelinkconfig");
                return propertys;
            }

            public void validate() {
                ExtendedDataEntity[] extendedDataEntities;
                for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = this.getDataEntities()) {
                    DynamicObject row = extendedDataEntity.getDataEntity();
                    DynamicObject bill = (DynamicObject)row.getParent();
                    boolean isEntryDim = bill.getBoolean("isentrydim");
                    DynamicObjectCollection detailRows = row.getDynamicObjectCollection("targetentryentity");
                    StringBuilder checkMessage = new StringBuilder();
                    StringBuilder entryDimCheckMessage = new StringBuilder();
                    StringBuilder entityCheckMessage = new StringBuilder();
                    HashSet<String> preMajorEntitySet = new HashSet<String>(16);
                    String sourceEntity = row.getString("sourceentity.id");
                    preMajorEntitySet.add(sourceEntity);
                    for (DynamicObject detail : detailRows) {
                        String executeLinkConfig;
                        BillRelationParam billRelationParam;
                        String targetEntity = detail.getString("targetentity.id");
                        boolean anyMatch = preMajorEntitySet.stream().anyMatch(targetEntity::equals);
                        if (anyMatch) {
                            entityCheckMessage.append(targetEntity);
                        }
                        if (!isEntryDim || (billRelationParam = (BillRelationParam)SerializationUtils.fromJsonString((String)(executeLinkConfig = detail.getString("executelinkconfig")), BillRelationParam.class)).getSourceEntry() != null && billRelationParam.getTargetEntry() != null) continue;
                        if (entryDimCheckMessage.length() > 0) {
                            entryDimCheckMessage.append('\u3001').append(detail.getString("seq"));
                            continue;
                        }
                        entryDimCheckMessage.append(detail.getString("seq"));
                    }
                    if (entityCheckMessage.length() > 0) {
                        checkMessage.append((CharSequence)entityCheckMessage).append(System.lineSeparator());
                    }
                    if (isEntryDim && entryDimCheckMessage.length() > 0) {
                        checkMessage.append(ResManager.loadKDString((String)"\u4ee5\u4e0b\u884c\u7684\u914d\u7f6e\u4e0d\u6ee1\u8db3\u6309\u7167\u884c\u5339\u914d\u89c4\u5219\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u89c4\u5219\u6216\u8005\u53d6\u6d88\u3010\u662f\u5426\u5206\u5f55\u5339\u914d\u3011", (String)"PbdExecuteBillRelationSaveOp_0", (String)"scm-pbd-opplugin", (Object[])new Object[0])).append((CharSequence)entryDimCheckMessage);
                    }
                    if (checkMessage.length() <= 0) continue;
                    this.addFatalErrorMessage(extendedDataEntity, checkMessage.toString());
                }
            }

            public String getEntityKey() {
                return "entryentity";
            }
        });
    }
}

