/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.opplugin.multijoint;

import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.scm.common.helper.multisystemjoint.param.ScMultiPluginParamArgs;
import kd.scm.pbd.opplugin.multijoint.PbdDataExecuteSchemeOperateHelper;

public final class PbdDataExecuteSchemeSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("executetype");
        e.getFieldKeys().add("operatekey");
        e.getFieldKeys().add("executeinterface");
        e.getFieldKeys().add("executeservice");
        e.getFieldKeys().add("executeplugin");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
                    String servicetype;
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
                    String executetype = dataEntity.getString("executetype");
                    if ("operateevent".equals(executetype)) {
                        String operatekey = dataEntity.getString("operatekey");
                        String executeinterface = dataEntity.getString("executeinterface");
                        if (operatekey == null || operatekey.isEmpty() || executeinterface == null || executeinterface.isEmpty()) {
                            StringBuilder message = new StringBuilder();
                            DynamicProperty operatekeyPro = dynamicObjectType.getProperty("operatekey");
                            DynamicProperty executeinterfacePro = dynamicObjectType.getProperty("executeinterface");
                            message.append(operatekeyPro.getDisplayName().getLocaleValue()).append("\u3001").append(executeinterfacePro.getDisplayName().getLocaleValue()).append("\uff0c").append(ResManager.loadKDString((String)"\u7b49\u5b57\u6bb5\u6ca1\u6709\u5f55\u5165\u6570\u636e\u3002", (String)"PbdDataExecuteSchemeSaveOp_0", (String)"scm-pbd-opplugin", (Object[])new Object[0]));
                            this.addErrorMessage(extendedDataEntity, message.toString());
                        }
                    }
                    if (!"plugin".equals(servicetype = dataEntity.getString("executeservice.servicetype"))) continue;
                    StringBuilder pluginCheckMessage = new StringBuilder();
                    DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : entryentity) {
                        String executeServiceConfig = row.getString("executeserviceconfig");
                        try {
                            ScMultiPluginParamArgs scMultipluginParamArgs = (ScMultiPluginParamArgs)SerializationUtils.fromJsonString((String)executeServiceConfig, ScMultiPluginParamArgs.class);
                            TypesContainer.getOrRegister((String)scMultipluginParamArgs.getExecutePlugin());
                        }
                        catch (Exception ex) {
                            pluginCheckMessage.append(ResManager.loadKDString((String)"\u63d2\u4ef6\u90e8\u7f72\u68c0\u67e5\u5931\u8d25\uff0c{0}", (String)"PbdDataExecuteSchemeSaveOp_1", (String)"scm-pbd-opplugin", (Object[])new Object[]{ex.getLocalizedMessage()}));
                        }
                    }
                    if (pluginCheckMessage.length() <= 0) continue;
                    this.addErrorMessage(extendedDataEntity, pluginCheckMessage.toString());
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        PbdDataExecuteSchemeOperateHelper.assembleOpBizRule(e.getDataEntities());
    }
}

