/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.opplugin.validator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pbd.common.utils.PbdCreditUtils;

public class PbdServiceProgrammeValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null) {
            return;
        }
        if (dataEntities.length > 1) {
            for (ExtendedDataEntity dataEntitie : dataEntities) {
                this.addErrorMessage(dataEntitie, ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u64cd\u4f5c\u3002", (String)"PbdServiceProgrammeValidator_3", (String)"scm-pbd-opplugin", (Object[])new Object[0]));
            }
            return;
        }
        for (ExtendedDataEntity dataEntitie : dataEntities) {
            DynamicObject dataEntity = dataEntitie.getDataEntity();
            DynamicObject billentity = dataEntity.getDynamicObject("billentity");
            if (billentity == null) {
                this.addErrorMessage(dataEntitie, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u6216\u7ec4\u4ef6\u3002", (String)"PbdServiceProgrammeValidator_4", (String)"scm-pbd-opplugin", (Object[])new Object[0]));
                return;
            }
            Object billentityId = billentity.getPkValue();
            boolean validOrg = this.validOrg(dataEntity, billentityId);
            if (validOrg) continue;
            String billName = billentity.getString("name");
            String operatorName = dataEntity.getString("operatorname");
            this.addErrorMessage(dataEntitie, ResManager.loadResFormat((String)ResManager.loadKDString((String)"%1\u5728%2\u65f6\u7684\u63a5\u53e3\u8c03\u7528\u65b9\u6848\u5df2\u5b58\u5728\uff0c\u4e0d\u652f\u6301\u91cd\u590d\u3002", (String)"PbdServiceProgrammeValidator_5", (String)"scm-pbd-opplugin", (Object[])new Object[0]), (String)"PbdServiceProgrammeValidatorr_3", (String)"scm-pbd-opplugin", (Object[])new Object[]{billName, operatorName}));
            return;
        }
    }

    private boolean validOrg(DynamicObject dataEntity, Object billentityId) {
        Long curPkValue = (Long)dataEntity.getPkValue();
        String curOperator = dataEntity.getString("operator");
        Boolean curWholegroup = dataEntity.getBoolean("wholegroup");
        DynamicObjectCollection curOrgentity = dataEntity.getDynamicObjectCollection("orgentity");
        QFilter qf = new QFilter("enable", "=", (Object)"1");
        qf.and("operator", "=", (Object)curOperator);
        qf.and("billentity", "=", billentityId);
        qf.and("id", "!=", (Object)curPkValue);
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"pbd_service_programme", (String)"id,operator,billentity,wholegroup,orgentity.companyorg,orgentity.includesuborg", (QFilter[])new QFilter[]{qf});
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return true;
        }
        if (curWholegroup.booleanValue() && CollectionUtils.isEmpty((Collection)curOrgentity)) {
            return false;
        }
        HashSet allSubordinateOrgs = new HashSet();
        HashMap<Object, Boolean> orgIdIncludeSubOrgMap = new HashMap<Object, Boolean>(8);
        for (DynamicObject dy : dys) {
            boolean wholegroup = dy.getBoolean("wholegroup");
            Long companyorg = dy.getLong("orgentity.companyorg");
            if (wholegroup && (companyorg == null || companyorg == 0L)) {
                return false;
            }
            Boolean includesuborg = dy.getBoolean("orgentity.includesuborg");
            orgIdIncludeSubOrgMap.put(companyorg, includesuborg);
        }
        Set allOrgs = PbdCreditUtils.getAllSubordinateOrgs(orgIdIncludeSubOrgMap, (Boolean)Boolean.FALSE);
        if (!CollectionUtils.isEmpty((Collection)allOrgs)) {
            allSubordinateOrgs.addAll(allOrgs);
        }
        HashMap<Long, Boolean> entryOrgIdIncludeSubOrgMap = new HashMap<Long, Boolean>(8);
        Set curSubordinateOrgs = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)curOrgentity)) {
            for (DynamicObject dy : curOrgentity) {
                DynamicObject companyorg = dy.getDynamicObject("companyorg");
                Boolean includesuborg = dy.getBoolean("includesuborg");
                if (companyorg == null) continue;
                entryOrgIdIncludeSubOrgMap.put((Long)companyorg.getPkValue(), includesuborg);
            }
            curSubordinateOrgs = PbdCreditUtils.getAllSubordinateOrgs(entryOrgIdIncludeSubOrgMap, (Boolean)Boolean.FALSE);
        }
        if (!CollectionUtils.isEmpty(curSubordinateOrgs)) {
            boolean flag = Collections.disjoint(curSubordinateOrgs, allSubordinateOrgs);
            return flag;
        }
        return true;
    }
}

