/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.scm.pbd.domain.model.esconfig.EsAggResultConverter;
import kd.scm.pbd.domain.model.esconfig.EsConvertField;

public class DefaultEsAggResultConverter
implements EsAggResultConverter {
    private final DynamicObject esAggDyn;

    public DefaultEsAggResultConverter(DynamicObject esAggDyn) {
        this.esAggDyn = esAggDyn;
    }

    private List<EsConvertField> getEsAggOutputFields() {
        LinkedHashMap<Long, EsConvertField> resMap = new LinkedHashMap<Long, EsConvertField>();
        HashSet<Long> subFeildIdSet = new HashSet<Long>();
        DynamicObjectCollection outputEntryCol = this.esAggDyn.getDynamicObjectCollection("outputentry");
        for (DynamicObject outputEntry : outputEntryCol) {
            String outputFieldKey = outputEntry.getString("fieldkey");
            String outputFieldType = outputEntry.getString("fieldtype");
            boolean isArray = outputEntry.getBoolean("isarray");
            String fixedValue = outputEntry.getString("fixedvalue");
            String evalPath = outputEntry.getString("evalpath");
            long id = outputEntry.getLong("id");
            long pid = outputEntry.getLong("pid");
            ArrayList<EsConvertField> subEsConvertFields = new ArrayList<EsConvertField>();
            EsConvertField esConvertField = new EsConvertField(outputFieldKey, isArray, fixedValue, evalPath, outputFieldType, subEsConvertFields);
            resMap.put(id, esConvertField);
            if (pid == 0L) continue;
            EsConvertField parentEsAggOutPutField = (EsConvertField)resMap.get(pid);
            parentEsAggOutPutField.getSubEsConvertFields().add(esConvertField);
            subFeildIdSet.add(id);
        }
        subFeildIdSet.forEach(resMap::remove);
        return new ArrayList<EsConvertField>(resMap.values());
    }

    @Override
    public Map<String, Object> convert(Object input) {
        List<EsConvertField> esConvertFields = this.getEsAggOutputFields();
        return this.resolveInput(input, esConvertFields);
    }

    private Map<String, Object> resolveInput(Object input, List<EsConvertField> esConvertFields) {
        JSONObject res = new JSONObject();
        for (EsConvertField esConvertField : esConvertFields) {
            if (StringUtils.isNotEmpty((String)esConvertField.getFixedValue())) {
                res.put(esConvertField.getFieldKey(), (Object)esConvertField.getFixedValue());
                continue;
            }
            Object value = StringUtils.isNotEmpty((String)esConvertField.getEvalPath()) ? JSONPath.eval((Object)input, (String)esConvertField.getEvalPath()) : input;
            if (value == null) {
                res.put(esConvertField.getFieldKey(), null);
                continue;
            }
            if (!esConvertField.isArray() && value instanceof List) {
                throw new KDBizException(esConvertField.getFieldKey() + " require list but find object" + System.lineSeparator() + "input:" + input + System.lineSeparator() + "value:" + value + System.lineSeparator() + "fieldInfo:" + esConvertField);
            }
            if (esConvertField.isArray() && !(value instanceof List)) {
                throw new KDBizException(esConvertField.getFieldKey() + " require object but find list" + System.lineSeparator() + "input:" + input + System.lineSeparator() + "value:" + value + System.lineSeparator() + "fieldInfo:" + esConvertField);
            }
            if (!"STRUCT".equals(esConvertField.getFieldType())) {
                if (!StringUtils.isNotEmpty((String)esConvertField.getEvalPath())) continue;
                res.put(esConvertField.getFieldKey(), value);
                continue;
            }
            if (esConvertField.isArray()) {
                JSONArray structObjs = new JSONArray();
                for (int i = 0; i < ((List)value).size(); ++i) {
                    structObjs.add(this.resolveInput(((List)value).get(i), esConvertField.getSubEsConvertFields()));
                }
                res.put(esConvertField.getFieldKey(), (Object)structObjs);
                continue;
            }
            res.put(esConvertField.getFieldKey(), this.resolveInput(value, esConvertField.getSubEsConvertFields()));
        }
        return res;
    }
}

