/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig.agghandler;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.scm.pbd.domain.model.esconfig.EsAggHandler;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import org.elasticsearch.search.aggregations.AggregationBuilder;

abstract class AbstractEsAggHandler
implements EsAggHandler {
    private static final String SPLIT = ".";
    public static final String KEY_AS_STRING = "key";
    public static final String DOC_COUNT = "doc_count";
    public static final String BUCKETS = "buckets";
    public static final String AGG_ID = "agg_id";
    public static final String AGG_NAME = "agg_name";
    protected final DynamicObject esAggregationsDyn;
    protected EsConfig esConfig;

    public AbstractEsAggHandler(DynamicObject esAggregationsDyn, EsConfig esConfig) {
        this.esAggregationsDyn = esAggregationsDyn;
        this.esConfig = esConfig;
    }

    @Override
    public AggregationBuilder generateBuilder() {
        AggregationBuilder res = this.doGenerate();
        this.handleSubAggs(res);
        this.handleAfterGenerate(res);
        return res;
    }

    protected void handleAfterGenerate(AggregationBuilder aggregationBuilder) {
        HashMap<String, String> metaData = new HashMap<String, String>(aggregationBuilder.getMetaData());
        metaData.put(AGG_NAME, this.esAggregationsDyn.getString("name"));
        metaData.put(AGG_ID, this.esAggregationsDyn.getString("id"));
        aggregationBuilder.setMetaData(metaData);
    }

    abstract AggregationBuilder doGenerate();

    protected String getField(DynamicObject esAggregationsDyn) {
        DynamicObject fieldDyn = esAggregationsDyn.getDynamicObject("field");
        if (fieldDyn != null) {
            String path = esAggregationsDyn.getString("path");
            if (!StringUtils.isEmpty((String)path)) {
                return path + SPLIT + fieldDyn.getString("number");
            }
            return fieldDyn.getString("number");
        }
        return "";
    }

    protected void handleSubAggs(AggregationBuilder aggregationBuilder) {
        DynamicObjectCollection subAggRefDyns = this.esAggregationsDyn.getDynamicObjectCollection("subaggs");
        for (DynamicObject subAggRefDyn : subAggRefDyns) {
            DynamicObject subAggDyn = subAggRefDyn.getDynamicObject("fbasedataid");
            EsAggHandler esAggHandler = this.esConfig.getAggDynIdHandlerCacheMap().get(subAggDyn.getLong("id"));
            if (esAggHandler == null) continue;
            aggregationBuilder.subAggregation(esAggHandler.generateBuilder());
        }
    }
}

