/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig.agghandler;

import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.pbd.domain.model.esconfig.EsAggHandler;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import kd.scm.pbd.domain.model.esconfig.agghandler.AbstractEsAggHandler;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;

public class NestedEsAggHandler
extends AbstractEsAggHandler {
    private static final Log log = LogFactory.getLog((String)NestedEsAggHandler.class.getName());

    public NestedEsAggHandler(DynamicObject esAggregationsDyn, EsConfig esConfig) {
        super(esAggregationsDyn, esConfig);
    }

    @Override
    public AggregationBuilder doGenerate() {
        return AggregationBuilders.nested((String)this.esAggregationsDyn.getString("number"), (String)this.esAggregationsDyn.getString("path"));
    }

    @Override
    public Map<String, Object> resolveAggResult(Aggregation aggregation) {
        ParsedNested parsedNested = (ParsedNested)aggregation;
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(parsedNested.getMetaData());
        Aggregations subAggregations = parsedNested.getAggregations();
        res.put("doc_count", parsedNested.getDocCount());
        for (Aggregation subAgg : subAggregations) {
            EsAggHandler esAggHandler = this.esConfig.getTypeNameAggHanlderCacheMap().get(subAgg.getType());
            if (esAggHandler == null) continue;
            Map<String, Object> aggRes = esAggHandler.resolveAggResult(subAgg);
            res.put(subAgg.getName(), aggRes);
        }
        return res;
    }
}

