/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig.agghandler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.scm.pbd.domain.model.esconfig.EsAggHandler;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import kd.scm.pbd.domain.model.esconfig.agghandler.AbstractEsAggHandler;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.range.ParsedRange;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.range.RangeAggregationBuilder;

public class RangeEsAggHandler
extends AbstractEsAggHandler {
    private static final String FROM = "from";
    private static final String TO = "to";

    public RangeEsAggHandler(DynamicObject esAggregationsDyn, EsConfig esConfig) {
        super(esAggregationsDyn, esConfig);
    }

    @Override
    AggregationBuilder doGenerate() {
        String field = this.getField(this.esAggregationsDyn);
        RangeAggregationBuilder rangeAggregationBuilder = (RangeAggregationBuilder)AggregationBuilders.range((String)this.esAggregationsDyn.getString("number")).field(field);
        String params = this.esAggregationsDyn.getString("params");
        if (StringUtils.isNotBlank((CharSequence)"params")) {
            JSONArray ja = JSON.parseArray((String)params);
            for (int i = 0; i < ja.size(); ++i) {
                JSONObject jo = ja.getJSONObject(i);
                String key = jo.getString("key");
                Double from = jo.getDouble(FROM);
                Double to = jo.getDouble(TO);
                if (StringUtils.isNotBlank((CharSequence)key)) {
                    rangeAggregationBuilder.addRange(key, from.doubleValue(), to.doubleValue());
                    continue;
                }
                rangeAggregationBuilder.addRange(from.doubleValue(), to.doubleValue());
            }
        }
        return rangeAggregationBuilder;
    }

    @Override
    public Map<String, Object> resolveAggResult(Aggregation aggregation) {
        ParsedRange parsedRange = (ParsedRange)aggregation;
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(parsedRange.getMetaData());
        List buckets = parsedRange.getBuckets();
        ArrayList bucketMapList = new ArrayList(buckets.size());
        for (Range.Bucket bucket : buckets) {
            LinkedHashMap<String, Object> bucketInMap = new LinkedHashMap<String, Object>();
            bucketInMap.put("key", bucket.getKeyAsString());
            bucketInMap.put("doc_count", bucket.getDocCount());
            bucketInMap.put(FROM, bucket.getFrom());
            bucketInMap.put(TO, bucket.getTo());
            Aggregations aggregations = bucket.getAggregations();
            for (Aggregation subAgg : aggregations) {
                EsAggHandler subEsAggHandler = this.esConfig.getTypeNameAggHanlderCacheMap().get(subAgg.getType());
                if (subEsAggHandler == null) continue;
                Map<String, Object> subRes = subEsAggHandler.resolveAggResult(subAgg);
                bucketInMap.put(subAgg.getName(), subRes);
            }
            bucketMapList.add(bucketInMap);
        }
        res.put("buckets", bucketMapList);
        return res;
    }
}

