/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import kd.scm.pbd.domain.service.EsConfigService;
import kd.scm.pbd.domain.service.PbdDomainServiceFactory;

public class PbdEsDataSyncEventServicePlugin
implements IEventServicePlugin {
    private static final String TRIGGED_TIME = "trigged_time";
    private static final String TOTAL_COUNT = "total_count";
    private static final String TRIGGER_TYPE = "trigger_type";
    private static final String EVENTS = "events";
    private static final String TRIGGER_TYPE_EVENT = "event";
    private static final String PBD_DATA_SYNC_TRIGGER = "pbd_data_sync_trigger";

    public Object handleEvent(KDBizEvent evt) {
        Map<Object, DynamicObject> triggerMap = this.getTriggers((EntityEvent)evt);
        List<Long> esConfigIds = this.getEsConfigIds(triggerMap.values(), ((EntityEvent)evt).getOperation());
        for (Long esConfigId : esConfigIds) {
            EsConfig esConfig = new EsConfig(esConfigId);
            if ("delete".equals(((EntityEvent)evt).getOperation())) {
                PbdDomainServiceFactory.serviceOf(EsConfigService.class, esConfig.getRegion()).delDataByBusinessKeys(esConfig, ((EntityEvent)evt).getBusinesskeys());
                continue;
            }
            PbdDomainServiceFactory.serviceOf(EsConfigService.class, esConfig.getRegion()).dataSyncByBusinessKeys(esConfig, ((EntityEvent)evt).getBusinesskeys());
        }
        for (DynamicObject trigger : triggerMap.values()) {
            trigger.set(TRIGGED_TIME, (Object)TimeServiceHelper.now());
            trigger.set(TOTAL_COUNT, (Object)(trigger.getInt(TOTAL_COUNT) + 1));
        }
        SaveServiceHelper.save((DynamicObject[])triggerMap.values().toArray(new DynamicObject[0]));
        return null;
    }

    private List<Long> getEsConfigIds(Collection<DynamicObject> triggers, String op) {
        ArrayList<Long> res = new ArrayList<Long>();
        for (DynamicObject trigger : triggers) {
            String events = trigger.getString(EVENTS);
            if (!StringUtils.isNotBlank((CharSequence)events)) continue;
            for (String event : events.split(",")) {
                if (!StringUtils.equals((CharSequence)event, (CharSequence)op)) continue;
                res.add(trigger.getLong("esconfig.id"));
            }
        }
        return res;
    }

    private Map<Object, DynamicObject> getTriggers(EntityEvent evt) {
        QFilter filter = new QFilter("esconfig.indexentity", "=", (Object)evt.getEntityNumber()).and(TRIGGER_TYPE, "=", (Object)TRIGGER_TYPE_EVENT);
        return BusinessDataServiceHelper.loadFromCache((String)PBD_DATA_SYNC_TRIGGER, (String)"events,esconfig.id,trigged_time,total_count", (QFilter[])new QFilter[]{filter});
    }
}

