/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig.schedule;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import kd.scm.pbd.domain.service.EsConfigService;
import kd.scm.pbd.domain.service.PbdDomainServiceFactory;

public class PbdEsDataSyncTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PbdEsDataSyncTask.class);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        log.info("\u6267\u884c\u5168\u6587\u68c0\u7d22\u5e93\u6570\u636e\u540c\u6b65\u4efb\u52a1\u5f00\u59cb\uff1a" + params);
        DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)params.get("trigger"), (String)"pbd_data_sync_trigger");
        DynamicObject esConfigDyn = trigger.getDynamicObject("esconfig");
        if (esConfigDyn != null) {
            EsConfig esConfig = new EsConfig(esConfigDyn.getLong("id"));
            if (esConfig.isUpdate()) {
                PbdDomainServiceFactory.serviceOf(EsConfigService.class, esConfig.getRegion()).dataUpdate(esConfig);
            } else {
                PbdDomainServiceFactory.serviceOf(EsConfigService.class, esConfig.getRegion()).dataSync(esConfig);
            }
            log.info("\u6267\u884c\u5168\u6587\u68c0\u7d22\u5e93\u6570\u636e\u540c\u6b65\u4efb\u52a1\u7ed3\u675f");
            trigger.set("trigged_time", (Object)TimeServiceHelper.now());
            trigger.set("total_count", (Object)(trigger.getInt("total_count") + 1));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trigger});
        }
    }
}

