/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig.schedule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import kd.scm.pbd.domain.service.EsConfigService;
import kd.scm.pbd.domain.service.PbdDomainServiceFactory;

public class PbdEsInspectionTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PbdEsInspectionTask.class);
    private static final String PBD_DATA_SYNC_TRIGGER = "pbd_data_sync_trigger";

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        log.info("\u6267\u884c\u5168\u6587\u68c0\u7d22\u5e93\u5de1\u68c0\u4efb\u52a1\u5f00\u59cb\uff1a" + params);
        this.upgradeES7();
        this.resetDataSyncTrigger();
        this.checkEsConfig();
        DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)params.get("trigger"), (String)PBD_DATA_SYNC_TRIGGER);
        trigger.set("trigged_time", (Object)TimeServiceHelper.now());
        trigger.set("total_count", (Object)(trigger.getInt("total_count") + 1));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trigger});
        log.info("\u6267\u884c\u5168\u6587\u68c0\u7d22\u5e93\u5de1\u68c0\u4efb\u52a1\u7ed3\u675f");
    }

    private void upgradeES7() {
        QFilter qFilter = new QFilter("job.id", "=", (Object)"4CL+MS4WALDU").and("status", "=", (Object)"COMPLETED");
        if (!QueryServiceHelper.exists((String)"sch_tasklog_details", (QFilter[])qFilter.toArray())) {
            String jobId = "4CL+MS4WALDU";
            JobInfo jobInfo = ScheduleService.getInstance().getObjectFactory().getJobDao().get(jobId);
            jobInfo.setScheduleId("4CL04BH7NQFU");
            JobClient.dispatch((JobInfo)jobInfo);
        }
    }

    private void resetDataSyncTrigger() {
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("trigger_type", "=", (Object)"event");
        Map triggerDynMap = BusinessDataServiceHelper.loadFromCache((String)PBD_DATA_SYNC_TRIGGER, (QFilter[])new QFilter[]{filter});
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        try {
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"disable", (String)PBD_DATA_SYNC_TRIGGER, (Object[])triggerDynMap.keySet().toArray(), (OperateOption)option));
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"enable", (String)PBD_DATA_SYNC_TRIGGER, (Object[])triggerDynMap.keySet().toArray(), (OperateOption)option));
        }
        catch (Exception e) {
            log.warn("resetDataSyncTrigger\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private void checkEsConfig() {
        block21: {
            HashMap<Object, String> id2indexKeyListMap = new HashMap<Object, String>();
            try (DataSet configDs = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_esconfig", (String)"id,indexkey", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")}, null);){
                for (Row row : configDs) {
                    id2indexKeyListMap.put(row.get("id"), row.getString("indexkey"));
                }
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult initIndexOpResult = null;
            try {
                initIndexOpResult = OperationServiceHelper.executeOperate((String)"initmapping", (String)"pbd_esconfig", (Object[])id2indexKeyListMap.keySet().toArray(), (OperateOption)option);
                CommonUtil.check((OperationResult)initIndexOpResult);
            }
            catch (Exception e) {
                if (initIndexOpResult == null) break block21;
                HashMap indexKey2ConfigIdListMap = new HashMap(id2indexKeyListMap.size());
                HashSet needReInitIndexKeySet = new HashSet();
                for (Map.Entry entry : id2indexKeyListMap.entrySet()) {
                    List list = indexKey2ConfigIdListMap.getOrDefault(entry.getValue(), new ArrayList());
                    list.add(entry.getKey());
                    indexKey2ConfigIdListMap.put(entry.getValue(), list);
                    if (initIndexOpResult.getSuccessPkIds().contains(entry.getKey())) continue;
                    needReInitIndexKeySet.add(entry.getValue());
                }
                ArrayList needReInitIndexIdList = new ArrayList(id2indexKeyListMap.size());
                for (Map.Entry entry : indexKey2ConfigIdListMap.entrySet()) {
                    if (!needReInitIndexKeySet.contains(entry.getKey())) continue;
                    needReInitIndexIdList.addAll((Collection)entry.getValue());
                }
                log.info("\u53d1\u73b0\u5f02\u5e38\u7d22\u5f15\u6807\u8bc6\uff1a" + needReInitIndexKeySet);
                log.info("\u6267\u884c\u5220\u9664\u7d22\u5f15\uff1a" + needReInitIndexIdList);
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delindex", (String)"pbd_esconfig", (Object[])needReInitIndexIdList.toArray(), (OperateOption)option);
                CommonUtil.check((OperationResult)operationResult);
                log.info("\u6267\u884c\u7d22\u5f15\u521d\u59cb\u5316\uff1a" + needReInitIndexIdList);
                initIndexOpResult = OperationServiceHelper.executeOperate((String)"initmapping", (String)"pbd_esconfig", (Object[])needReInitIndexIdList.toArray(), (OperateOption)option);
                CommonUtil.check((OperationResult)initIndexOpResult);
                log.info("\u6267\u884c\u7d22\u5f15\u6570\u636e\u540c\u6b65\uff1a" + needReInitIndexIdList);
                for (Object configId : needReInitIndexIdList) {
                    EsConfig esConfig = new EsConfig(Long.valueOf(String.valueOf(configId)));
                    try {
                        PbdDomainServiceFactory.serviceOf(EsConfigService.class, esConfig.getRegion()).dataSync(esConfig);
                    }
                    catch (Exception exception) {
                        log.warn("\u6570\u636e\u540c\u6b65\u5931\u8d25\uff1a" + configId + exception.getMessage());
                    }
                }
            }
        }
    }
}

