/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig.schedule;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.CommonUtil;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import kd.scm.pbd.domain.service.EsConfigService;
import kd.scm.pbd.domain.service.PbdDomainServiceFactory;

public class PbdEsUpgradeTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PbdEsUpgradeTask.class);
    private static final String PBD_DATA_SYNC_TRIGGER = "pbd_data_sync_trigger";

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        log.info("\u6267\u884c\u5168\u6587\u68c0\u7d22\u5e93\u7d22\u5f15\u91cd\u5efa\u4efb\u52a1\u5f00\u59cb");
        this.resetDataSyncTrigger();
        this.checkEsConfig();
        log.info("\u6267\u884c\u5168\u6587\u68c0\u7d22\u5e93\u7d22\u5f15\u91cd\u5efa\u4efb\u52a1\u7ed3\u7b97");
    }

    private void resetDataSyncTrigger() {
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("trigger_type", "=", (Object)"event");
        Map triggerDynMap = BusinessDataServiceHelper.loadFromCache((String)PBD_DATA_SYNC_TRIGGER, (QFilter[])new QFilter[]{filter});
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        try {
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"disable", (String)PBD_DATA_SYNC_TRIGGER, (Object[])triggerDynMap.keySet().toArray(), (OperateOption)option));
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"enable", (String)PBD_DATA_SYNC_TRIGGER, (Object[])triggerDynMap.keySet().toArray(), (OperateOption)option));
        }
        catch (Exception e) {
            log.warn("resetDataSyncTrigger\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private void checkEsConfig() {
        ArrayList<Object> needReInitIndexIdList = new ArrayList<Object>(64);
        try (DataSet configDs = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_esconfig", (String)"id,indexkey", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")}, null);){
            for (Row row : configDs) {
                needReInitIndexIdList.add(row.get("id"));
            }
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        log.info("\u6267\u884c\u5220\u9664\u7d22\u5f15\uff1a" + needReInitIndexIdList);
        OperationResult initIndexOpResult = null;
        OperationResult delOpResult = OperationServiceHelper.executeOperate((String)"delindex", (String)"pbd_esconfig", (Object[])needReInitIndexIdList.toArray(), (OperateOption)option);
        CommonUtil.check((OperationResult)delOpResult);
        log.info("\u6267\u884c\u7d22\u5f15\u521d\u59cb\u5316\uff1a" + needReInitIndexIdList);
        initIndexOpResult = OperationServiceHelper.executeOperate((String)"initmapping", (String)"pbd_esconfig", (Object[])needReInitIndexIdList.toArray(), (OperateOption)option);
        CommonUtil.check((OperationResult)initIndexOpResult);
        log.info("\u6267\u884c\u7d22\u5f15\u6570\u636e\u540c\u6b65\uff1a" + needReInitIndexIdList);
        for (Object e : needReInitIndexIdList) {
            EsConfig esConfig = new EsConfig(Long.valueOf(String.valueOf(e)));
            try {
                PbdDomainServiceFactory.serviceOf(EsConfigService.class, esConfig.getRegion()).dataSync(esConfig);
            }
            catch (Exception exception) {
                log.warn("\u6570\u636e\u540c\u6b65\u5931\u8d25\uff1a" + e + exception.getMessage());
            }
        }
    }
}

