/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.service.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.fulltext.common.util.PinYinUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.es.storage.BizEsErrorCode;
import kd.scm.common.es.storage.EsBatchValue;
import kd.scm.common.es.storage.EsDataType;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.es.storage.EsMappingProperty;
import kd.scm.common.es.storage.EsPropertyValue;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import kd.scm.pbd.domain.model.esconfig.EsSyncResult;
import kd.scm.pbd.domain.service.EsConfigService;
import kd.scm.pbd.domain.service.EsMappingIndexsBuilderService;
import kd.scm.pbd.domain.service.PbdDomainServiceFactory;

public class EsConfigServiceImpl
implements EsConfigService {
    private static final Log log = LogFactory.getLog((String)EsConfigServiceImpl.class.getName());
    private static final String BUSINESSKEY = "businesskey";

    @Override
    public void initIndex(EsConfig esConfig) {
        try {
            String indexName = esConfig.getIndexName();
            List<EsMappingProperty> esMappingIndexs = PbdDomainServiceFactory.serviceOf(EsMappingIndexsBuilderService.class, esConfig.getRegion()).build(esConfig);
            HashMap<String, Object> settingsMap = new HashMap<String, Object>(CommonUtil.getIndexSettings((String)esConfig.getRegion()));
            String analysisStr = "{\n      \"analyzer\": {\n        \"ngram_analyzer\": {\n          \"tokenizer\": \"ngram_tokenizer\"\n        }\n      },\n      \"tokenizer\": {\n        \"ngram_tokenizer\": {\n          \"type\": \"ngram\",\n          \"min_gram\": 2,\n          \"max_gram\": 10,\n          \"token_chars\": [\n            \"letter\",\n            \"digit\"\n          ]\n        }\n      }\n    }";
            settingsMap.put("analysis", JSON.parse((String)analysisStr));
            settingsMap.put("max_ngram_diff", 8);
            esConfig.getEsStorage().createIndex(esConfig.getRegion(), indexName, settingsMap);
            this.handleArrayAndEnum2Keyword(esMappingIndexs);
            esConfig.getEsStorage().addMappingIndex(indexName, "_doc", esMappingIndexs.toArray(new EsMappingProperty[0]));
        }
        catch (Exception e) {
            log.warn("\u521d\u59cb\u5316\u7d22\u5f15\u5931\u8d25\uff1a" + ExceptionUtil.getStackTrace((Throwable)e));
            throw new KDBizException((Throwable)e, BizEsErrorCode.esException, new Object[]{e.getMessage()});
        }
    }

    @Override
    public Map<String, Object> getIndexMapping(EsConfig esConfig) {
        return esConfig.getEsStorage().getIndexMapping(new String[]{esConfig.getIndexName()});
    }

    private void handleArrayAndEnum2Keyword(List<EsMappingProperty> esMappingIndexs) {
        for (EsMappingProperty esMappingProperty : esMappingIndexs) {
            if (esMappingProperty.getDataType() == EsDataType.NESTED) {
                this.handleArrayAndEnum2Keyword(esMappingProperty.getNests());
            }
            if (esMappingProperty.getDataType() != EsDataType.ARRAY && esMappingProperty.getDataType() != EsDataType.COMBO) continue;
            esMappingProperty.setDataType(EsDataType.KEYWORD);
        }
    }

    @Override
    public void delIndex(EsConfig esConfig) {
        esConfig.getEsStorage().deleteIndex(esConfig.getIndexName());
    }

    @Override
    public EsSyncResult dataSync(EsConfig esConfig) {
        return this.sync(esConfig, true);
    }

    @Override
    public EsSyncResult dataSyncByBusinessKeys(EsConfig esConfig, List<String> businessKeys) {
        ArrayList<QFilter> filter = new ArrayList<QFilter>();
        filter.add(new QFilter("id", "in", businessKeys.stream().map(Long::valueOf).collect(Collectors.toSet())));
        return this.sync(esConfig, true, filter.toArray(new QFilter[0]));
    }

    @Override
    public void delDataByBusinessKeys(EsConfig esConfig, List<String> businessKeys) {
        log.info("kd.scm.pbd.domain.service.impl.EsConfigServiceImpl.delDataByBusinessKeys.businessKeys:" + businessKeys);
        if (esConfig.isUpdate()) {
            List<EsMappingProperty> esMappingPropertys = esConfig.getEsMappingPropertys();
            ArrayList<EsPropertyValue> upFields = new ArrayList<EsPropertyValue>(esMappingPropertys.size());
            for (EsMappingProperty esMappingProperty : esMappingPropertys) {
                if (esMappingProperty.isPrimaryKey()) continue;
                upFields.add(new EsPropertyValue(esMappingProperty.getPropertyName(), null));
            }
            this.updateByQuery(esConfig, Collections.singletonList(new EsFilterField(BUSINESSKEY, "in", businessKeys.toArray())), upFields.toArray(new EsPropertyValue[0]));
        } else {
            esConfig.getEsStorage().bulkDelete(esConfig.getIndexName(), "_doc", businessKeys);
        }
    }

    private EsSyncResult sync(EsConfig esConfig, boolean upsert) {
        return this.sync(esConfig, upsert, esConfig.getFilter().toArray(new QFilter[0]));
    }

    private EsSyncResult sync(EsConfig esConfig, boolean upsert, QFilter[] filters) {
        if (esConfig.isHandleByParent()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u914d\u7f6e\u6570\u636e\u540c\u6b65\u5f00\u542f\u4e86\u7236\u914d\u7f6e\u89e6\u53d1\uff0c\u4e0d\u5141\u8bb8\u5355\u72ec\u89e6\u53d1\u6570\u636e\u540c\u6b65\u3002", (String)"EsConfigServiceImpl_0", (String)"scm-pbd-business", (Object[])new Object[0]));
        }
        return this.batchSyn(esConfig, upsert, filters, null);
    }

    private EsSyncResult batchSyn(EsConfig esConfig, boolean upsert, QFilter[] filters, Map<Object, List<String>> childMappingValueAndParentIdsMap) {
        EsSyncResult res = new EsSyncResult();
        ORM orm = ORM.create();
        log.info("kd.scm.pbd.domain.service.impl.EsConfigServiceImpl.batchSave.filters:" + Arrays.toString(filters));
        String selectFields = esConfig.getSelectFields();
        log.info("kd.scm.pbd.domain.service.impl.EsConfigServiceImpl.batchSave.selectFields:" + selectFields);
        List<EsMappingProperty> esMappingPropertys = esConfig.getEsMappingPropertys();
        Map<Object, Object> lastIdPropertyValuesMap = new HashMap();
        Map lastEsBatchValueMap = new HashMap();
        int curPage = 0;
        int total = 0;
        boolean isContinue = true;
        while (isContinue) {
            LinkedHashMap<String, Map<String, EsPropertyValue>> idPropertyValuesMapForChild;
            LinkedHashMap<String, EsBatchValue> esBatchValueMap = new LinkedHashMap<String, EsBatchValue>(lastEsBatchValueMap);
            try (DataSet dataSet = this.getDataSet(esConfig, filters, orm, selectFields, curPage);){
                LinkedHashMap<String, Map<String, EsPropertyValue>> idPropertyValuesMap = new LinkedHashMap<String, Map<String, EsPropertyValue>>(lastIdPropertyValuesMap);
                int curPageSize = 0;
                for (Row row : dataSet) {
                    ++curPageSize;
                    for (EsMappingProperty esMappingProperty : esMappingPropertys) {
                        this.fillEsPropertyValues(idPropertyValuesMap, row, esMappingProperty, esConfig);
                    }
                    EsBatchValue esBatchValue = (EsBatchValue)esBatchValueMap.get(row.getString(esConfig.getPrimaryKeyField()));
                    if (esBatchValue != null) {
                        esBatchValueMap.put(row.getString(esConfig.getPrimaryKeyField()), this.mergeEsBatchValue(esBatchValue, new ArrayList<EsPropertyValue>(idPropertyValuesMap.get(row.getString(esConfig.getPrimaryKeyField())).values())));
                        continue;
                    }
                    esBatchValueMap.put(row.getString(esConfig.getPrimaryKeyField()), new EsBatchValue((Object)row.getString(esConfig.getPrimaryKeyField()), idPropertyValuesMap.get(row.getString(esConfig.getPrimaryKeyField())).values().toArray(new EsPropertyValue[0])));
                }
                if (curPageSize < 5000) {
                    isContinue = false;
                }
                log.info("kd.scm.pbd.domain.service.impl.EsConfigServiceImpl.save.curPage:" + curPage + System.lineSeparator() + "size:" + esBatchValueMap.size());
                if (isContinue) {
                    lastIdPropertyValuesMap = this.getAndRemoveLast(idPropertyValuesMap);
                    lastEsBatchValueMap = this.getAndRemoveLast(esBatchValueMap);
                }
                ++curPage;
                total += esBatchValueMap.size();
                idPropertyValuesMapForChild = idPropertyValuesMap;
            }
            EsBatchValue[] esBatchValues = this.getEsBatchValues(esBatchValueMap, childMappingValueAndParentIdsMap);
            if (upsert) {
                esConfig.getEsStorage().batchSave(esConfig.getIndexName(), "_doc", esBatchValues);
                res.addSuccess(esBatchValues.length);
            } else {
                try {
                    esConfig.getEsStorage().batchUpdate(esConfig.getIndexName(), "_doc", esBatchValues);
                    res.addSuccess(esBatchValues.length);
                }
                catch (KDException e) {
                    if (e.getMessage() != null && e.getMessage().length() > 50) {
                        res.addErrorInfo("curPage:" + curPage + "," + e.getMessage().substring(0, 50));
                    }
                    res.addErrorInfo("curPage:" + curPage + "," + e.getMessage());
                }
            }
            this.syncChildEsData(esConfig, idPropertyValuesMapForChild, upsert);
        }
        res.setTotal(total);
        return res;
    }

    private DataSet getDataSet(EsConfig esConfig, QFilter[] filters, ORM orm, String selectFields, int curPage) {
        return orm.queryDataSet(this.getClass().getName(), esConfig.getIndexEntityNumber(), selectFields, filters, esConfig.getPrimaryKeyField(), curPage * 5000, 5000);
    }

    private EsBatchValue[] getEsBatchValues(LinkedHashMap<String, EsBatchValue> esBatchValueMap, Map<Object, List<String>> childMappingValueAndParentIdsMap) {
        if (childMappingValueAndParentIdsMap == null) {
            return esBatchValueMap.values().toArray(new EsBatchValue[0]);
        }
        ArrayList esBatchValues = new ArrayList(esBatchValueMap.size());
        esBatchValueMap.forEach((childId, esBatchValue) -> {
            List parentIds = (List)childMappingValueAndParentIdsMap.get(childId);
            if (!CollectionUtils.isEmpty((Collection)parentIds)) {
                for (String parentId : parentIds) {
                    esBatchValues.add(new EsBatchValue((Object)parentId, esBatchValue.getValues()));
                }
            }
        });
        return esBatchValues.toArray(new EsBatchValue[0]);
    }

    private EsSyncResult syncChildEsData(EsConfig esConfig, Map<String, Map<String, EsPropertyValue>> idPropertyValuesMap, boolean upsert) {
        EsSyncResult res = new EsSyncResult();
        QFilter qFilter = new QFilter("parentesconfig", "=", (Object)esConfig.getConfigId());
        qFilter.and("ishandlebyparent", "=", (Object)true);
        qFilter.and("status", "=", (Object)BillStatusEnum.AUDIT.getVal());
        qFilter.and("enable", "=", (Object)"1");
        Map childEsConfigs = BusinessDataServiceHelper.loadFromCache((String)"pbd_esconfig", (QFilter[])qFilter.toArray());
        if (childEsConfigs != null && !childEsConfigs.isEmpty()) {
            childEsConfigs.forEach((id, dyn) -> this.createChildEcBatchValueAndSyncParent((DynamicObject)dyn, idPropertyValuesMap, upsert));
        }
        return res;
    }

    private EsSyncResult createChildEcBatchValueAndSyncParent(DynamicObject dynamicObject, Map<String, Map<String, EsPropertyValue>> idPropertyValuesMap, boolean upsert) {
        EsSyncResult res = new EsSyncResult();
        EsConfig esConfig = new EsConfig(dynamicObject);
        String esMapping = esConfig.getEsPrimaryKeyField();
        ArrayList values = new ArrayList(idPropertyValuesMap.size());
        HashMap<Object, List<String>> childMappingValueAndParentIdsMap = new HashMap<Object, List<String>>(idPropertyValuesMap.size());
        idPropertyValuesMap.forEach((parentId, propertyValuesMap) -> {
            EsPropertyValue propertyValue = (EsPropertyValue)propertyValuesMap.get(esMapping);
            if (propertyValue != null && propertyValue.getValue() != null) {
                values.add(propertyValue.getValue());
                List parentIds = childMappingValueAndParentIdsMap.computeIfAbsent(propertyValue.getValue().toString(), k -> new ArrayList());
                parentIds.add(parentId);
            }
        });
        if (!values.isEmpty()) {
            QFilter childQFilter = new QFilter(esConfig.getPrimaryKeyField(), "in", values);
            res = this.batchSyn(esConfig, upsert, childQFilter.toArray(), childMappingValueAndParentIdsMap);
        }
        return res;
    }

    @Override
    public EsSyncResult dataUpdate(EsConfig esConfig) {
        return this.sync(esConfig, false);
    }

    @Override
    public Object getIndexSetting(EsConfig esConfig) {
        return esConfig.getEsStorage().getIndexSettings(new String[]{esConfig.getIndexName()}).get(esConfig.getIndexName());
    }

    @Override
    public void updateIndexSetting(EsConfig esConfig, Map<String, Object> settingsMap) {
        esConfig.getEsStorage().updateIndexSetting(esConfig.getRegion(), esConfig.getIndexName(), settingsMap);
    }

    @Override
    public void updateIndexDoc(EsConfig esConfig, List<EsBatchValue> esBatchValues) {
        esConfig.getEsStorage().batchUpdate(esConfig.getIndexName(), "_doc", esBatchValues.toArray(new EsBatchValue[0]));
    }

    @Override
    public void updateByQuery(EsConfig esConfig, List<EsFilterField> filters, EsPropertyValue[] upFields) {
        esConfig.getEsStorage().updateByQuery(esConfig.getIndexName(), "_doc", filters, upFields);
    }

    private <T> Map<String, T> getAndRemoveLast(Map<String, T> idPropertyValuesMap) {
        HashMap<String, T> res = new HashMap<String, T>();
        String lastKey = "";
        for (Map.Entry<String, T> entry : idPropertyValuesMap.entrySet()) {
            lastKey = entry.getKey();
        }
        res.put(lastKey, idPropertyValuesMap.remove(lastKey));
        return res;
    }

    private EsBatchValue mergeEsBatchValue(EsBatchValue esBatchValue, List<EsPropertyValue> propertyValues) {
        for (EsPropertyValue esPropertyValue : esBatchValue.getValues()) {
            if (esPropertyValue.getDataType() != EsDataType.ARRAY) continue;
            Set value = (Set)esPropertyValue.getValue();
            for (EsPropertyValue ortherPropertyValue : propertyValues) {
                if (!esPropertyValue.getPropertyName().equals(ortherPropertyValue.getPropertyName())) continue;
                value.addAll((Collection)ortherPropertyValue.getValue());
            }
        }
        return esBatchValue;
    }

    private void fillEsPropertyValues(Map<String, Map<String, EsPropertyValue>> idPropertyValueMap, Row row, EsMappingProperty esMappingProperty, EsConfig esConfig) {
        EsPropertyValue esPropertyValue;
        Map esPropertyValueMap = idPropertyValueMap.getOrDefault(row.getString(esConfig.getPrimaryKeyField()), new HashMap());
        if (StringUtils.isBlank((CharSequence)esMappingProperty.getMappingField())) {
            esPropertyValue = new EsPropertyValue(esMappingProperty.getPropertyName(), esMappingProperty.getDataType(), (Object)esMappingProperty.getDefaultValue());
        } else if (esMappingProperty.getDataType() == EsDataType.NESTED) {
            esPropertyValue = esPropertyValueMap.getOrDefault(esMappingProperty.getPropertyName(), new EsPropertyValue(esMappingProperty.getPropertyName(), esMappingProperty.getDataType(), row.get(esMappingProperty.getMappingField())));
            HashMap<String, Map<String, EsPropertyValue>> nestIdEsPropertyValueMap = new HashMap<String, Map<String, EsPropertyValue>>(esMappingProperty.getNests().size() << 2);
            for (EsMappingProperty nestEsMappingProperty : esMappingProperty.getNests()) {
                this.fillEsPropertyValues(nestIdEsPropertyValueMap, row, nestEsMappingProperty, esConfig);
            }
            ArrayList<EsPropertyValue> nestEsPropertyValues = new ArrayList<EsPropertyValue>();
            nestIdEsPropertyValueMap.forEach((k, v) -> nestEsPropertyValues.addAll(v.values()));
            if (this.nestValueNotExist(nestEsPropertyValues, esPropertyValue.nests)) {
                esPropertyValue.nests.add(nestEsPropertyValues);
            }
        } else if (esMappingProperty.getDataType() == EsDataType.ARRAY) {
            LinkedHashSet<Object> value = new LinkedHashSet<Object>();
            value.add(row.get(esMappingProperty.getMappingField()));
            esPropertyValue = new EsPropertyValue(esMappingProperty.getPropertyName(), esMappingProperty.getDataType(), value);
        } else if (esMappingProperty.getDataType() == EsDataType.COMBO) {
            esPropertyValue = new EsPropertyValue(esMappingProperty.getPropertyName(), esMappingProperty.getDataType(), row.get(esMappingProperty.getMappingField()));
            EsPropertyValue enumNameValue = new EsPropertyValue(esMappingProperty.getPropertyName() + "_name", esMappingProperty.getDataType(), (Object)esConfig.getComboName(esMappingProperty.getMappingField(), row.getString(esMappingProperty.getMappingField())));
            esPropertyValueMap.put(esMappingProperty.getPropertyName() + "_name", enumNameValue);
        } else if (esMappingProperty.isWithPinyin()) {
            esPropertyValue = new EsPropertyValue(esMappingProperty.getPropertyName(), esMappingProperty.getDataType(), row.get(esMappingProperty.getMappingField()));
            try {
                if (StringUtils.isNotBlank((Object)row.get(esMappingProperty.getMappingField()))) {
                    EsPropertyValue pyValue = new EsPropertyValue(esMappingProperty.getPropertyName() + "_py", EsDataType.ARRAY, Arrays.stream(PinYinUtil.getMergePinyin((String)row.getString(esMappingProperty.getMappingField()))).collect(Collectors.toSet()));
                    esPropertyValueMap.put(esMappingProperty.getPropertyName() + "_py", pyValue);
                }
            }
            catch (Exception e) {
                log.error(ExceptionUtil.getStackTrace((Throwable)e));
            }
        } else {
            esPropertyValue = new EsPropertyValue(esMappingProperty.getPropertyName(), esMappingProperty.getDataType(), row.get(esMappingProperty.getMappingField()));
        }
        esPropertyValueMap.put(esMappingProperty.getPropertyName(), esPropertyValue);
        idPropertyValueMap.put(row.getString(esConfig.getPrimaryKeyField()), esPropertyValueMap);
    }

    private boolean nestValueNotExist(List<EsPropertyValue> nestEsPropertyValues, List<Object> nests) {
        HashMap<String, Object> map = new HashMap<String, Object>(nestEsPropertyValues.size() << 2);
        for (EsPropertyValue esPropertyValue : nestEsPropertyValues) {
            map.put(esPropertyValue.getPropertyName(), esPropertyValue.getValue());
        }
        for (Object nest : nests) {
            if (!(nest instanceof List)) continue;
            List esPropertyValues = (List)nest;
            int count = 0;
            for (EsPropertyValue esPropertyValue : esPropertyValues) {
                if (esPropertyValue.getValue() == null && map.get(esPropertyValue.getPropertyName()) == null) {
                    ++count;
                    continue;
                }
                if (!esPropertyValue.getValue().equals(map.get(esPropertyValue.getPropertyName()))) continue;
                ++count;
            }
            if (count != map.size()) continue;
            return false;
        }
        return true;
    }
}

