/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.address;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pbd.common.entity.AddressTreeNode;
import kd.scm.pbd.common.enums.AddressMatchEnum;
import kd.scm.pbd.service.address.IAddressMatcher;

public abstract class AbstractAddressMatcher
implements IAddressMatcher {
    public static final List<Long> DIRECT_PROVINCE_ID_LIST = Arrays.asList(123L, 141L, 2675L, 3134L);
    public static final List<String> DIRECT_PROVINCE_NUM_LIST = Arrays.asList("00123", "00141", "002675", "003134");
    protected static final int BDADDRCOMPARECOUNT = 3500;
    private static final Log logger = LogFactory.getLog(AbstractAddressMatcher.class);

    public abstract boolean specialRuleMatch(AddressTreeNode var1, AddressTreeNode var2, boolean var3);

    public abstract void handleAfterBuildNodeResult(List<AddressTreeNode> var1, boolean var2);

    public abstract QFilter getBdAddrFilter();

    public void handleSpecialAddress(AddressTreeNode node, DynamicObject dyo, boolean isMatchSource) {
    }

    public void match(List<AddressTreeNode> bdAddressTreeNodeList, List<AddressTreeNode> ecAddressTreeNodeList, AtomicInteger successNum, boolean bdAddrVersion) {
        block0: for (AddressTreeNode bdNode : bdAddressTreeNodeList) {
            for (AddressTreeNode ecNode : ecAddressTreeNodeList) {
                if (bdNode.isMatch(ecNode) || this.specialRuleMatch(bdNode, ecNode, bdAddrVersion)) {
                    if (bdAddrVersion) {
                        if (!DIRECT_PROVINCE_ID_LIST.contains(bdNode.getId()) || bdNode.getLevel() != 2) {
                            successNum.getAndIncrement();
                        }
                    } else {
                        successNum.getAndIncrement();
                    }
                    bdNode.setMatchStatus(AddressMatchEnum.MATCH_SUCCESS.getVal());
                    bdNode.setMatchAddressId(ecNode.getId());
                    bdNode.setMatchLongnumber(ecNode.getLongnumber());
                    if (!bdNode.hasChilds() || !ecNode.hasChilds()) continue block0;
                    this.match(bdNode.getChildAddressList(), ecNode.getChildAddressList(), successNum, bdAddrVersion);
                    continue block0;
                }
                bdNode.setMatchStatus(AddressMatchEnum.MATCH_FAILD.getVal());
            }
        }
    }

    @Override
    public List<AddressTreeNode> parseAddressTreeNodeList(DynamicObjectCollection dyoCol, boolean isMatchSource) {
        ArrayList<AddressTreeNode> resultList = new ArrayList<AddressTreeNode>(32);
        if (CollectionUtils.isEmpty((Collection)dyoCol)) {
            return resultList;
        }
        HashMap<Long, AddressTreeNode> cacheMap = new HashMap<Long, AddressTreeNode>(256);
        boolean bdAddreVersion = false;
        if (isMatchSource && this.getValidAddrCount() < 3500) {
            bdAddreVersion = true;
        }
        int topLevel = 0;
        for (int i = 0; i < dyoCol.size(); ++i) {
            DynamicObject dyo = (DynamicObject)dyoCol.get(i);
            Long id = dyo.getLong("id");
            Long pId = dyo.getLong("parent.id");
            int level = dyo.getInt("level");
            if (i == 0) {
                topLevel = level;
            }
            AddressTreeNode node = new AddressTreeNode(id.longValue(), pId.longValue(), dyo.getString("name"), dyo.getString("longnumber"), level);
            if (isMatchSource && bdAddreVersion) {
                node.setNewVersion(true);
            }
            this.handleSpecialAddress(node, dyo, isMatchSource);
            cacheMap.put(id, node);
            if (level == topLevel) {
                resultList.add(node);
                continue;
            }
            if (null != cacheMap.get(pId)) {
                ((AddressTreeNode)cacheMap.get(pId)).addChildAddress(node);
                continue;
            }
            logger.info("@@@parseAddressTreeNodeList:\u6570\u636e\u6e90-->" + isMatchSource + ",\u95ee\u9898\u6570\u636eID-->" + pId);
        }
        this.handleAfterBuildNodeResult(resultList, isMatchSource);
        return resultList;
    }

    @Override
    public DynamicObjectCollection getEcAddressDyoCol(String currentNodeId, String ecType) {
        QFilter emalAddressFilter = new QFilter("emaltype", "=", (Object)ecType);
        if (!this.isRootId(currentNodeId)) {
            String addrRelSelectFields = "id,longnumber";
            DynamicObject currentNodeRel = QueryServiceHelper.queryOne((String)"pbd_maladdressrel", (String)addrRelSelectFields, (QFilter[])new QFilter[]{new QFilter("addressid", "=", (Object)Long.valueOf(currentNodeId)), emalAddressFilter});
            if (currentNodeRel != null) {
                emalAddressFilter.and("longnumber", "like", (Object)(currentNodeRel.getString("longnumber") + "%"));
            }
        }
        return QueryServiceHelper.query((String)"pbd_emaladdress", (String)"id,name,level,longnumber,parent.id,parent.name", (QFilter[])new QFilter[]{emalAddressFilter}, (String)"level,longnumber asc");
    }

    @Override
    public DynamicObjectCollection getBdAdmindivisionCol(String currentNodeId) {
        QFilter filter = this.getBdAddrFilter();
        if (this.isRootId(currentNodeId)) {
            return QueryServiceHelper.query((String)"bd_admindivision", (String)"id,number,name,level,isleaf,country,parent.id,longnumber", (QFilter[])new QFilter[]{filter}, (String)"level,longnumber asc");
        }
        if (this.isCountry(currentNodeId)) {
            return QueryServiceHelper.query((String)"bd_admindivision", (String)"id,number,name,level,isleaf,country,parent.id,longnumber", (QFilter[])new QFilter[]{new QFilter("country", "=", (Object)Long.valueOf(currentNodeId)).and(filter)}, (String)"level,longnumber asc");
        }
        DynamicObjectCollection dyoCol = new DynamicObjectCollection();
        DynamicObject currentNode = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id,number,name,level,isleaf,country,parent.id,longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(currentNodeId)).and(filter)});
        dyoCol.add((Object)currentNode);
        if (null == currentNode) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u5730\u5740\u8282\u70b9\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractAddressMatcher_0", (String)"scm-pbd-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection res = QueryServiceHelper.query((String)"bd_admindivision", (String)"id,number,name,level,isleaf,country,parent.id,longnumber", (QFilter[])new QFilter[]{new QFilter("longnumber", "like", (Object)(currentNode.getString("longnumber") + ".%")).and(filter)}, (String)"level,longnumber asc");
        if (!CollectionUtils.isEmpty((Collection)res)) {
            dyoCol.addAll((Collection)res);
        }
        return dyoCol;
    }

    private boolean isCountry(String nodeId) {
        return !nodeId.equals("8609760E-EF83-4775-A9FF-CCDEC7C0B689") && Long.parseLong(nodeId) >= (long)COUNTRY_NUMBER.intValue() && Long.parseLong(nodeId) < (long)(COUNTRY_NUMBER + 100);
    }

    public boolean isGHT(String countryId) {
        return this.isMACAO(countryId) || this.isHONGKONG(countryId) || this.isTAIWAN(countryId);
    }

    private boolean isMACAO(String countryId) {
        return StringUtils.equals((CharSequence)"1000003", (CharSequence)countryId);
    }

    private boolean isHONGKONG(String countryId) {
        return StringUtils.equals((CharSequence)"1000004", (CharSequence)countryId);
    }

    private boolean isTAIWAN(String countryId) {
        return StringUtils.equals((CharSequence)"1000005", (CharSequence)countryId);
    }

    protected boolean isRootId(String nodeId) {
        return StringUtils.equals((CharSequence)"8609760E-EF83-4775-A9FF-CCDEC7C0B689", (CharSequence)nodeId);
    }

    protected int getValidAddrCount() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter countryFilter = new QFilter("country", "=", (Object)1000001L);
        QFilter levelFilter = new QFilter("level", "in", (Object)new ArrayList<Integer>(){
            {
                this.add(1);
                this.add(2);
                this.add(3);
            }
        });
        QFilter filter = new QFilter("issystem", "=", (Object)"1");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AbstractAddressMatcher", (String)"bd_admindivision", (String)"id", (QFilter[])new QFilter[]{enableFilter, countryFilter, levelFilter, filter}, null);){
            int n = ds.count("id", true);
            return n;
        }
    }

    protected void fillToFourthLevel(AddressTreeNode node) {
        String rootNodeLongNumber = node.getLongnumber();
        final AddressTreeNode second = new AddressTreeNode(node.getId(), node.getId(), node.getName(), rootNodeLongNumber + "." + node.getLongnumber(), 2);
        List third = node.getChildAddressList();
        this.resetNode(third, rootNodeLongNumber);
        second.setChildAddressList(third);
        node.setChildAddressList((List)new ArrayList<AddressTreeNode>(){
            {
                this.add(second);
            }
        });
    }

    protected void resetNode(List<AddressTreeNode> nodes, String rootNodeLongNumber) {
        for (AddressTreeNode child : nodes) {
            child.setLevel(child.getLevel() + 1);
            child.setLongnumber(rootNodeLongNumber + "." + child.getLongnumber());
        }
    }
}

