/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.address;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.pbd.service.address.IAddressMatcher;
import kd.scm.pbd.service.address.impl.CgAddressMatcher;
import kd.scm.pbd.service.address.impl.DlAddressMatcher;
import kd.scm.pbd.service.address.impl.JdAddressMatcher;
import kd.scm.pbd.service.address.impl.SnAddressMatcher;
import kd.scm.pbd.service.address.impl.XfsAddressMatcher;
import kd.scm.pbd.service.address.impl.XyAddressMatcher;

public class AddressMatchFactory {
    private static final Map<String, IAddressMatcher> FACTORIES = new HashMap<String, IAddressMatcher>(8);

    public static final IAddressMatcher getFactory(String ecType) {
        if (StringUtils.isBlank((CharSequence)ecType) || null == FACTORIES.get(ecType)) {
            throw new KDBizException("Init " + EcPlatformEnum.valueOf((String)ecType).name() + " AddressMatcher Failed!");
        }
        return FACTORIES.get(ecType);
    }

    public static final void registerFactory(String ecType, IAddressMatcher factory) {
        if (StringUtils.isBlank((CharSequence)ecType)) {
            throw new KDBizException("ecType can not be null or empty String !");
        }
        if (null == factory) {
            throw new KDBizException("register " + ecType + " AddressMatcher Failed!");
        }
        FACTORIES.putIfAbsent(ecType, factory);
    }

    static {
        FACTORIES.put(EcPlatformEnum.ECPLATFORM_CG.getVal(), new CgAddressMatcher());
        FACTORIES.put(EcPlatformEnum.ECPLATFORM_XY.getVal(), new XyAddressMatcher());
        FACTORIES.put(EcPlatformEnum.ECPLATFORM_JD.getVal(), new JdAddressMatcher());
        FACTORIES.put(EcPlatformEnum.ECPLATFORM_SUNING.getVal(), new SnAddressMatcher());
        FACTORIES.put(EcPlatformEnum.ECPLATFORM_DL.getVal(), new DlAddressMatcher());
        FACTORIES.put(EcPlatformEnum.ECPLATFORM_XFS.getVal(), new XfsAddressMatcher());
    }
}

