/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.address.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.orm.query.QFilter;
import kd.scm.pbd.common.entity.AddressTreeNode;
import kd.scm.pbd.service.address.AbstractAddressMatcher;

public class CgAddressMatcher
extends AbstractAddressMatcher {
    private static final long XIAN_TAO = 1692L;
    private static final long QIAN_JIANG = 1718L;
    private static final long TIAN_MEN = 1744L;
    private static final long SHEN_NONG_JIA = 1773L;
    private static final long JI_YUAN = 1478L;
    private static final long HAI_NAN = 809L;
    private static final long DAN_ZHOU = 856L;
    private static final long SAN_SHA = 828L;
    private static final long SAN_YA = 815L;
    private static final long HAI_KOU = 810L;
    private static final List<Long> HAI_NAN_ID_LIST = Arrays.asList(856L, 828L, 810L, 815L);
    private static final Map<Long, Long> HAI_NAN_MAP = new HashMap<Long, Long>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(899L, 1200564872547450880L);
            this.put(917L, 1200564873008824320L);
            this.put(930L, 1200564873327591424L);
            this.put(944L, 1200564873654748160L);
            this.put(955L, 1200564873990292480L);
            this.put(985L, 1200564874787210240L);
            this.put(1000L, 1200564875047257088L);
            this.put(1011L, 1200564875558962176L);
            this.put(831L, 1200564871557595136L);
            this.put(840L, 1200564871951859712L);
            this.put(878L, 1200564872228683776L);
            this.put(1028L, 1200564876079055872L);
            this.put(1043L, 1200564876456543232L);
            this.put(1057L, 1200564876750144512L);
            this.put(972L, 1200564874451664896L);
        }
    };
    private static final long WU_JIA_QU = 3302L;
    private static final long TU_MU_SHU = 3291L;
    private static final long A_LA_ER = 3272L;
    private static final long SHI_HE_ZI = 3264L;
    private static final long DONG_GUAN = 511L;
    private static final long ZHONG_SHAN = 547L;
    private static final long JIA_YU_GUAN = 285L;
    private static final long HUBEI_DER = 1200563968297452544L;
    private static final long EC_XIAN_TAO = 1200564730217939968L;
    private static final long EC_QIAN_JIANG = 1200564730461209600L;
    private static final long EC_TIAN_MEN = 1200564730704479232L;
    private static final long EC_SHEN_NONG_JIA = 1200564731023246336L;
    private static final long HENAN_DER = 1200563960118559744L;
    private static final long EC_JI_YUAN = 1200564691772949504L;
    private static final long EC_HAI_NAN = 1200563987188597760L;
    private static final long EC_DAN_ZHOU = 1200564871272382464L;
    private static final long EC_DONG_GUAN = 1200564810278813696L;
    private static final long EC_ZHONG_SHAN = 1200564810740187136L;
    private static final long EC_JIA_YU_GUAN = 1200565176022123520L;
    private static final long EC_HEI_LONG_JIANG = 1200564048224108544L;
    private static final long EC_WU_JIA_QU = 1200565266669420544L;
    private static final long EC_TU_MU_SHU = 1200565266384208896L;
    private static final long EC_A_LA_ER = 1200565265948000256L;
    private static final long EC_SHI_HE_ZI = 1200565265553735680L;

    @Override
    public int matchBdAddressWithEcAddress(List<AddressTreeNode> bdAddressTreeNodeList, List<AddressTreeNode> ecAddressTreeNodeList) {
        AtomicInteger cnt = new AtomicInteger();
        boolean bdAddrVersion = this.getValidAddrCount() <= 3500;
        this.match(bdAddressTreeNodeList, ecAddressTreeNodeList, cnt, bdAddrVersion);
        return cnt.get();
    }

    @Override
    public boolean specialRuleMatch(AddressTreeNode bdNode, AddressTreeNode ecNode, boolean bdAddrVersion) {
        long bdAddressId = bdNode.getId();
        long ecAddressId = ecNode.getId();
        if ((bdAddressId == 1692L || bdAddressId == 1718L || bdAddressId == 1744L || bdAddressId == 1773L) && ecAddressId == 1200563968297452544L) {
            return true;
        }
        if (bdAddressId == 1478L && ecAddressId == 1200563960118559744L) {
            return true;
        }
        if ((bdAddressId == 3302L || bdAddressId == 3291L || bdAddressId == 3272L || bdAddressId == 3264L) && ecAddressId == 1200564048224108544L) {
            return true;
        }
        if (bdNode.getParentId() == 809L && !HAI_NAN_ID_LIST.contains(bdNode.getId()) && ecAddressId == 1200563987188597760L) {
            return true;
        }
        if (bdNode.getParentId() == 1692L && ecAddressId == 1200564730217939968L || bdNode.getParentId() == 1718L && ecAddressId == 1200564730461209600L || bdNode.getParentId() == 1744L && ecAddressId == 1200564730704479232L || bdNode.getParentId() == 1773L && ecAddressId == 1200564731023246336L) {
            return true;
        }
        if (bdNode.getParentId() == 1478L && ecAddressId == 1200564691772949504L) {
            return true;
        }
        if (bdNode.getParentId() == 511L && ecAddressId == 1200564810278813696L || bdNode.getParentId() == 547L && ecAddressId == 1200564810740187136L) {
            return true;
        }
        if (bdNode.getParentId() == 285L && ecAddressId == 1200565176022123520L) {
            return true;
        }
        if (bdNode.getParentId() == 856L && ecAddressId == 1200564871272382464L) {
            return true;
        }
        if (HAI_NAN_MAP.containsKey(bdNode.getParentId()) && ecAddressId == HAI_NAN_MAP.get(bdNode.getParentId())) {
            return true;
        }
        return bdNode.getParentId() == 3302L && ecAddressId == 1200565266669420544L || bdNode.getParentId() == 3291L && ecAddressId == 1200565266384208896L || bdNode.getParentId() == 3272L && ecAddressId == 1200565265948000256L || bdNode.getParentId() == 3264L && ecAddressId == 1200565265553735680L;
    }

    @Override
    public void handleAfterBuildNodeResult(List<AddressTreeNode> resultList, boolean isMatchSource) {
        if (this.getValidAddrCount() <= 3500 && isMatchSource) {
            for (AddressTreeNode node : resultList) {
                if (!DIRECT_PROVINCE_ID_LIST.contains(node.getId())) continue;
                this.fillToFourthLevel(node);
            }
        }
        if (!isMatchSource && null != resultList) {
            for (AddressTreeNode node : resultList) {
                if (node.getId() != 1200563892246332416L) continue;
                ((AddressTreeNode)node.getChildAddressList().get(0)).addAllChilds(((AddressTreeNode)node.getChildAddressList().get(1)).getChildAddressList());
                node.getChildAddressList().remove(1);
            }
        }
    }

    @Override
    public QFilter getBdAddrFilter() {
        QFilter levelFilter = new QFilter("level", "in", (Object)new ArrayList<Integer>(){
            {
                this.add(1);
                this.add(2);
                this.add(3);
            }
        });
        QFilter filter = new QFilter("issystem", "=", (Object)"1");
        return new QFilter("enable", "=", (Object)"1").and(levelFilter).and(filter);
    }
}

