/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.address.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.orm.query.QFilter;
import kd.scm.pbd.common.entity.AddressTreeNode;
import kd.scm.pbd.service.address.AbstractAddressMatcher;

public class DlAddressMatcher
extends AbstractAddressMatcher {
    private static final long XIANG_XI = 1907L;
    private static final long JI_SHOU = 1284902166376530944L;

    @Override
    public int matchBdAddressWithEcAddress(List<AddressTreeNode> bdAddressTreeNodeList, List<AddressTreeNode> ecAddressTreeNodeList) {
        AtomicInteger cnt = new AtomicInteger();
        boolean bdAddrVersion = this.getValidAddrCount() <= 3500;
        this.match(bdAddressTreeNodeList, ecAddressTreeNodeList, cnt, bdAddrVersion);
        return cnt.get();
    }

    @Override
    public boolean specialRuleMatch(AddressTreeNode bdNode, AddressTreeNode ecNode, boolean bdAddrVersion) {
        return bdNode.getId() == 1907L && ecNode.getId() == 1284902166376530944L;
    }

    @Override
    public void handleAfterBuildNodeResult(List<AddressTreeNode> resultList, boolean isMatchSource) {
        if (this.getValidAddrCount() <= 3500 && isMatchSource) {
            for (AddressTreeNode node : resultList) {
                if (!DIRECT_PROVINCE_ID_LIST.contains(node.getId())) continue;
                this.fillToFourthLevel(node);
            }
        }
    }

    @Override
    protected void fillToFourthLevel(AddressTreeNode node) {
        List childs = node.getChildAddressList();
        for (AddressTreeNode child : childs) {
            final AddressTreeNode third = new AddressTreeNode(child.getId(), child.getId(), child.getName(), child.getLongnumber() + "." + child.getId(), 3);
            child.setChildAddressList((List)new ArrayList<AddressTreeNode>(){
                {
                    this.add(third);
                }
            });
        }
    }

    @Override
    public QFilter getBdAddrFilter() {
        QFilter levelFilter = new QFilter("level", "in", (Object)new ArrayList<Integer>(){
            {
                this.add(1);
                this.add(2);
                this.add(3);
            }
        });
        QFilter filter = new QFilter("issystem", "=", (Object)"1");
        return new QFilter("enable", "=", (Object)"1").and(levelFilter).and(filter);
    }
}

