/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.address.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.orm.query.QFilter;
import kd.scm.pbd.common.entity.AddressTreeNode;
import kd.scm.pbd.service.address.AbstractAddressMatcher;

public class SnAddressMatcher
extends AbstractAddressMatcher {
    private static final long XIAN_TAO = 1692L;
    private static final long QIAN_JIANG = 1718L;
    private static final long TIAN_MEN = 1744L;
    private static final long SHEN_NONG_JIA = 1773L;
    private static final long JI_YUAN = 1478L;
    private static final Map<Long, Long> HAI_NAN_DIR_MAP = new HashMap<Long, Long>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(930L, 1206550968435519488L);
            this.put(944L, 1206550967361777664L);
            this.put(955L, 1206550967881872384L);
            this.put(985L, 1206550965868606464L);
            this.put(1000L, 1206550969878361088L);
            this.put(1011L, 1206550969517649920L);
            this.put(1028L, 1206550966288035840L);
            this.put(1043L, 1206550965356900352L);
            this.put(1057L, 1206550969114997760L);
            this.put(972L, 1206550966724244480L);
        }
    };
    private static final Map<Long, Long> HAI_NAN_SIG_MAP = new HashMap<Long, Long>(){
        private static final long serialVersionUID = 2L;
        {
            this.put(840L, 1206550970574615552L);
            this.put(878L, 1206550972134896640L);
            this.put(856L, 1206550960072077312L);
            this.put(831L, 1206550970239070208L);
            this.put(917L, 1206550961548473344L);
            this.put(899L, 1206550971530915840L);
        }
    };
    private static final long WU_JIA_QU = 3302L;
    private static final long TU_MU_SHU = 3291L;
    private static final long A_LA_ER = 3272L;
    private static final long SHI_HE_ZI = 3264L;
    private static final long DONG_GUAN = 511L;
    private static final long ZHONG_SHAN = 547L;
    private static final long HUBEI_DER = 1206549541256474624L;
    private static final long EC_XIAN_TAO = 1206550741313958912L;
    private static final long EC_QIAN_JIANG = 1206550740240217088L;
    private static final long EC_TIAN_MEN = 1206550740726755328L;
    private static final long EC_SHEN_NONG_JIA = 1206550714378137600L;
    private static final long EC_JI_YUAN = 1206550840517637120L;
    private static final long EC_HAI_NAN = 1206549573074464768L;
    private static final long EC_DONG_GUAN = 1206550923648741376L;
    private static final long EC_ZHONG_SHAN = 1206550910822560768L;
    private static final long EC_WU_JIA_QU = 1206551569756106752L;
    private static final long EC_TU_MU_SHU = 1206551569261179904L;
    private static final long EC_A_LA_ER = 1206551594250843136L;
    private static final long EC_SHI_HE_ZI = 1206551600886232064L;

    @Override
    public int matchBdAddressWithEcAddress(List<AddressTreeNode> bdAddressTreeNodeList, List<AddressTreeNode> ecAddressTreeNodeList) {
        AtomicInteger cnt = new AtomicInteger();
        boolean bdAddrVersion = this.getValidAddrCount() <= 3500;
        this.match(bdAddressTreeNodeList, ecAddressTreeNodeList, cnt, bdAddrVersion);
        return cnt.get();
    }

    @Override
    public boolean specialRuleMatch(AddressTreeNode bdNode, AddressTreeNode ecNode, boolean bdAddrVersion) {
        long bdAddressId = bdNode.getId();
        long ecAddressId = ecNode.getId();
        if ((bdAddressId == 1692L || bdAddressId == 1718L || bdAddressId == 1744L) && ecAddressId == 1206549541256474624L) {
            return true;
        }
        if (HAI_NAN_DIR_MAP.containsKey(bdAddressId) && ecAddressId == 1206549573074464768L) {
            return true;
        }
        if (bdNode.getParentId() == 1692L && ecAddressId == 1206550741313958912L || bdNode.getParentId() == 1718L && ecAddressId == 1206550740240217088L || bdNode.getParentId() == 1744L && ecAddressId == 1206550740726755328L || bdNode.getParentId() == 1773L && ecAddressId == 1206550714378137600L) {
            return true;
        }
        if (bdNode.getParentId() == 1478L && ecAddressId == 1206550840517637120L) {
            return true;
        }
        if (bdNode.getParentId() == 3302L && ecAddressId == 1206551569756106752L || bdNode.getParentId() == 3291L && ecAddressId == 1206551569261179904L || bdNode.getParentId() == 3272L && ecAddressId == 1206551594250843136L || bdNode.getParentId() == 3264L && ecAddressId == 1206551600886232064L) {
            return true;
        }
        if (bdNode.getParentId() == 511L && ecAddressId == 1206550923648741376L || bdNode.getParentId() == 547L && ecAddressId == 1206550910822560768L) {
            return true;
        }
        return HAI_NAN_SIG_MAP.containsKey(bdNode.getParentId()) && ecAddressId == HAI_NAN_SIG_MAP.get(bdNode.getParentId()) || HAI_NAN_DIR_MAP.containsKey(bdNode.getParentId()) && ecAddressId == HAI_NAN_DIR_MAP.get(bdNode.getParentId());
    }

    @Override
    public void handleAfterBuildNodeResult(List<AddressTreeNode> resultList, boolean isMatchSource) {
        if (this.getValidAddrCount() <= 3500 && isMatchSource) {
            for (AddressTreeNode node : resultList) {
                if (!DIRECT_PROVINCE_ID_LIST.contains(node.getId())) continue;
                this.fillToFourthLevel(node);
            }
        }
    }

    @Override
    public QFilter getBdAddrFilter() {
        QFilter levelFilter = new QFilter("level", "in", (Object)new ArrayList<Integer>(){
            {
                this.add(1);
                this.add(2);
                this.add(3);
            }
        });
        QFilter filter = new QFilter("issystem", "=", (Object)"1");
        return new QFilter("enable", "=", (Object)"1").and(levelFilter).and(filter);
    }
}

